/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.arguments.consumer;

import org.apache.servicecomb.swagger.invocation.SwaggerInvocation;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentMapper;
import org.apache.servicecomb.swagger.invocation.converter.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConsumerArgumentSame
implements ArgumentMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerArgumentSame.class);
    private int consumerIdx;
    private int swaggerIdx;
    private Converter converter;

    public ConsumerArgumentSame(int consumerIdx, int swaggerIdx, Converter converter) {
        this.consumerIdx = consumerIdx;
        this.swaggerIdx = swaggerIdx;
        this.converter = converter;
    }

    @Override
    public void mapArgument(SwaggerInvocation invocation, Object[] consumerArguments) {
        if (null == consumerArguments[this.consumerIdx]) {
            LOGGER.debug("null argument is ignored, consumerIdx = [{}]", (Object)this.consumerIdx);
            return;
        }
        Object swaggerParam = this.converter.convert(consumerArguments[this.consumerIdx]);
        invocation.setSwaggerArgument(this.swaggerIdx, swaggerParam);
    }
}

