/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.codegen.AbstractGenerator;
import io.swagger.codegen.ClientOptInput;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenSecurity;
import io.swagger.codegen.Generator;
import io.swagger.codegen.GlobalSupportingFile;
import io.swagger.codegen.InlineModelResolver;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.ignore.CodegenIgnoreProcessor;
import io.swagger.codegen.languages.AbstractJavaCodegen;
import io.swagger.codegen.utils.ImplementationVersion;
import io.swagger.models.ComposedModel;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Scheme;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.Parameter;
import io.swagger.util.Json;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGenerator
extends AbstractGenerator
implements Generator {
    protected final Logger LOGGER = LoggerFactory.getLogger(DefaultGenerator.class);
    protected CodegenConfig config;
    protected ClientOptInput opts;
    protected Swagger swagger;
    protected CodegenIgnoreProcessor ignoreProcessor;
    protected Boolean isGenerateApis = null;
    protected Boolean isGenerateModels = null;
    protected Boolean isGenerateSupportingFiles = null;
    protected Boolean isGenerateApiTests = null;
    protected Boolean isGenerateApiDocumentation = null;
    protected Boolean isGenerateModelTests = null;
    protected Boolean isGenerateModelDocumentation = null;
    protected Boolean isGenerateSwaggerMetadata = true;
    protected String basePath;
    protected String basePathWithoutHost;
    protected String contextPath;
    private Map<String, String> generatorPropertyDefaults = new HashMap<String, String>();

    @Override
    public Generator opts(ClientOptInput opts) {
        this.opts = opts;
        this.swagger = opts.getSwagger();
        this.config = opts.getConfig();
        this.config.additionalProperties().putAll(opts.getOpts().getProperties());
        String ignoreFileLocation = this.config.getIgnoreFilePathOverride();
        if (ignoreFileLocation != null) {
            File ignoreFile = new File(ignoreFileLocation);
            if (ignoreFile.exists() && ignoreFile.canRead()) {
                this.ignoreProcessor = new CodegenIgnoreProcessor(ignoreFile);
            } else {
                this.LOGGER.warn("Ignore file specified at {} is not valid. This will fall back to an existing ignore file if present in the output directory.", (Object)ignoreFileLocation);
            }
        }
        if (this.ignoreProcessor == null) {
            this.ignoreProcessor = new CodegenIgnoreProcessor(this.config.getOutputDir());
        }
        return this;
    }

    public void setGenerateSwaggerMetadata(Boolean generateSwaggerMetadata) {
        this.isGenerateSwaggerMetadata = generateSwaggerMetadata;
    }

    public void setGeneratorPropertyDefault(String key, String value) {
        this.generatorPropertyDefaults.put(key, value);
    }

    protected Boolean getGeneratorPropertyDefaultSwitch(String key, Boolean defaultValue) {
        String result = null;
        if (this.generatorPropertyDefaults.containsKey(key)) {
            result = this.generatorPropertyDefaults.get(key);
        }
        if (result != null) {
            return Boolean.valueOf(result);
        }
        return defaultValue;
    }

    protected String getScheme() {
        String scheme = this.swagger.getSchemes() != null && this.swagger.getSchemes().size() > 0 ? this.config.escapeText(((Scheme)this.swagger.getSchemes().get(0)).toValue()) : "https";
        scheme = this.config.escapeText(scheme);
        return scheme;
    }

    private String getHost() {
        StringBuilder hostBuilder = new StringBuilder();
        hostBuilder.append(this.getScheme());
        hostBuilder.append("://");
        if (!StringUtils.isEmpty((CharSequence)this.swagger.getHost())) {
            hostBuilder.append(this.swagger.getHost());
        } else {
            hostBuilder.append("localhost");
            this.LOGGER.warn("'host' not defined in the spec. Default to 'localhost'.");
        }
        if (!StringUtils.isEmpty((CharSequence)this.swagger.getBasePath()) && !this.swagger.getBasePath().equals("/")) {
            hostBuilder.append(this.swagger.getBasePath());
        }
        return hostBuilder.toString();
    }

    protected void configureGeneratorProperties() {
        this.isGenerateApis = System.getProperty("apis") != null ? Boolean.TRUE : this.getGeneratorPropertyDefaultSwitch("apis", null);
        this.isGenerateModels = System.getProperty("models") != null ? Boolean.TRUE : this.getGeneratorPropertyDefaultSwitch("models", null);
        Boolean bl = this.isGenerateSupportingFiles = System.getProperty("supportingFiles") != null ? Boolean.TRUE : this.getGeneratorPropertyDefaultSwitch("supportingFiles", null);
        if (this.isGenerateApis == null && this.isGenerateModels == null && this.isGenerateSupportingFiles == null) {
            this.isGenerateModels = this.isGenerateSupportingFiles = Boolean.valueOf(true);
            this.isGenerateApis = this.isGenerateSupportingFiles;
        } else {
            if (this.isGenerateApis == null) {
                this.isGenerateApis = false;
            }
            if (this.isGenerateModels == null) {
                this.isGenerateModels = false;
            }
            if (this.isGenerateSupportingFiles == null) {
                this.isGenerateSupportingFiles = false;
            }
        }
        this.isGenerateModelTests = System.getProperty("modelTests") != null ? Boolean.valueOf(System.getProperty("modelTests")) : this.getGeneratorPropertyDefaultSwitch("modelTests", true);
        this.isGenerateModelDocumentation = System.getProperty("modelDocs") != null ? Boolean.valueOf(System.getProperty("modelDocs")) : this.getGeneratorPropertyDefaultSwitch("modelDocs", true);
        this.isGenerateApiTests = System.getProperty("apiTests") != null ? Boolean.valueOf(System.getProperty("apiTests")) : this.getGeneratorPropertyDefaultSwitch("apiTests", true);
        this.isGenerateApiDocumentation = System.getProperty("apiDocs") != null ? Boolean.valueOf(System.getProperty("apiDocs")) : this.getGeneratorPropertyDefaultSwitch("apiDocs", true);
        this.config.additionalProperties().put("generateApiTests", this.isGenerateApiTests);
        this.config.additionalProperties().put("generateModelTests", this.isGenerateModelTests);
        this.config.additionalProperties().put("generateApiDocs", this.isGenerateApiDocumentation);
        this.config.additionalProperties().put("generateModelDocs", this.isGenerateModelDocumentation);
        this.config.additionalProperties().put("generateApis", this.isGenerateApis);
        this.config.additionalProperties().put("generateModels", this.isGenerateModels);
        if (!this.isGenerateApiTests.booleanValue() && !this.isGenerateModelTests.booleanValue()) {
            this.config.additionalProperties().put("excludeTests", true);
        }
        if (System.getProperty("debugSwagger") != null) {
            Json.prettyPrint((Object)this.swagger);
        }
        this.config.processOpts();
        this.config.preprocessSwagger(this.swagger);
        this.config.additionalProperties().put("generatorVersion", ImplementationVersion.read());
        this.config.additionalProperties().put("generatedDate", DateTime.now().toString());
        this.config.additionalProperties().put("generatedYear", String.valueOf(DateTime.now().getYear()));
        this.config.additionalProperties().put("generatorClass", this.config.getClass().getName());
        this.config.additionalProperties().put("inputSpec", this.config.getInputSpec());
        if (this.swagger.getVendorExtensions() != null) {
            this.config.vendorExtensions().putAll(this.swagger.getVendorExtensions());
        }
        this.contextPath = this.config.escapeText(this.swagger.getBasePath() == null ? "" : this.swagger.getBasePath());
        this.basePath = this.config.escapeText(this.getHost());
        this.basePathWithoutHost = this.config.escapeText(this.swagger.getBasePath());
    }

    protected void configureSwaggerInfo() {
        Info info = this.swagger.getInfo();
        if (info == null) {
            return;
        }
        if (info.getTitle() != null) {
            this.config.additionalProperties().put("appName", this.config.escapeText(info.getTitle()));
        }
        if (info.getVersion() != null) {
            this.config.additionalProperties().put("appVersion", this.config.escapeText(info.getVersion()));
        } else {
            this.LOGGER.error("Missing required field info version. Default appVersion set to 1.0.0");
            this.config.additionalProperties().put("appVersion", "1.0.0");
        }
        if (StringUtils.isEmpty((CharSequence)info.getDescription())) {
            this.config.additionalProperties().put("appDescription", "No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)");
            this.config.additionalProperties().put("unescapedAppDescription", "No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)");
        } else {
            this.config.additionalProperties().put("appDescription", this.config.escapeText(info.getDescription()));
            this.config.additionalProperties().put("unescapedAppDescription", info.getDescription());
        }
        if (info.getContact() != null) {
            Contact contact = info.getContact();
            if (contact.getEmail() != null) {
                this.config.additionalProperties().put("infoEmail", this.config.escapeText(contact.getEmail()));
            }
            if (contact.getName() != null) {
                this.config.additionalProperties().put("infoName", this.config.escapeText(contact.getName()));
            }
            if (contact.getUrl() != null) {
                this.config.additionalProperties().put("infoUrl", this.config.escapeText(contact.getUrl()));
            }
        }
        if (info.getLicense() != null) {
            License license = info.getLicense();
            if (license.getName() != null) {
                this.config.additionalProperties().put("licenseInfo", this.config.escapeText(license.getName()));
            }
            if (license.getUrl() != null) {
                this.config.additionalProperties().put("licenseUrl", this.config.escapeText(license.getUrl()));
            }
        }
        if (info.getVersion() != null) {
            this.config.additionalProperties().put("version", this.config.escapeText(info.getVersion()));
        } else {
            this.LOGGER.error("Missing required field info version. Default version set to 1.0.0");
            this.config.additionalProperties().put("version", "1.0.0");
        }
        if (info.getTermsOfService() != null) {
            this.config.additionalProperties().put("termsOfService", this.config.escapeText(info.getTermsOfService()));
        }
    }

    protected void generateModelTests(List<File> files, Map<String, Object> models, String modelName) throws IOException {
        for (String templateName : this.config.modelTestTemplateFiles().keySet()) {
            String suffix = this.config.modelTestTemplateFiles().get(templateName);
            String filename = this.config.modelTestFileFolder() + File.separator + this.config.toModelTestFilename(modelName) + suffix;
            if (new File(filename).exists()) {
                this.LOGGER.info("File exists. Skipped overwriting " + filename);
                continue;
            }
            File written = this.processTemplateToFile(models, templateName, filename);
            if (written == null) continue;
            files.add(written);
        }
    }

    protected void generateModelDocumentation(List<File> files, Map<String, Object> models, String modelName) throws IOException {
        for (String templateName : this.config.modelDocTemplateFiles().keySet()) {
            String suffix = this.config.modelDocTemplateFiles().get(templateName);
            String filename = this.config.modelDocFileFolder() + File.separator + this.config.toModelDocFilename(modelName) + suffix;
            if (!this.config.shouldOverwrite(filename)) {
                this.LOGGER.info("Skipped overwriting " + filename);
                continue;
            }
            File written = this.processTemplateToFile(models, templateName, filename);
            if (written == null) continue;
            files.add(written);
        }
    }

    protected void generateModels(List<File> files, List<Object> allModels) {
        if (!this.isGenerateModels.booleanValue()) {
            return;
        }
        final Map definitions = this.swagger.getDefinitions();
        if (definitions == null) {
            return;
        }
        String modelNames = System.getProperty("models");
        HashSet<String> modelsToGenerate = null;
        if (modelNames != null && !modelNames.isEmpty()) {
            modelsToGenerate = new HashSet<String>(Arrays.asList(modelNames.split(",")));
        }
        Set modelKeys = definitions.keySet();
        if (modelsToGenerate != null && !modelsToGenerate.isEmpty()) {
            HashSet updatedKeys = new HashSet();
            for (String m : modelKeys) {
                if (!modelsToGenerate.contains(m)) continue;
                updatedKeys.add(m);
            }
            modelKeys = updatedKeys;
        }
        Map<String, Object> allProcessedModels = new TreeMap<String, Object>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int model2InheritanceDepth;
                Model model1 = (Model)definitions.get(o1);
                Model model2 = (Model)definitions.get(o2);
                int model1InheritanceDepth = this.getInheritanceDepth(model1);
                if (model1InheritanceDepth == (model2InheritanceDepth = this.getInheritanceDepth(model2))) {
                    return ObjectUtils.compare((Comparable)((Object)DefaultGenerator.this.config.toModelName(o1)), (Comparable)((Object)DefaultGenerator.this.config.toModelName(o2)));
                }
                if (model1InheritanceDepth > model2InheritanceDepth) {
                    return 1;
                }
                return -1;
            }

            private int getInheritanceDepth(Model model) {
                int inheritanceDepth = 0;
                Model parent = this.getParent(model);
                while (parent != null) {
                    ++inheritanceDepth;
                    parent = this.getParent(parent);
                }
                return inheritanceDepth;
            }

            private Model getParent(Model model) {
                if (model instanceof ComposedModel) {
                    List interfaces;
                    Model parent = ((ComposedModel)model).getParent();
                    if (parent == null && (interfaces = ((ComposedModel)model).getInterfaces()).size() > 0) {
                        RefModel interf = (RefModel)interfaces.get(0);
                        return (Model)definitions.get(interf.getSimpleRef());
                    }
                    if (parent != null) {
                        return (Model)definitions.get(parent.getReference());
                    }
                }
                return null;
            }
        });
        for (String name : modelKeys) {
            try {
                if (this.config.importMapping().containsKey(name)) {
                    this.LOGGER.info("Model " + name + " not imported due to import mapping");
                    continue;
                }
                Model model = (Model)definitions.get(name);
                HashMap<String, Model> modelMap = new HashMap<String, Model>();
                modelMap.put(name, model);
                Map<String, Object> models = this.processModels(this.config, modelMap, definitions);
                if (models == null) continue;
                models.put("classname", this.config.toModelName(name));
                models.putAll(this.config.additionalProperties());
                allProcessedModels.put(name, models);
            }
            catch (Exception e) {
                String message = "Could not process model '" + name + "'. Please make sure that your schema is correct!";
                this.LOGGER.error(message, (Throwable)e);
                throw new RuntimeException(message, e);
            }
        }
        allProcessedModels = this.config.postProcessAllModels(allProcessedModels);
        for (String modelName : allProcessedModels.keySet()) {
            Map models = (Map)allProcessedModels.get(modelName);
            models.put("modelPackage", this.config.modelPackage());
            try {
                if (this.config.importMapping().containsKey(modelName)) continue;
                Map modelTemplate = (Map)((List)models.get("models")).get(0);
                if (this.config instanceof AbstractJavaCodegen && modelTemplate != null && modelTemplate.containsKey("model")) {
                    CodegenModel m = (CodegenModel)modelTemplate.get("model");
                    if (m.isAlias) continue;
                }
                allModels.add(modelTemplate);
                for (String templateName : this.config.modelTemplateFiles().keySet()) {
                    String suffix = this.config.modelTemplateFiles().get(templateName);
                    String filename = this.config.modelFileFolder() + File.separator + this.config.toModelFilename(modelName) + suffix;
                    if (!this.config.shouldOverwrite(filename)) {
                        this.LOGGER.info("Skipped overwriting " + filename);
                        continue;
                    }
                    File written = this.processTemplateToFile(models, templateName, filename);
                    if (written == null) continue;
                    files.add(written);
                }
                if (this.isGenerateModelTests.booleanValue()) {
                    this.generateModelTests(files, models, modelName);
                }
                if (!this.isGenerateModelDocumentation.booleanValue()) continue;
                this.generateModelDocumentation(files, models, modelName);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not generate model '" + modelName + "'", e);
            }
        }
        if (System.getProperty("debugModels") != null) {
            this.LOGGER.info("############ Model info ############");
            Json.prettyPrint(allModels);
        }
    }

    protected void generateApis(List<File> files, List<Object> allOperations, List<Object> allModels) {
        if (!this.isGenerateApis.booleanValue()) {
            return;
        }
        Map<String, List<CodegenOperation>> paths = this.processPaths(this.swagger.getPaths());
        HashSet<String> apisToGenerate = null;
        String apiNames = System.getProperty("apis");
        if (apiNames != null && !apiNames.isEmpty()) {
            apisToGenerate = new HashSet<String>(Arrays.asList(apiNames.split(",")));
        }
        if (apisToGenerate != null && !apisToGenerate.isEmpty()) {
            TreeMap<String, List<CodegenOperation>> updatedPaths = new TreeMap<String, List<CodegenOperation>>();
            for (String m : paths.keySet()) {
                if (!apisToGenerate.contains(m)) continue;
                updatedPaths.put(m, paths.get(m));
            }
            paths = updatedPaths;
        }
        for (String tag : paths.keySet()) {
            try {
                File written;
                String filename;
                List<CodegenOperation> ops = paths.get(tag);
                Collections.sort(ops, new Comparator<CodegenOperation>(){

                    @Override
                    public int compare(CodegenOperation one, CodegenOperation another) {
                        return ObjectUtils.compare((Comparable)((Object)one.operationId), (Comparable)((Object)another.operationId));
                    }
                });
                Map<String, Object> operation = this.processOperations(this.config, tag, ops, allModels);
                operation.put("basePath", this.basePath);
                operation.put("basePathWithoutHost", this.basePathWithoutHost);
                operation.put("contextPath", this.contextPath);
                operation.put("baseName", tag);
                operation.put("apiPackage", this.config.apiPackage());
                operation.put("modelPackage", this.config.modelPackage());
                operation.putAll(this.config.additionalProperties());
                operation.put("classname", this.config.toApiName(tag));
                operation.put("classVarName", this.config.toApiVarName(tag));
                operation.put("importPath", this.config.toApiImport(tag));
                operation.put("classFilename", this.config.toApiFilename(tag));
                if (!this.config.vendorExtensions().isEmpty()) {
                    operation.put("vendorExtensions", this.config.vendorExtensions());
                }
                boolean sortParamsByRequiredFlag = true;
                if (this.config.additionalProperties().containsKey("sortParamsByRequiredFlag")) {
                    sortParamsByRequiredFlag = Boolean.valueOf(this.config.additionalProperties().get("sortParamsByRequiredFlag").toString());
                }
                operation.put("sortParamsByRequiredFlag", sortParamsByRequiredFlag);
                DefaultGenerator.processMimeTypes(this.swagger.getConsumes(), operation, "consumes");
                DefaultGenerator.processMimeTypes(this.swagger.getProduces(), operation, "produces");
                allOperations.add(new HashMap<String, Object>(operation));
                for (int i = 0; i < allOperations.size(); ++i) {
                    Map oo = (Map)allOperations.get(i);
                    if (i >= allOperations.size() - 1) continue;
                    oo.put("hasMore", "true");
                }
                for (String templateName : this.config.apiTemplateFiles().keySet()) {
                    filename = this.config.apiFilename(templateName, tag);
                    if (!this.config.shouldOverwrite(filename) && new File(filename).exists()) {
                        this.LOGGER.info("Skipped overwriting " + filename);
                        continue;
                    }
                    written = this.processTemplateToFile(operation, templateName, filename);
                    if (written == null) continue;
                    files.add(written);
                }
                if (this.isGenerateApiTests.booleanValue()) {
                    for (String templateName : this.config.apiTestTemplateFiles().keySet()) {
                        filename = this.config.apiTestFilename(templateName, tag);
                        if (new File(filename).exists()) {
                            this.LOGGER.info("File exists. Skipped overwriting " + filename);
                            continue;
                        }
                        written = this.processTemplateToFile(operation, templateName, filename);
                        if (written == null) continue;
                        files.add(written);
                    }
                }
                if (!this.isGenerateApiDocumentation.booleanValue()) continue;
                for (String templateName : this.config.apiDocTemplateFiles().keySet()) {
                    filename = this.config.apiDocFilename(templateName, tag);
                    if (!this.config.shouldOverwrite(filename) && new File(filename).exists()) {
                        this.LOGGER.info("Skipped overwriting " + filename);
                        continue;
                    }
                    written = this.processTemplateToFile(operation, templateName, filename);
                    if (written == null) continue;
                    files.add(written);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not generate api file for '" + tag + "'", e);
            }
        }
        if (System.getProperty("debugOperations") != null) {
            this.LOGGER.info("############ Operation info ############");
            Json.prettyPrint(allOperations);
        }
    }

    protected void generateSupportingFiles(List<File> files, Map<String, Object> bundle) {
        if (!this.isGenerateSupportingFiles.booleanValue()) {
            return;
        }
        HashSet<String> supportingFilesToGenerate = null;
        String supportingFiles = System.getProperty("supportingFiles");
        if (supportingFiles != null && !supportingFiles.isEmpty()) {
            supportingFilesToGenerate = new HashSet<String>(Arrays.asList(supportingFiles.split(",")));
        }
        for (SupportingFile support : this.config.supportingFiles()) {
            try {
                String outputFilename;
                File of;
                String outputFolder = this.config.outputFolder();
                if (StringUtils.isNotEmpty((CharSequence)support.folder)) {
                    outputFolder = outputFolder + File.separator + support.folder;
                }
                if (!(of = new File(outputFolder)).isDirectory()) {
                    of.mkdirs();
                }
                if (!this.config.shouldOverwrite(outputFilename = outputFolder + File.separator + support.destinationFilename.replace('/', File.separatorChar))) {
                    this.LOGGER.info("Skipped overwriting " + outputFilename);
                    continue;
                }
                String templateFile = support instanceof GlobalSupportingFile ? this.config.getCommonTemplateDir() + File.separator + support.templateFile : this.getFullTemplateFile(this.config, support.templateFile);
                boolean shouldGenerate = true;
                if (supportingFilesToGenerate != null && !supportingFilesToGenerate.isEmpty()) {
                    shouldGenerate = supportingFilesToGenerate.contains(support.destinationFilename);
                }
                if (!shouldGenerate) continue;
                if (this.ignoreProcessor.allowsFile(new File(outputFilename))) {
                    if (templateFile.endsWith("mustache")) {
                        String template = this.readTemplate(templateFile);
                        Mustache.Compiler compiler = Mustache.compiler();
                        compiler = this.config.processCompiler(compiler);
                        Template tmpl = compiler.withLoader(new Mustache.TemplateLoader(){

                            public Reader getTemplate(String name) {
                                return DefaultGenerator.this.getTemplateReader(DefaultGenerator.this.getFullTemplateFile(DefaultGenerator.this.config, name + ".mustache"));
                            }
                        }).defaultValue("").compile(template);
                        this.writeToFile(outputFilename, tmpl.execute(bundle));
                        files.add(new File(outputFilename));
                        continue;
                    }
                    InputStream in = null;
                    try {
                        in = new FileInputStream(templateFile);
                    }
                    catch (Exception compiler) {
                        // empty catch block
                    }
                    if (in == null) {
                        in = this.getClass().getClassLoader().getResourceAsStream(this.getCPResourcePath(templateFile));
                    }
                    File outputFile = new File(outputFilename);
                    FileOutputStream out = new FileOutputStream(outputFile, false);
                    if (in != null) {
                        this.LOGGER.info("writing file " + outputFile);
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                        ((OutputStream)out).close();
                    } else {
                        this.LOGGER.error("can't open " + templateFile + " for input");
                    }
                    files.add(outputFile);
                    continue;
                }
                this.LOGGER.info("Skipped generation of " + outputFilename + " due to rule in .swagger-codegen-ignore");
            }
            catch (Exception e) {
                throw new RuntimeException("Could not generate supporting file '" + support + "'", e);
            }
        }
        String swaggerCodegenIgnore = ".swagger-codegen-ignore";
        String ignoreFileNameTarget = this.config.outputFolder() + File.separator + ".swagger-codegen-ignore";
        File ignoreFile = new File(ignoreFileNameTarget);
        if (this.isGenerateSwaggerMetadata.booleanValue() && !ignoreFile.exists()) {
            String ignoreFileNameSource = File.separator + this.config.getCommonTemplateDir() + File.separator + ".swagger-codegen-ignore";
            String ignoreFileContents = this.readResourceContents(ignoreFileNameSource);
            try {
                this.writeToFile(ignoreFileNameTarget, ignoreFileContents);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not generate supporting file '.swagger-codegen-ignore'", e);
            }
            files.add(ignoreFile);
        }
        if (this.isGenerateSwaggerMetadata.booleanValue()) {
            String swaggerVersionMetadata = this.config.outputFolder() + File.separator + ".swagger-codegen" + File.separator + "VERSION";
            File swaggerVersionMetadataFile = new File(swaggerVersionMetadata);
            try {
                this.writeToFile(swaggerVersionMetadata, ImplementationVersion.read());
                files.add(swaggerVersionMetadataFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not generate supporting file '" + swaggerVersionMetadata + "'", e);
            }
        }
    }

    protected Map<String, Object> buildSupportFileBundle(List<Object> allOperations, List<Object> allModels) {
        HashMap<String, Object> bundle = new HashMap<String, Object>();
        bundle.putAll(this.config.additionalProperties());
        bundle.put("apiPackage", this.config.apiPackage());
        HashMap<String, List<Object>> apis = new HashMap<String, List<Object>>();
        apis.put("apis", allOperations);
        if (this.swagger.getHost() != null) {
            bundle.put("host", this.swagger.getHost());
        }
        bundle.put("swagger", this.swagger);
        bundle.put("basePath", this.basePath);
        bundle.put("basePathWithoutHost", this.basePathWithoutHost);
        bundle.put("scheme", this.getScheme());
        bundle.put("contextPath", this.contextPath);
        bundle.put("apiInfo", apis);
        bundle.put("models", allModels);
        bundle.put("apiFolder", this.config.apiPackage().replace('.', File.separatorChar));
        bundle.put("modelPackage", this.config.modelPackage());
        List<CodegenSecurity> authMethods = this.config.fromSecurity(this.swagger.getSecurityDefinitions());
        if (authMethods != null && !authMethods.isEmpty()) {
            bundle.put("authMethods", authMethods);
            bundle.put("hasAuthMethods", true);
        }
        if (this.swagger.getExternalDocs() != null) {
            bundle.put("externalDocs", this.swagger.getExternalDocs());
        }
        for (int i = 0; i < allModels.size() - 1; ++i) {
            HashMap cm = (HashMap)allModels.get(i);
            CodegenModel m = (CodegenModel)cm.get("model");
            m.hasMoreModels = true;
        }
        this.config.postProcessSupportingFileData(bundle);
        if (System.getProperty("debugSupportingFiles") != null) {
            this.LOGGER.info("############ Supporting file info ############");
            Json.prettyPrint(bundle);
        }
        return bundle;
    }

    @Override
    public List<File> generate() {
        if (this.swagger == null || this.config == null) {
            throw new RuntimeException("missing swagger input or config!");
        }
        this.configureGeneratorProperties();
        this.configureSwaggerInfo();
        InlineModelResolver inlineModelResolver = new InlineModelResolver();
        inlineModelResolver.flatten(this.swagger);
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<Object> allModels = new ArrayList<Object>();
        this.generateModels(files, allModels);
        ArrayList<Object> allOperations = new ArrayList<Object>();
        this.generateApis(files, allOperations, allModels);
        Map<String, Object> bundle = this.buildSupportFileBundle(allOperations, allModels);
        this.generateSupportingFiles(files, bundle);
        this.config.processSwagger(this.swagger);
        return files;
    }

    protected File processTemplateToFile(Map<String, Object> templateData, String templateName, String outputFilename) throws IOException {
        String adjustedOutputFilename = outputFilename.replaceAll("//", "/").replace('/', File.separatorChar);
        if (this.ignoreProcessor.allowsFile(new File(adjustedOutputFilename))) {
            String templateFile = this.getFullTemplateFile(this.config, templateName);
            String template = this.readTemplate(templateFile);
            Mustache.Compiler compiler = Mustache.compiler();
            compiler = this.config.processCompiler(compiler);
            Template tmpl = compiler.withLoader(new Mustache.TemplateLoader(){

                public Reader getTemplate(String name) {
                    return DefaultGenerator.this.getTemplateReader(DefaultGenerator.this.getFullTemplateFile(DefaultGenerator.this.config, name + ".mustache"));
                }
            }).defaultValue("").compile(template);
            this.writeToFile(adjustedOutputFilename, tmpl.execute(templateData));
            return new File(adjustedOutputFilename);
        }
        this.LOGGER.info("Skipped generation of " + adjustedOutputFilename + " due to rule in .swagger-codegen-ignore");
        return null;
    }

    protected static void processMimeTypes(List<String> mimeTypeList, Map<String, Object> operation, String source) {
        if (mimeTypeList == null || mimeTypeList.isEmpty()) {
            return;
        }
        ArrayList c = new ArrayList();
        int count = 0;
        for (String key : mimeTypeList) {
            HashMap<String, String> mediaType = new HashMap<String, String>();
            mediaType.put("mediaType", key);
            if (++count < mimeTypeList.size()) {
                mediaType.put("hasMore", "true");
            } else {
                mediaType.put("hasMore", null);
            }
            c.add(mediaType);
        }
        operation.put(source, c);
        String flagFieldName = "has" + source.substring(0, 1).toUpperCase() + source.substring(1);
        operation.put(flagFieldName, true);
    }

    public Map<String, List<CodegenOperation>> processPaths(Map<String, Path> paths) {
        TreeMap<String, List<CodegenOperation>> ops = new TreeMap<String, List<CodegenOperation>>();
        for (String resourcePath : paths.keySet()) {
            Path path = paths.get(resourcePath);
            this.processOperation(resourcePath, "get", path.getGet(), ops, path);
            this.processOperation(resourcePath, "head", path.getHead(), ops, path);
            this.processOperation(resourcePath, "put", path.getPut(), ops, path);
            this.processOperation(resourcePath, "post", path.getPost(), ops, path);
            this.processOperation(resourcePath, "delete", path.getDelete(), ops, path);
            this.processOperation(resourcePath, "patch", path.getPatch(), ops, path);
            this.processOperation(resourcePath, "options", path.getOptions(), ops, path);
        }
        return ops;
    }

    protected void processOperation(String resourcePath, String httpMethod, Operation operation, Map<String, List<CodegenOperation>> operations, Path path) {
        if (operation == null) {
            return;
        }
        if (System.getProperty("debugOperations") != null) {
            this.LOGGER.info("processOperation: resourcePath= " + resourcePath + "\t;" + httpMethod + " " + operation + "\n");
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        List tagNames = operation.getTags();
        List swaggerTags = this.swagger.getTags();
        if (tagNames != null) {
            if (swaggerTags == null) {
                for (String tagName : tagNames) {
                    tags.add(new Tag().name(tagName));
                }
            } else {
                for (String tagName : tagNames) {
                    boolean foundTag = false;
                    for (Tag tag : swaggerTags) {
                        if (!tag.getName().equals(tagName)) continue;
                        tags.add(tag);
                        foundTag = true;
                        break;
                    }
                    if (foundTag) continue;
                    tags.add(new Tag().name(tagName));
                }
            }
        }
        if (tags.isEmpty()) {
            tags.add(new Tag().name("default"));
        }
        HashSet<String> operationParameters = new HashSet<String>();
        if (operation.getParameters() != null) {
            for (Parameter parameter : operation.getParameters()) {
                operationParameters.add(DefaultGenerator.generateParameterId(parameter));
            }
        }
        if (path.getParameters() != null) {
            for (Parameter parameter : path.getParameters()) {
                if (operationParameters.contains(DefaultGenerator.generateParameterId(parameter))) continue;
                operation.addParameter(parameter);
            }
        }
        for (Tag tag : tags) {
            try {
                CodegenOperation codegenOperation = this.config.fromOperation(resourcePath, httpMethod, operation, this.swagger.getDefinitions(), this.swagger);
                codegenOperation.tags = new ArrayList<Tag>(tags);
                this.config.addOperationToGroup(this.config.sanitizeTag(tag.getName()), resourcePath, operation, codegenOperation, operations);
                ArrayList<Map> securities = operation.getSecurity();
                if (securities == null && this.swagger.getSecurity() != null) {
                    securities = new ArrayList<Map>();
                    for (SecurityRequirement sr : this.swagger.getSecurity()) {
                        securities.add(sr.getRequirements());
                    }
                }
                if (securities == null || this.swagger.getSecurityDefinitions() == null) continue;
                HashMap<String, SecuritySchemeDefinition> authMethods = new HashMap<String, SecuritySchemeDefinition>();
                for (Map security : securities) {
                    for (String securityName : security.keySet()) {
                        SecuritySchemeDefinition securityDefinition = (SecuritySchemeDefinition)this.swagger.getSecurityDefinitions().get(securityName);
                        if (securityDefinition == null) continue;
                        if (securityDefinition instanceof OAuth2Definition) {
                            OAuth2Definition oauth2Definition = (OAuth2Definition)securityDefinition;
                            OAuth2Definition oauth2Operation = new OAuth2Definition();
                            oauth2Operation.setType(oauth2Definition.getType());
                            oauth2Operation.setAuthorizationUrl(oauth2Definition.getAuthorizationUrl());
                            oauth2Operation.setFlow(oauth2Definition.getFlow());
                            oauth2Operation.setTokenUrl(oauth2Definition.getTokenUrl());
                            oauth2Operation.setScopes(new HashMap());
                            for (String scope : (List)security.get(securityName)) {
                                if (!oauth2Definition.getScopes().containsKey(scope)) continue;
                                oauth2Operation.addScope(scope, (String)oauth2Definition.getScopes().get(scope));
                            }
                            authMethods.put(securityName, (SecuritySchemeDefinition)oauth2Operation);
                            continue;
                        }
                        authMethods.put(securityName, securityDefinition);
                    }
                }
                if (authMethods.isEmpty()) continue;
                codegenOperation.authMethods = this.config.fromSecurity(authMethods);
                codegenOperation.hasAuthMethods = true;
            }
            catch (Exception ex) {
                String msg = "Could not process operation:\n  Tag: " + tag + "\n  Operation: " + operation.getOperationId() + "\n  Resource: " + httpMethod + " " + resourcePath + "\n  Definitions: " + this.swagger.getDefinitions() + "\n  Exception: " + ex.getMessage();
                throw new RuntimeException(msg, ex);
            }
        }
    }

    protected static String generateParameterId(Parameter parameter) {
        return parameter.getName() + ":" + parameter.getIn();
    }

    protected Map<String, Object> processOperations(CodegenConfig config, String tag, List<CodegenOperation> ops, List<Object> allModels) {
        List list;
        HashMap<String, Object> operations = new HashMap<String, Object>();
        HashMap<String, Object> objs = new HashMap<String, Object>();
        objs.put("classname", config.toApiName(tag));
        objs.put("pathPrefix", config.toApiVarName(tag));
        HashSet<String> opIds = new HashSet<String>();
        int counter = 0;
        for (CodegenOperation codegenOperation : ops) {
            String string = codegenOperation.nickname;
            if (opIds.contains(string)) {
                codegenOperation.nickname = codegenOperation.nickname + "_" + ++counter;
            }
            opIds.add(string);
        }
        objs.put("operation", ops);
        operations.put("operations", objs);
        operations.put("package", config.apiPackage());
        TreeSet<String> allImports = new TreeSet<String>();
        for (CodegenOperation codegenOperation : ops) {
            allImports.addAll(codegenOperation.imports);
        }
        ArrayList arrayList = new ArrayList();
        for (String nextImport : allImports) {
            LinkedHashMap<String, String> im = new LinkedHashMap<String, String>();
            String mapping = config.importMapping().get(nextImport);
            if (mapping == null) {
                mapping = config.toModelImport(nextImport);
            }
            if (mapping == null) continue;
            im.put("import", mapping);
            if (arrayList.contains(im)) continue;
            arrayList.add(im);
        }
        operations.put("imports", arrayList);
        if (arrayList.size() > 0) {
            operations.put("hasImport", true);
        }
        config.postProcessOperations(operations);
        config.postProcessOperationsWithModels(operations, allModels);
        if (objs.size() > 0 && (list = (List)objs.get("operation")) != null && list.size() > 0) {
            CodegenOperation op = (CodegenOperation)list.get(list.size() - 1);
            op.hasMore = false;
        }
        return operations;
    }

    protected Map<String, Object> processModels(CodegenConfig config, Map<String, Model> definitions, Map<String, Model> allDefinitions) {
        HashMap<String, Object> objs = new HashMap<String, Object>();
        objs.put("package", config.modelPackage());
        ArrayList models = new ArrayList();
        LinkedHashSet<String> allImports = new LinkedHashSet<String>();
        for (String string : definitions.keySet()) {
            Model mm = definitions.get(string);
            if (mm.getVendorExtensions() != null && mm.getVendorExtensions().containsKey("x-codegen-ignore")) {
                this.LOGGER.debug("skipping model " + string);
                return null;
            }
            if (mm.getVendorExtensions() != null && mm.getVendorExtensions().containsKey("x-codegen-import-mapping")) {
                String codegenImport = mm.getVendorExtensions().get("x-codegen-import-mapping").toString();
                config.importMapping().put(string, codegenImport);
                allImports.add(codegenImport);
            }
            CodegenModel cm = config.fromModel(string, mm, allDefinitions);
            HashMap<String, Object> mo = new HashMap<String, Object>();
            mo.put("model", cm);
            mo.put("importPath", config.toModelImport(cm.classname));
            models.add(mo);
            allImports.addAll(cm.imports);
        }
        objs.put("models", models);
        TreeSet<String> importSet = new TreeSet<String>();
        for (String nextImport : allImports) {
            String mapping = config.importMapping().get(nextImport);
            if (mapping == null) {
                mapping = config.toModelImport(nextImport);
            }
            if (mapping != null && !config.defaultIncludes().contains(mapping)) {
                importSet.add(mapping);
            }
            if ((mapping = config.instantiationTypes().get(nextImport)) == null || config.defaultIncludes().contains(mapping)) continue;
            importSet.add(mapping);
        }
        ArrayList arrayList = new ArrayList();
        for (String s : importSet) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("import", s);
            arrayList.add(item);
        }
        objs.put("imports", arrayList);
        config.postProcessModels(objs);
        return objs;
    }
}

