/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.sqlmm;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Objects;
import org.apache.sis.feature.internal.shared.FeatureProjectionBuilder;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.sqlmm.SQLMM;
import org.apache.sis.filter.sqlmm.SpatialFunction;
import org.apache.sis.pending.geoapi.filter.Literal;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

abstract class FunctionWithSRID<R>
extends SpatialFunction<R> {
    private static final long serialVersionUID = -6870024245928121613L;
    final Expression<R, ?> srid;
    private transient Object lastSRID;
    private transient CoordinateReferenceSystem targetCRS;
    final boolean literalCRS;
    static final int PRESENT = 1;
    static final int ABSENT = 0;
    static final int MAYBE = 2;

    FunctionWithSRID(SQLMM operation, Expression<R, ?>[] parameters, int hasSRID) {
        super(operation, parameters);
        if (hasSRID == 2 && parameters.length < operation.maxParamCount) {
            hasSRID = 0;
        }
        if (hasSRID == 0) {
            this.literalCRS = true;
            this.srid = null;
            return;
        }
        this.srid = parameters[operation.maxParamCount - 1];
        if (this.srid instanceof Literal) {
            Object value = ((Literal)this.srid).getValue();
            if (value == null) {
                this.literalCRS = true;
            } else {
                boolean bl = this.literalCRS = hasSRID == 1 || FunctionWithSRID.isCRS(value.getClass());
                if (this.literalCRS) {
                    try {
                        this.setTargetCRS(value);
                    }
                    catch (FactoryException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            }
        } else {
            this.literalCRS = false;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.literalCRS && this.srid != null) {
            try {
                this.setTargetCRS(((Literal)this.srid).getValue());
            }
            catch (FactoryException e) {
                throw (IOException)new InvalidObjectException(e.getLocalizedMessage()).initCause(e);
            }
        }
    }

    private static boolean isCRS(Class<?> type) {
        return type == Integer.class || type == String.class || CoordinateReferenceSystem.class.isAssignableFrom(type);
    }

    private void setTargetCRS(Object crs) throws FactoryException {
        block1: {
            Object code;
            block3: {
                block4: {
                    block5: {
                        block2: {
                            block0: {
                                if (!(crs instanceof CoordinateReferenceSystem)) break block0;
                                this.targetCRS = (CoordinateReferenceSystem)crs;
                                break block1;
                            }
                            if (!(crs instanceof String)) break block2;
                            code = (String)crs;
                            break block3;
                        }
                        if (!(crs instanceof Integer)) break block4;
                        if ((Integer)crs != 0) break block5;
                        this.targetCRS = null;
                        break block1;
                    }
                    code = "EPSG:" + String.valueOf(crs);
                    break block3;
                }
                throw new InvalidGeodeticParameterException(crs == null ? Errors.format((short)189) : Errors.format((short)61, crs.getClass()));
            }
            this.targetCRS = CRS.forCode((String)code);
        }
        this.lastSRID = crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CoordinateReferenceSystem getTargetCRS(R input) throws FactoryException {
        if (this.literalCRS) {
            return this.targetCRS;
        }
        Object value = this.srid.apply(input);
        if (value == null) {
            return null;
        }
        FunctionWithSRID functionWithSRID = this;
        synchronized (functionWithSRID) {
            if (!Objects.equals(value, this.lastSRID)) {
                this.setTargetCRS(value);
            }
            return this.targetCRS;
        }
    }

    @Override
    public Class<? super R> getResourceClass() {
        return this.srid != null ? this.srid.getResourceClass() : Object.class;
    }

    @Override
    public FeatureProjectionBuilder.Item expectedType(FeatureProjectionBuilder addTo) {
        return super.expectedType(addTo).setCRS(this.literalCRS ? this.targetCRS : null);
    }
}

