/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.scheduler.impl;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.sling.commons.scheduler.impl.ConfigHolder;
import org.apache.sling.commons.scheduler.impl.MetricsHelper;
import org.apache.sling.commons.scheduler.impl.QuartzScheduler;
import org.apache.sling.commons.scheduler.impl.SchedulerProxy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.vendor=The Apache Software Foundation"})
public class GaugesSupport {
    private static final String CLEANUP_JOB_NAME = "org.apache.sling.commons.scheduler.impl.GaugesSupport.CleanupJob";
    @Reference
    private MetricRegistry metricRegistry;
    private final List<String> registeredGaugeNameList = new LinkedList<String>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, ServiceRegistration> gaugeRegistrations = new HashMap<String, ServiceRegistration>();
    private final Map<String, TemporaryGauge> temporaryGauges = new HashMap<String, TemporaryGauge>();
    private volatile boolean active = true;
    @Reference
    QuartzScheduler quartzScheduler;
    private ConfigHolder configHolder;
    private long bundleId;

    @Activate
    protected void activate(BundleContext ctx) {
        this.logger.debug("activate: activating.");
        this.configHolder = this.quartzScheduler.configHolder;
        this.active = true;
        this.registerGauges();
        this.bundleId = ctx.getBundle().getBundleId();
        try {
            this.quartzScheduler.addPeriodicJob(this.bundleId, null, CLEANUP_JOB_NAME, new Runnable(){

                @Override
                public void run() {
                    if (GaugesSupport.this.active) {
                        GaugesSupport.this.cleanupTemporaryGauges();
                    } else {
                        GaugesSupport.this.logger.debug("run: late executed periodic cleanup job - ignoring");
                    }
                }
            }, null, 1800L, false);
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Could not activate GaugesSupport due to " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupTemporaryGauges() {
        int endCount;
        HashMap<String, TemporaryGauge> localTemporaryGauges;
        this.logger.debug("cleanupTemporaryGauges: checking for unused temporary gauges.");
        long start = System.currentTimeMillis();
        Map<String, TemporaryGauge> map = this.temporaryGauges;
        synchronized (map) {
            localTemporaryGauges = new HashMap<String, TemporaryGauge>(this.temporaryGauges);
        }
        for (TemporaryGauge gauge : localTemporaryGauges.values()) {
            gauge.getValue();
        }
        Map<String, TemporaryGauge> map2 = this.temporaryGauges;
        synchronized (map2) {
            endCount = this.temporaryGauges.size();
        }
        long diff = System.currentTimeMillis() - start;
        this.logger.debug("cleanupTemporaryGauges: done. (temporary gauges at start : " + localTemporaryGauges.size() + ", at end : " + endCount + ", cleanup took : " + diff + "ms)");
    }

    private void registerGauges() {
        this.createGauge(this.configHolder, null, null, "commons.scheduler.oldest.running.job.millis");
        this.createGauge(this.configHolder, this.configHolder.poolName(), null, "commons.scheduler.oldest.running.job.millis.tp." + this.configHolder.poolName());
        if (this.configHolder.allowedPoolNames() != null) {
            for (String tpName : this.configHolder.allowedPoolNames()) {
                this.createGauge(this.configHolder, tpName, null, "commons.scheduler.oldest.running.job.millis.tp." + (String)tpName);
            }
        }
        for (Map.Entry entry : this.configHolder.getFilterSuffixes().entrySet()) {
            String name = (String)entry.getKey();
            String filterName = (String)entry.getValue();
            this.createGauge(this.configHolder, null, filterName, "commons.scheduler.oldest.running.job.millis.filter." + name);
        }
    }

    private void createGauge(final ConfigHolder configHolder, final String tpName, final String filterName, String gaugeName) {
        Gauge gauge = new Gauge(){

            public Long getValue() {
                if (!GaugesSupport.this.active) {
                    return -1L;
                }
                return GaugesSupport.this.getOldestRunningJobMillis(configHolder, tpName, filterName);
            }
        };
        this.logger.debug("createGauge: registering gauge : " + gaugeName);
        this.metricRegistry.register(gaugeName, (Metric)gauge);
        this.registeredGaugeNameList.add(gaugeName);
    }

    private Long getOldestRunningJobMillis(ConfigHolder configHolder, String threadPoolNameOrNull, String filterNameOrNull) {
        QuartzScheduler localQuartzScheduler = this.quartzScheduler;
        if (localQuartzScheduler == null) {
            return -1L;
        }
        Map<String, SchedulerProxy> schedulers = localQuartzScheduler.getSchedulers();
        if (schedulers == null) {
            return -1L;
        }
        Date oldestDate = null;
        if (filterNameOrNull == null && threadPoolNameOrNull != null) {
            SchedulerProxy schedulerProxy = schedulers.get(threadPoolNameOrNull);
            oldestDate = this.getOldestRunningJobDate(configHolder, schedulerProxy, null);
        } else {
            for (Map.Entry<String, SchedulerProxy> entry : schedulers.entrySet()) {
                SchedulerProxy schedulerProxy = entry.getValue();
                oldestDate = GaugesSupport.olderOf(oldestDate, this.getOldestRunningJobDate(configHolder, schedulerProxy, filterNameOrNull));
            }
        }
        if (oldestDate == null) {
            return -1L;
        }
        return System.currentTimeMillis() - oldestDate.getTime();
    }

    private Date getOldestRunningJobDate(ConfigHolder configHolder, SchedulerProxy schedulerProxy, String filterNameOrNull) {
        if (schedulerProxy == null) {
            return null;
        }
        Scheduler scheduler = schedulerProxy.getScheduler();
        if (scheduler == null) {
            return null;
        }
        List<JobExecutionContext> currentlyExecutingJobs = null;
        try {
            currentlyExecutingJobs = scheduler.getCurrentlyExecutingJobs();
        }
        catch (SchedulerException e) {
            this.logger.warn("getValue: could not get currently executing jobs due to Exception: " + e, (Throwable)e);
        }
        if (currentlyExecutingJobs == null) {
            return null;
        }
        Date oldestDate = null;
        for (JobExecutionContext jobExecutionContext : currentlyExecutingJobs) {
            if (jobExecutionContext == null) continue;
            if (filterNameOrNull != null) {
                JobDetail jobDetail = jobExecutionContext.getJobDetail();
                JobDataMap map = null;
                if (jobDetail != null) {
                    map = jobDetail.getJobDataMap();
                }
                String filterName = null;
                if (map != null) {
                    filterName = MetricsHelper.deriveFilterName(configHolder, map.get("QuartzJobScheduler.Object"));
                }
                if (filterName == null || !filterNameOrNull.equals(filterName)) continue;
            }
            Date fireTime = jobExecutionContext.getFireTime();
            long elapsedMillis = System.currentTimeMillis() - fireTime.getTime();
            long slowThresholdMillis = configHolder.slowThresholdMillis();
            if (slowThresholdMillis > 0L && elapsedMillis > slowThresholdMillis) {
                this.createTemporaryGauge(jobExecutionContext);
            }
            oldestDate = GaugesSupport.olderOf(oldestDate, fireTime);
        }
        return oldestDate;
    }

    private static Date olderOf(Date date1, Date date2) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        if (date2.before(date1)) {
            return date2;
        }
        return date1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTemporaryGauge(JobExecutionContext jobExecutionContext) {
        TemporaryGauge tempGauge;
        JobDataMap data = jobExecutionContext.getJobDetail().getJobDataMap();
        String jobName = data.getString("QuartzJobScheduler.JobName");
        String gaugeName = "commons.scheduler.oldest.running.job.millis.slow." + MetricsHelper.asMetricsSuffix(jobName);
        Map<String, TemporaryGauge> map = this.temporaryGauges;
        synchronized (map) {
            tempGauge = this.temporaryGauges.get(gaugeName);
            if (tempGauge != null && tempGauge.jobExecutionContext == jobExecutionContext) {
                return;
            }
        }
        if (tempGauge != null) {
            this.logger.debug("createTemporaryGauge: unregistering temporary gauge for slow job : " + gaugeName);
            tempGauge.unregister();
        }
        this.logger.debug("createTemporaryGauge: creating temporary gauge for slow job : " + gaugeName);
        map = this.temporaryGauges;
        synchronized (map) {
            this.temporaryGauges.put(gaugeName, new TemporaryGauge(jobExecutionContext, gaugeName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterGauges() {
        HashMap<String, TemporaryGauge> localTemporaryGauges;
        HashMap<String, ServiceRegistration> localGaugeRegistrations;
        Map<String, ServiceRegistration> map = this.gaugeRegistrations;
        synchronized (map) {
            localGaugeRegistrations = new HashMap<String, ServiceRegistration>(this.gaugeRegistrations);
            this.gaugeRegistrations.clear();
        }
        Map<String, TemporaryGauge> map2 = this.temporaryGauges;
        synchronized (map2) {
            localTemporaryGauges = new HashMap<String, TemporaryGauge>(this.temporaryGauges);
        }
        for (Map.Entry e : localGaugeRegistrations.entrySet()) {
            this.logger.debug("unregisterGauges: unregistering gauge : " + (String)e.getKey());
            ((ServiceRegistration)e.getValue()).unregister();
        }
        for (TemporaryGauge tempGauge : localTemporaryGauges.values()) {
            this.logger.debug("unregisterGauges: unregistering temporary gauge for slow job : " + tempGauge.gaugeName);
            tempGauge.unregister();
        }
        for (String registeredGaugeName : this.registeredGaugeNameList) {
            this.metricRegistry.remove(registeredGaugeName);
        }
    }

    @Deactivate
    void deactivate() {
        this.logger.debug("deactivate: deactivating.");
        this.active = false;
        try {
            this.quartzScheduler.removeJob(this.bundleId, CLEANUP_JOB_NAME);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.unregisterGauges();
    }

    private final class TemporaryGauge
    implements Gauge {
        private final JobExecutionContext jobExecutionContext;
        private final String gaugeName;
        private volatile boolean unregistered = false;

        private TemporaryGauge(JobExecutionContext jobExecutionContext, String gaugeName) {
            this.jobExecutionContext = jobExecutionContext;
            this.gaugeName = gaugeName;
            GaugesSupport.this.metricRegistry.register(gaugeName, (Metric)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregister() {
            Object object = this;
            synchronized (object) {
                if (this.unregistered) {
                    return;
                }
                this.unregistered = true;
            }
            object = GaugesSupport.this.temporaryGauges;
            synchronized (object) {
                if (GaugesSupport.this.temporaryGauges.get(this.gaugeName) == this) {
                    GaugesSupport.this.logger.debug("unregister: unregistering active temporary gauge for slow job : " + this.gaugeName);
                    GaugesSupport.this.temporaryGauges.remove(this.gaugeName);
                } else {
                    GaugesSupport.this.logger.debug("unregister: unregistering dangling temporary gauge for slow job : " + this.gaugeName);
                }
            }
            GaugesSupport.this.metricRegistry.remove(this.gaugeName);
        }

        public Long getValue() {
            if (this.unregistered) {
                return -1L;
            }
            if (!GaugesSupport.this.active) {
                this.unregister();
                return -1L;
            }
            if (this.jobExecutionContext.getJobRunTime() != -1L) {
                this.unregister();
                return -1L;
            }
            Date oldestDate = this.jobExecutionContext.getFireTime();
            if (oldestDate == null) {
                this.unregister();
                return -1L;
            }
            return System.currentTimeMillis() - oldestDate.getTime();
        }
    }
}

