/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.DistributionQueueStatus;
import org.apache.sling.distribution.queue.spi.DistributionQueue;
import org.jetbrains.annotations.NotNull;

public abstract class DistributionQueueWrapper
implements DistributionQueue {
    private static final Set<String> CAPABILITIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("appendable", "removable", "clearable")));
    final DistributionQueue wrappedQueue;

    DistributionQueueWrapper(DistributionQueue wrappedQueue) {
        this.wrappedQueue = wrappedQueue;
    }

    @Override
    @NotNull
    public String getName() {
        return this.wrappedQueue.getName();
    }

    @Override
    public DistributionQueueEntry add(@NotNull DistributionQueueItem item) {
        return this.wrappedQueue.add(item);
    }

    @Override
    public DistributionQueueEntry getHead() {
        return this.wrappedQueue.getHead();
    }

    @Override
    @NotNull
    public Iterable<DistributionQueueEntry> getEntries(int skip, int limit) {
        return this.wrappedQueue.getEntries(skip, limit);
    }

    @Override
    public DistributionQueueEntry getEntry(@NotNull String itemId) {
        return this.wrappedQueue.getEntry(itemId);
    }

    @Override
    public DistributionQueueEntry remove(@NotNull String itemId) {
        return this.wrappedQueue.remove(itemId);
    }

    @Override
    @NotNull
    public DistributionQueueStatus getStatus() {
        return this.wrappedQueue.getStatus();
    }

    @Override
    @NotNull
    public Iterable<DistributionQueueEntry> remove(@NotNull Set<String> entryIds) {
        return this.wrappedQueue.remove(entryIds);
    }

    @Override
    @NotNull
    public Iterable<DistributionQueueEntry> clear(int limit) {
        return this.wrappedQueue.clear(limit);
    }

    @Override
    public boolean hasCapability(@NotNull String capability) {
        return CAPABILITIES.contains(capability);
    }
}

