/*-
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.sling.query;

import static org.apache.sling.query.SlingQuery.$;
import static org.apache.sling.query.TestUtils.assertEmptyIterator;
import static org.apache.sling.query.TestUtils.assertResourceSetEquals;

import org.apache.sling.api.resource.Resource;
import org.junit.Test;

public class LastTest {

    private static final String PAR_PATH = "home/java/labels/jcr:content/par";

    private Resource tree = TestUtils.getTree();

    @Test
    public void testLast() {
        SlingQuery query = $(tree.getChild(PAR_PATH)).children().last();
        assertResourceSetEquals(query.iterator(), "configvalue_2");
    }

    @Test
    public void testLastOnEmptyCollection() {
        SlingQuery query = $(tree).children("cq:Undefined").last();
        assertEmptyIterator(query.iterator());
    }

    @Test
    public void testLastAfterFilter() {
        SlingQuery query = $(tree.getChild(PAR_PATH)).children().filter("[key=helloWorld]").last();
        assertResourceSetEquals(query.iterator(), "configvalue");
    }
}
