/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcemerger.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.resourcemerger.impl.HideItemPredicate;

public class MergedValueMap
extends ValueMapDecorator {
    private static final Set<String> EXCLUDED_PROPERTIES = new HashSet<String>();

    public MergedValueMap(List<ValueMap> valueMaps) {
        super(new HashMap());
        for (ValueMap vm : valueMaps) {
            String[] hideSettings = (String[])vm.get("sling:hideProperties", String[].class);
            if (hideSettings != null) {
                HideItemPredicate hidePredicate = new HideItemPredicate(hideSettings, "sling:hideProperties");
                this.entrySet().removeIf(entry -> hidePredicate.testItem((String)entry.getKey(), false));
                this.putAll(vm.entrySet().stream().filter(entry -> !EXCLUDED_PROPERTIES.contains(entry.getKey()) && !hidePredicate.testItem((String)entry.getKey(), true)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
                continue;
            }
            this.putAll(vm.entrySet().stream().filter(entry -> !EXCLUDED_PROPERTIES.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
    }

    static {
        EXCLUDED_PROPERTIES.add("sling:hideProperties");
        EXCLUDED_PROPERTIES.add("sling:hideResource");
        EXCLUDED_PROPERTIES.add("sling:hideChildren");
        EXCLUDED_PROPERTIES.add("sling:orderBefore");
    }
}

