/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import java.security.Principal;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.oak.jcr.delegate.AccessControlManagerDelegator;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JackrabbitAccessControlManagerDelegator
implements JackrabbitAccessControlManager {
    private final JackrabbitAccessControlManager jackrabbitACManager;
    private final SessionDelegate delegate;
    private final AccessControlManagerDelegator jcrACManager;

    public JackrabbitAccessControlManagerDelegator(SessionDelegate delegate, JackrabbitAccessControlManager acManager) {
        this.jackrabbitACManager = acManager;
        this.delegate = delegate;
        this.jcrACManager = new AccessControlManagerDelegator(delegate, acManager);
    }

    @Override
    @NotNull
    public JackrabbitAccessControlPolicy[] getApplicablePolicies(final @NotNull Principal principal) throws RepositoryException {
        return this.delegate.perform(new SessionOperation<JackrabbitAccessControlPolicy[]>("getApplicablePolicies"){

            @Override
            @NotNull
            public JackrabbitAccessControlPolicy[] perform() throws RepositoryException {
                return JackrabbitAccessControlManagerDelegator.this.jackrabbitACManager.getApplicablePolicies(principal);
            }
        });
    }

    @Override
    @NotNull
    public JackrabbitAccessControlPolicy[] getPolicies(final @NotNull Principal principal) throws RepositoryException {
        return this.delegate.perform(new SessionOperation<JackrabbitAccessControlPolicy[]>("getPolicies"){

            @Override
            @NotNull
            public JackrabbitAccessControlPolicy[] perform() throws RepositoryException {
                return JackrabbitAccessControlManagerDelegator.this.jackrabbitACManager.getPolicies(principal);
            }
        });
    }

    @Override
    @NotNull
    public AccessControlPolicy[] getEffectivePolicies(final @NotNull Set<Principal> principals) throws RepositoryException {
        return this.delegate.perform(new SessionOperation<AccessControlPolicy[]>("getEffectivePolicies"){

            @Override
            @NotNull
            public AccessControlPolicy[] perform() throws RepositoryException {
                return JackrabbitAccessControlManagerDelegator.this.jackrabbitACManager.getEffectivePolicies(principals);
            }
        });
    }

    @Override
    public boolean hasPrivileges(final @Nullable String absPath, final @NotNull Set<Principal> principals, final @NotNull Privilege[] privileges) throws RepositoryException {
        return this.delegate.perform(new SessionOperation<Boolean>("hasPrivileges"){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                return JackrabbitAccessControlManagerDelegator.this.jackrabbitACManager.hasPrivileges(absPath, principals, privileges);
            }
        });
    }

    @Override
    @NotNull
    public Privilege[] getPrivileges(final @Nullable String absPath, final @NotNull Set<Principal> principals) throws RepositoryException {
        return this.delegate.perform(new SessionOperation<Privilege[]>("getPrivileges"){

            @Override
            @NotNull
            public Privilege[] perform() throws RepositoryException {
                return JackrabbitAccessControlManagerDelegator.this.jackrabbitACManager.getPrivileges(absPath, principals);
            }
        });
    }

    public Privilege[] getSupportedPrivileges(String absPath) throws RepositoryException {
        return this.jcrACManager.getSupportedPrivileges(absPath);
    }

    public Privilege privilegeFromName(String privilegeName) throws RepositoryException {
        return this.jcrACManager.privilegeFromName(privilegeName);
    }

    public boolean hasPrivileges(String absPath, Privilege[] privileges) throws RepositoryException {
        return this.jcrACManager.hasPrivileges(absPath, privileges);
    }

    public Privilege[] getPrivileges(String absPath) throws RepositoryException {
        return this.jcrACManager.getPrivileges(absPath);
    }

    public AccessControlPolicy[] getPolicies(String absPath) throws RepositoryException {
        return this.jcrACManager.getPolicies(absPath);
    }

    public AccessControlPolicy[] getEffectivePolicies(String absPath) throws RepositoryException {
        return this.jcrACManager.getEffectivePolicies(absPath);
    }

    public AccessControlPolicyIterator getApplicablePolicies(String absPath) throws RepositoryException {
        return this.jcrACManager.getApplicablePolicies(absPath);
    }

    public void setPolicy(String absPath, AccessControlPolicy policy) throws RepositoryException {
        this.jcrACManager.setPolicy(absPath, policy);
    }

    public void removePolicy(String absPath, AccessControlPolicy policy) throws RepositoryException {
        this.jcrACManager.removePolicy(absPath, policy);
    }
}

