/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.importer;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdate;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.plugins.index.importer.AsyncIndexerLock;
import org.apache.jackrabbit.oak.plugins.index.importer.AsyncLaneSwitcher;
import org.apache.jackrabbit.oak.plugins.index.importer.IndexDefinitionUpdater;
import org.apache.jackrabbit.oak.plugins.index.importer.IndexImporterProvider;
import org.apache.jackrabbit.oak.plugins.index.importer.IndexerInfo;
import org.apache.jackrabbit.oak.plugins.index.importer.NodeStoreUtils;
import org.apache.jackrabbit.oak.plugins.index.upgrade.IndexDisabler;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.VisibleEditor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sling-mock-oak.com.google.common.base.Preconditions;
import sling-mock-oak.com.google.common.collect.ArrayListMultimap;
import sling-mock-oak.com.google.common.collect.ListMultimap;

public class IndexImporter {
    static final String ASYNC_LANE_SYNC = "sync";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final NodeStore nodeStore;
    private final File indexDir;
    private final Map<String, IndexImporterProvider> importers = new HashMap<String, IndexImporterProvider>();
    private final IndexerInfo indexerInfo;
    private final Map<String, File> indexes;
    private final ListMultimap<String, IndexInfo> asyncLaneToIndexMapping;
    private final NodeState indexedState;
    private final IndexEditorProvider indexEditorProvider;
    private final AsyncIndexerLock indexerLock;
    private final IndexDefinitionUpdater indexDefinitionUpdater;

    public IndexImporter(NodeStore nodeStore, File indexDir, IndexEditorProvider indexEditorProvider, AsyncIndexerLock indexerLock) throws IOException {
        Preconditions.checkArgument(indexDir.exists() && indexDir.isDirectory(), "Path [%s] does not point to existing directory", indexDir.getAbsolutePath());
        this.nodeStore = nodeStore;
        this.indexDir = indexDir;
        this.indexEditorProvider = indexEditorProvider;
        this.indexerInfo = IndexerInfo.fromDirectory(indexDir);
        this.indexerLock = indexerLock;
        this.indexes = this.indexerInfo.getIndexes();
        this.indexedState = Preconditions.checkNotNull(nodeStore.retrieve(this.indexerInfo.checkpoint), "Cannot retrieve checkpointed state [%s]", this.indexerInfo.checkpoint);
        this.indexDefinitionUpdater = new IndexDefinitionUpdater(new File(indexDir, "index-definitions.json"));
        this.asyncLaneToIndexMapping = this.mapIndexesToLanes(this.indexes);
    }

    public void importIndex() throws IOException, CommitFailedException {
        if (this.indexes.keySet().isEmpty()) {
            this.log.warn("No indexes to import (possibly index definitions outside of a oak:index node?)");
        }
        this.log.info("Proceeding to import {} indexes from {}", this.indexes.keySet(), (Object)this.indexDir.getAbsolutePath());
        this.switchLanes();
        this.log.info("Done with switching of index lanes before import");
        this.importIndexData();
        this.log.info("Done with importing of index data");
        this.bringIndexUpToDate();
        this.releaseCheckpoint();
    }

    public void addImporterProvider(IndexImporterProvider importerProvider) {
        this.importers.put(importerProvider.getType(), importerProvider);
    }

    void switchLanes() throws CommitFailedException, IOException {
        NodeState root = this.nodeStore.getRoot();
        NodeBuilder builder = root.builder();
        for (IndexInfo indexInfo : this.asyncLaneToIndexMapping.values()) {
            if (indexInfo.newIndex) continue;
            NodeBuilder idxBuilder = NodeStoreUtils.childBuilder(builder, indexInfo.indexPath);
            AsyncLaneSwitcher.switchLane(idxBuilder, AsyncLaneSwitcher.getTempLaneName(indexInfo.asyncLaneName));
        }
        NodeStoreUtils.mergeWithConcurrentCheck(this.nodeStore, builder);
    }

    void importIndexData() throws CommitFailedException, IOException {
        NodeState root = this.nodeStore.getRoot();
        NodeBuilder rootBuilder = root.builder();
        IndexDisabler indexDisabler = new IndexDisabler(rootBuilder);
        for (IndexInfo indexInfo : this.asyncLaneToIndexMapping.values()) {
            this.log.info("Importing index data for {}", (Object)indexInfo.indexPath);
            NodeBuilder idxBuilder = this.indexDefinitionUpdater.apply(rootBuilder, indexInfo.indexPath);
            if (indexInfo.newIndex) {
                AsyncLaneSwitcher.switchLane(idxBuilder, AsyncLaneSwitcher.getTempLaneName(indexInfo.asyncLaneName));
            } else {
                NodeState existing = NodeStateUtils.getNode(root, indexInfo.indexPath);
                IndexImporter.copyLaneProps(existing, idxBuilder);
            }
            this.incrementReIndexCount(idxBuilder);
            this.getImporter(indexInfo.type).importIndex(root, idxBuilder, indexInfo.indexDir);
            indexDisabler.markDisableFlagIfRequired(indexInfo.indexPath, idxBuilder);
        }
        NodeStoreUtils.mergeWithConcurrentCheck(this.nodeStore, rootBuilder, this.indexEditorProvider);
    }

    private void bringIndexUpToDate() throws CommitFailedException {
        for (String laneName : this.asyncLaneToIndexMapping.keySet()) {
            if (ASYNC_LANE_SYNC.equals(laneName)) continue;
            this.bringAsyncIndexUpToDate(laneName, this.asyncLaneToIndexMapping.get(laneName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bringAsyncIndexUpToDate(String laneName, List<IndexInfo> indexInfos) throws CommitFailedException {
        AsyncIndexerLock.LockToken lockToken = this.interruptCurrentIndexing(laneName);
        boolean success = false;
        try {
            String checkpoint = this.getAsync().getString(laneName);
            Preconditions.checkNotNull(checkpoint, "No current checkpoint found for lane [%s]", laneName);
            NodeState after = this.nodeStore.retrieve(checkpoint);
            Preconditions.checkNotNull(after, "No state found for checkpoint [%s] for lane [%s]", checkpoint, laneName);
            this.log.info("Proceeding to update imported indexes {} to checkpoint [{}] for lane [{}]", new Object[]{indexInfos, checkpoint, laneName});
            NodeState before = this.indexedState;
            NodeBuilder builder = this.nodeStore.getRoot().builder();
            IndexUpdate indexUpdate = new IndexUpdate(this.indexEditorProvider, AsyncLaneSwitcher.getTempLaneName(laneName), this.nodeStore.getRoot(), builder, IndexUpdateCallback.NOOP);
            CommitFailedException exception = EditorDiff.process(VisibleEditor.wrap(indexUpdate), before, after);
            if (exception != null) {
                throw exception;
            }
            this.revertLaneChange(builder, indexInfos);
            NodeStoreUtils.mergeWithConcurrentCheck(this.nodeStore, builder);
            success = true;
            this.log.info("Imported index is updated to repository state at checkpoint [{}] for indexing lane [{}]", (Object)checkpoint, (Object)laneName);
        }
        finally {
            block9: {
                try {
                    this.resumeCurrentIndexing(lockToken);
                }
                catch (RuntimeException | CommitFailedException e) {
                    this.log.warn("Error occurred while releasing indexer lock", (Throwable)e);
                    if (!success) break block9;
                    throw e;
                }
            }
        }
        this.log.info("Import done for indexes {}", indexInfos);
    }

    private void revertLaneChange(NodeBuilder builder, List<IndexInfo> indexInfos) {
        for (IndexInfo info : indexInfos) {
            NodeBuilder idxBuilder = NodeStoreUtils.childBuilder(builder, info.indexPath);
            AsyncLaneSwitcher.revertSwitch(idxBuilder, info.indexPath);
        }
    }

    private void resumeCurrentIndexing(AsyncIndexerLock.LockToken lockToken) throws CommitFailedException {
        this.indexerLock.unlock(lockToken);
    }

    private AsyncIndexerLock.LockToken interruptCurrentIndexing(String laneName) throws CommitFailedException {
        return this.indexerLock.lock(laneName);
    }

    private IndexImporterProvider getImporter(String type) {
        IndexImporterProvider provider = this.importers.get(type);
        return Preconditions.checkNotNull(provider, "No IndexImporterProvider found for type [%s]", type);
    }

    private ListMultimap<String, IndexInfo> mapIndexesToLanes(Map<String, File> indexes) {
        NodeState rootState = this.nodeStore.getRoot();
        ArrayListMultimap<String, IndexInfo> map = ArrayListMultimap.create();
        for (Map.Entry<String, File> e : indexes.entrySet()) {
            String indexPath = e.getKey();
            NodeState indexState = this.indexDefinitionUpdater.getIndexState(indexPath);
            Preconditions.checkArgument(indexState.exists(), "No index node found at path [%s]", indexPath);
            boolean newIndex = !NodeStateUtils.getNode(rootState, indexPath).exists();
            String type = indexState.getString("type");
            Preconditions.checkNotNull(type, "No 'type' property found for index at path [%s]", indexPath);
            String asyncName = IndexImporter.getAsyncLaneName(indexPath, indexState);
            if (asyncName == null) {
                asyncName = ASYNC_LANE_SYNC;
            }
            map.put(asyncName, new IndexInfo(indexPath, e.getValue(), asyncName, type, newIndex));
        }
        return map;
    }

    private static void copyLaneProps(NodeState existing, NodeBuilder indexBuilder) {
        IndexImporter.copy("async", existing, indexBuilder);
        IndexImporter.copy("async-previous", existing, indexBuilder);
    }

    private static void copy(String propName, NodeState existing, NodeBuilder indexBuilder) {
        PropertyState ps = existing.getProperty(propName);
        if (ps != null) {
            indexBuilder.setProperty(ps);
        }
    }

    static String getAsyncLaneName(String indexPath, NodeState indexState) {
        PropertyState asyncPrevious = indexState.getProperty("async-previous");
        if (asyncPrevious != null && !AsyncLaneSwitcher.isNone(asyncPrevious)) {
            return IndexUtils.getAsyncLaneName(indexState, indexPath, asyncPrevious);
        }
        return IndexUtils.getAsyncLaneName(indexState, indexPath);
    }

    private void releaseCheckpoint() {
        this.nodeStore.release(this.indexerInfo.checkpoint);
        this.log.info("Released the referred checkpoint [{}]", (Object)this.indexerInfo.checkpoint);
    }

    private void incrementReIndexCount(NodeBuilder definition) {
        long count = 0L;
        if (definition.hasProperty("reindexCount")) {
            count = definition.getProperty("reindexCount").getValue(Type.LONG);
        }
        definition.setProperty("reindexCount", count + 1L);
    }

    private NodeState getAsync() {
        return this.nodeStore.getRoot().getChildNode(":async");
    }

    private static class IndexInfo {
        final String indexPath;
        final File indexDir;
        final String asyncLaneName;
        final String type;
        final boolean newIndex;

        private IndexInfo(String indexPath, File indexDir, String asyncLaneName, String type, boolean newIndex) {
            this.indexPath = indexPath;
            this.indexDir = indexDir;
            this.asyncLaneName = asyncLaneName;
            this.type = type;
            this.newIndex = newIndex;
        }

        public String toString() {
            return this.indexPath;
        }
    }
}

