/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.guard;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import net.sf.oval.guard.ApiUsageAuditor2;
import net.sf.oval.guard.Guard;
import net.sf.oval.guard.IsGuarded;
import net.sf.oval.guard.ParameterNameResolverAspectJImpl;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.Invocable;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.DeclareParents;
import org.aspectj.lang.annotation.SuppressAjWarnings;
import org.aspectj.lang.reflect.ConstructorSignature;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public abstract class GuardAspect2
extends ApiUsageAuditor2 {
    private static final Log LOG = Log.getLog(GuardAspect2.class);
    @DeclareParents(value="(@net.sf.oval.guard.Guarded *)")
    private IsGuarded implementedInterface;
    private Guard guard;

    public GuardAspect2() {
        this(new Guard());
        this.getGuard().setParameterNameResolver(new ParameterNameResolverAspectJImpl());
    }

    public GuardAspect2(Guard guard) {
        LOG.info("Instantiated");
        this.setGuard(guard);
    }

    @Around(value="execution((@net.sf.oval.guard.Guarded *).new(..))")
    public Object allConstructors(ProceedingJoinPoint thisJoinPoint) throws Throwable {
        ConstructorSignature signature = (ConstructorSignature)thisJoinPoint.getSignature();
        LOG.debug("aroundConstructor() {1}", signature);
        Constructor ctor = signature.getConstructor();
        Object[] args = thisJoinPoint.getArgs();
        Object target = thisJoinPoint.getTarget();
        this.guard.guardConstructorPre(target, ctor, args);
        Object result = thisJoinPoint.proceed();
        this.guard.guardConstructorPost(target, ctor, args);
        return result;
    }

    @SuppressAjWarnings(value={"adviceDidNotMatch"})
    @Around(value="execution(* (@net.sf.oval.guard.Guarded *).*(..))")
    public Object allMethods(ProceedingJoinPoint thisJoinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)thisJoinPoint.getSignature();
        LOG.debug("aroundMethod() {1}", signature);
        Method method = signature.getMethod();
        Object[] args = thisJoinPoint.getArgs();
        Object target = thisJoinPoint.getTarget();
        return this.guard.guardMethod(target, method, args, new ProceedInvocable(thisJoinPoint));
    }

    public Guard getGuard() {
        return this.guard;
    }

    public final void setGuard(Guard guard) {
        this.guard = guard;
    }

    private static final class ProceedInvocable
    implements Invocable {
        final ProceedingJoinPoint thisJoinPoint;

        protected ProceedInvocable(ProceedingJoinPoint thisJoinPoint) {
            this.thisJoinPoint = thisJoinPoint;
        }

        public Object invoke() throws Throwable {
            return this.thisJoinPoint.proceed();
        }
    }
}

