/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.evaluators.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.evaluators.Evaluator;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.commons.evaluators.config.AndFactory;
import org.apache.synapse.commons.evaluators.config.EqualFactory;
import org.apache.synapse.commons.evaluators.config.EvaluatorFactory;
import org.apache.synapse.commons.evaluators.config.MatchFactory;
import org.apache.synapse.commons.evaluators.config.NotFactory;
import org.apache.synapse.commons.evaluators.config.OrFactory;

public class EvaluatorFactoryFinder {
    private static final Log log = LogFactory.getLog(EvaluatorFactoryFinder.class);
    private static final EvaluatorFactoryFinder finder = new EvaluatorFactoryFinder();
    private Map<String, EvaluatorFactory> factories = new HashMap<String, EvaluatorFactory>();

    private EvaluatorFactoryFinder() {
        this.factories.put("and", new AndFactory());
        this.factories.put("or", new OrFactory());
        this.factories.put("not", new NotFactory());
        this.factories.put("match", new MatchFactory());
        this.factories.put("equal", new EqualFactory());
    }

    public static EvaluatorFactoryFinder getInstance() {
        return finder;
    }

    public EvaluatorFactory findEvaluatorFactory(String name) {
        return this.factories.get(name);
    }

    public Evaluator getEvaluator(OMElement elem) throws EvaluatorException {
        EvaluatorFactory fac = this.findEvaluatorFactory(elem.getLocalName());
        if (fac != null) {
            return fac.create(elem);
        }
        this.handleException("Invalid configuration element: " + elem.getLocalName());
        return null;
    }

    private void handleException(String message) throws EvaluatorException {
        log.error((Object)message);
        throw new EvaluatorException(message);
    }
}

