/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSSecHeader {
    protected String actor = null;
    protected boolean mustunderstand = true;
    protected boolean doDebug = false;
    private Element securityHeader = null;

    public WSSecHeader() {
    }

    public WSSecHeader(String actor) {
        this(actor, true);
    }

    public WSSecHeader(String act, boolean mu) {
        this.actor = act;
        this.mustunderstand = mu;
    }

    public void setActor(String act) {
        this.actor = act;
    }

    public void setMustUnderstand(boolean mu) {
        this.mustunderstand = mu;
    }

    public Element getSecurityHeader() {
        return this.securityHeader;
    }

    public boolean isEmpty(Document doc) throws WSSecurityException {
        if (this.securityHeader == null) {
            this.securityHeader = WSSecurityUtil.findWsseSecurityHeaderBlock(doc, doc.getDocumentElement(), this.actor, false);
        }
        return this.securityHeader == null || this.securityHeader.getChildNodes().getLength() == 0;
    }

    public Element insertSecurityHeader(Document doc) throws WSSecurityException {
        if (this.securityHeader != null) {
            return this.securityHeader;
        }
        this.securityHeader = WSSecurityUtil.findWsseSecurityHeaderBlock(doc, doc.getDocumentElement(), this.actor, true);
        String soapNamespace = WSSecurityUtil.getSOAPNamespace(doc.getDocumentElement());
        String soapPrefix = WSSecurityUtil.setNamespace(this.securityHeader, soapNamespace, "soapenv");
        if (this.actor != null && this.actor.length() > 0) {
            String actorLocal = "actor";
            if ("http://www.w3.org/2003/05/soap-envelope".equals(soapNamespace)) {
                actorLocal = "role";
            }
            this.securityHeader.setAttributeNS(soapNamespace, soapPrefix + ":" + actorLocal, this.actor);
        }
        if (this.mustunderstand) {
            String mustUnderstandLocal = "1";
            if ("http://www.w3.org/2003/05/soap-envelope".equals(soapNamespace)) {
                mustUnderstandLocal = "true";
            }
            this.securityHeader.setAttributeNS(soapNamespace, soapPrefix + ":" + "mustUnderstand", mustUnderstandLocal);
        }
        WSSecurityUtil.setNamespace(this.securityHeader, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        return this.securityHeader;
    }

    public void removeSecurityHeader(Document doc) throws WSSecurityException {
        if (this.securityHeader == null) {
            this.securityHeader = WSSecurityUtil.findWsseSecurityHeaderBlock(doc, doc.getDocumentElement(), this.actor, false);
        }
        if (this.securityHeader != null) {
            Node parent = this.securityHeader.getParentNode();
            parent.removeChild(this.securityHeader);
        }
    }
}

