/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.layers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.nn.layers.affine.Backward_output;
import org.apache.sysml.scripts.nn.layers.affine.Init_output;

public class Affine
extends Script {
    public Affine() {
        String string = "scripts/nn/layers/affine.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Init_output init(Object object, Object object2) {
        String string = "source('scripts/nn/layers/affine.dml') as mlcontextns;[W, b] = mlcontextns::init(D, M);";
        Script script = new Script(string);
        script.in("D", object).in("M", object2).out("W").out("b");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("W");
        Matrix matrix2 = mLResults.getMatrix("b");
        Init_output init_output = new Init_output(matrix, matrix2);
        return init_output;
    }

    public String init__docs() {
        String string = "init = function(int D, int M)\n    return (matrix[double] W, matrix[double] b) {\n  /*\n   * Initialize the parameters of this layer.\n   *\n   * Note: This is just a convenience function, and parameters\n   * may be initialized manually if needed.\n   *\n   * We use the heuristic by He et al., which limits the magnification\n   * of inputs/gradients during forward/backward passes by scaling\n   * unit-Gaussian weights by a factor of sqrt(2/n), under the\n   * assumption of relu neurons.\n   *  - http://arxiv.org/abs/1502.01852\n   *\n   * Inputs:\n   *  - D: Dimensionality of the input features (number of features).\n   *  - M: Number of neurons in this layer.\n   *\n   * Outputs:\n   *  - W: Weights, of shape (D, M).\n   *  - b: Biases, of shape (1, M).\n   */\n";
        return string;
    }

    public String init__source() {
        String string = "init = function(int D, int M)\n    return (matrix[double] W, matrix[double] b) {\n  /*\n   * Initialize the parameters of this layer.\n   *\n   * Note: This is just a convenience function, and parameters\n   * may be initialized manually if needed.\n   *\n   * We use the heuristic by He et al., which limits the magnification\n   * of inputs/gradients during forward/backward passes by scaling\n   * unit-Gaussian weights by a factor of sqrt(2/n), under the\n   * assumption of relu neurons.\n   *  - http://arxiv.org/abs/1502.01852\n   *\n   * Inputs:\n   *  - D: Dimensionality of the input features (number of features).\n   *  - M: Number of neurons in this layer.\n   *\n   * Outputs:\n   *  - W: Weights, of shape (D, M).\n   *  - b: Biases, of shape (1, M).\n   */\n  W = rand(rows=D, cols=M, pdf=\"normal\") * sqrt(2.0/D)\n  b = matrix(0, rows=1, cols=M)\n}\n";
        return string;
    }

    public Matrix forward(Object object, Object object2, Object object3) {
        String string = "source('scripts/nn/layers/affine.dml') as mlcontextns;out = mlcontextns::forward(X, W, b);";
        Script script = new Script(string);
        script.in("X", object).in("W", object2).in("b", object3).out("out");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        return matrix;
    }

    public String forward__docs() {
        String string = "forward = function(matrix[double] X, matrix[double] W, matrix[double] b)\n    return (matrix[double] out) {\n  /*\n   * Computes the forward pass for an affine (fully-connected) layer\n   * with M neurons.  The input data has N examples, each with D\n   * features.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, D).\n   *  - W: Weights, of shape (D, M).\n   *  - b: Biases, of shape (1, M).\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, M).\n   */\n";
        return string;
    }

    public String forward__source() {
        String string = "forward = function(matrix[double] X, matrix[double] W, matrix[double] b)\n    return (matrix[double] out) {\n  /*\n   * Computes the forward pass for an affine (fully-connected) layer\n   * with M neurons.  The input data has N examples, each with D\n   * features.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, D).\n   *  - W: Weights, of shape (D, M).\n   *  - b: Biases, of shape (1, M).\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, M).\n   */\n  out = X %*% W + b\n}\n";
        return string;
    }

    public Backward_output backward(Object object, Object object2, Object object3, Object object4) {
        String string = "source('scripts/nn/layers/affine.dml') as mlcontextns;[dX, dW, db] = mlcontextns::backward(dout, X, W, b);";
        Script script = new Script(string);
        script.in("dout", object).in("X", object2).in("W", object3).in("b", object4).out("dX").out("dW").out("db");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dX");
        Matrix matrix2 = mLResults.getMatrix("dW");
        Matrix matrix3 = mLResults.getMatrix("db");
        Backward_output backward_output = new Backward_output(matrix, matrix2, matrix3);
        return backward_output;
    }

    public String backward__docs() {
        String string = "backward = function(matrix[double] dout, matrix[double] X,\n                    matrix[double] W, matrix[double] b)\n    return (matrix[double] dX, matrix[double] dW, matrix[double] db) {\n  /*\n   * Computes the backward pass for a fully-connected (affine) layer\n   * with M neurons.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of shape (N, M).\n   *  - X: Inputs, of shape (N, D).\n   *  - W: Weights, of shape (D, M).\n   *  - b: Biases, of shape (1, M).\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, D).\n   *  - dW: Gradient wrt `W`, of shape (D, M).\n   *  - db: Gradient wrt `b`, of shape (1, M).\n   */\n";
        return string;
    }

    public String backward__source() {
        String string = "backward = function(matrix[double] dout, matrix[double] X,\n                    matrix[double] W, matrix[double] b)\n    return (matrix[double] dX, matrix[double] dW, matrix[double] db) {\n  /*\n   * Computes the backward pass for a fully-connected (affine) layer\n   * with M neurons.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of shape (N, M).\n   *  - X: Inputs, of shape (N, D).\n   *  - W: Weights, of shape (D, M).\n   *  - b: Biases, of shape (1, M).\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, D).\n   *  - dW: Gradient wrt `W`, of shape (D, M).\n   *  - db: Gradient wrt `b`, of shape (1, M).\n   */\n  dX = dout %*% t(W)\n  dW = t(X) %*% dout\n  db = colSums(dout)\n}\n";
        return string;
    }
}

