/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.data.SparseRowVector;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.MatrixReader;
import org.apache.sysds.runtime.io.ReaderTextLIBSVM;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;

public class ReaderTextLIBSVMParallel
extends MatrixReader {
    private int _numThreads = OptimizerUtils.getParallelTextReadParallelism();
    private SplitOffsetInfos _offsets = null;

    @Override
    public MatrixBlock readMatrixFromHDFS(String fname, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        FileInputFormat.addInputPath((JobConf)job, (Path)path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        InputSplit[] splits = informat.getSplits(job, this._numThreads);
        splits = IOUtilFunctions.sortInputSplits(splits);
        ReaderTextLIBSVMParallel.checkValidInputFile(fs, path);
        MatrixBlock ret = this.computeLIBSVMSizeAndCreateOutputMatrixBlock(splits, path, job, rlen, clen, estnnz);
        rlen = ret.getNumRows();
        clen = ret.getNumColumns();
        this.readLIBSVMMatrixFromHDFS(splits, path, job, ret, rlen, clen, blen);
        ret.examSparsity();
        if (rlen >= 0L && rlen != (long)ret.getNumRows()) {
            throw new DMLRuntimeException("Read matrix inconsistent with given meta data: expected nrow=" + rlen + ", real nrow=" + ret.getNumRows());
        }
        return ret;
    }

    @Override
    public MatrixBlock readMatrixFromInputStream(InputStream is, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        return new ReaderTextLIBSVM().readMatrixFromInputStream(is, rlen, clen, blen, estnnz);
    }

    private void readLIBSVMMatrixFromHDFS(InputSplit[] splits, Path path, JobConf job, MatrixBlock dest, long rlen, long clen, int blen) throws IOException {
        FileInputFormat.addInputPath((JobConf)job, (Path)path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        ExecutorService pool = CommonThreadPool.get(this._numThreads);
        try {
            ArrayList<LIBSVMReadTask> tasks = new ArrayList<LIBSVMReadTask>();
            int splitCount = 0;
            for (InputSplit split : splits) {
                tasks.add(new LIBSVMReadTask(split, this._offsets, informat, job, dest, rlen, clen, splitCount++));
            }
            pool.invokeAll(tasks);
            pool.shutdown();
            long lnnz = 0L;
            for (LIBSVMReadTask rt : tasks) {
                lnnz += rt.getPartialNnz();
                if (rt.getReturnCode()) continue;
                Exception err = rt.getException();
                throw new IOException("Read task for libsvm input failed: " + err.toString(), err);
            }
            dest.setNonZeros(lnnz);
        }
        catch (Exception e) {
            throw new IOException("Threadpool issue, while parallel read.", e);
        }
    }

    private MatrixBlock computeLIBSVMSizeAndCreateOutputMatrixBlock(InputSplit[] splits, Path path, JobConf job, long rlen, long clen, long estnnz) throws IOException, DMLRuntimeException {
        int nrow = 0;
        int ncol = (int)clen;
        FileInputFormat.addInputPath((JobConf)job, (Path)path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        try {
            ExecutorService pool = CommonThreadPool.get(this._numThreads);
            ArrayList<CountRowsTask> tasks = new ArrayList<CountRowsTask>();
            for (InputSplit split : splits) {
                tasks.add(new CountRowsTask(split, informat, job));
            }
            pool.invokeAll(tasks);
            pool.shutdown();
            this._offsets = new SplitOffsetInfos(tasks.size());
            for (CountRowsTask rt : tasks) {
                if (!rt.getReturnCode()) {
                    throw new IOException("Count task for libsvm input failed: " + rt.getErrMsg());
                }
                this._offsets.setOffsetPerSplit(tasks.indexOf(rt), nrow);
                this._offsets.setLenghtPerSplit(tasks.indexOf(rt), rt.getRowCount());
                nrow += rt.getRowCount();
            }
        }
        catch (Exception e) {
            throw new IOException("Threadpool Error " + e.getMessage(), e);
        }
        if (rlen != -1L && (long)nrow != rlen || clen != -1L && (long)ncol != clen) {
            String msg = "Read matrix dimensions differ from meta data: [" + nrow + "x" + ncol + "] vs. [" + rlen + "x" + clen + "].";
            if (rlen < (long)nrow || clen < (long)ncol) {
                throw new DMLRuntimeException(msg);
            }
            LOG.warn((Object)msg);
            nrow = (int)rlen;
            ncol = (int)clen;
        }
        long estnnz2 = estnnz < 0L ? (long)nrow * (long)ncol : estnnz;
        return ReaderTextLIBSVMParallel.createOutputMatrixBlock(nrow, ncol, nrow, estnnz2, true, true);
    }

    private static class LIBSVMReadTask
    implements Callable<Object> {
        private InputSplit _split = null;
        private SplitOffsetInfos _splitoffsets = null;
        private TextInputFormat _informat = null;
        private JobConf _job = null;
        private MatrixBlock _dest = null;
        private long _clen = -1L;
        private int _splitCount = 0;
        private boolean _rc = true;
        private Exception _exception = null;
        private long _nnz;

        public LIBSVMReadTask(InputSplit split, SplitOffsetInfos offsets, TextInputFormat informat, JobConf job, MatrixBlock dest, long rlen, long clen, int splitCount) {
            this._split = split;
            this._splitoffsets = offsets;
            this._informat = informat;
            this._job = job;
            this._dest = dest;
            this._clen = clen;
            this._rc = true;
            this._splitCount = splitCount;
        }

        public boolean getReturnCode() {
            return this._rc;
        }

        public Exception getException() {
            return this._exception;
        }

        public long getPartialNnz() {
            return this._nnz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            long lnnz = 0L;
            try {
                RecordReader reader = this._informat.getRecordReader(this._split, this._job, Reporter.NULL);
                LongWritable key = new LongWritable();
                Text value = new Text();
                SparseRowVector vect = new SparseRowVector(1024);
                int row = this._splitoffsets.getOffsetPerSplit(this._splitCount);
                try {
                    while (reader.next((Object)key, (Object)value)) {
                        String rowStr = value.toString().trim();
                        lnnz += (long)ReaderTextLIBSVM.parseLibsvmRow(rowStr, vect, (int)this._clen);
                        this._dest.appendRow(row, vect);
                        ++row;
                    }
                    if (row != this._splitoffsets.getOffsetPerSplit(this._splitCount) + this._splitoffsets.getLenghtPerSplit(this._splitCount)) {
                        throw new IOException("Incorrect number of rows (" + row + ") found in delimited file (" + (this._splitoffsets.getOffsetPerSplit(this._splitCount) + this._splitoffsets.getLenghtPerSplit(this._splitCount)) + "): " + value);
                    }
                }
                finally {
                    IOUtilFunctions.closeSilently(reader);
                }
            }
            catch (Exception ex) {
                this._rc = false;
                this._exception = ex;
            }
            this._nnz = lnnz;
            return null;
        }
    }

    private static class CountRowsTask
    implements Callable<Object> {
        private InputSplit _split = null;
        private TextInputFormat _informat = null;
        private JobConf _job = null;
        private boolean _rc = true;
        private String _errMsg = null;
        private int _nrows = -1;

        public CountRowsTask(InputSplit split, TextInputFormat informat, JobConf job) {
            this._split = split;
            this._informat = informat;
            this._job = job;
            this._nrows = 0;
        }

        public boolean getReturnCode() {
            return this._rc;
        }

        public int getRowCount() {
            return this._nrows;
        }

        public String getErrMsg() {
            return this._errMsg;
        }

        @Override
        public Object call() throws Exception {
            RecordReader reader = this._informat.getRecordReader(this._split, this._job, Reporter.NULL);
            LongWritable key = new LongWritable();
            Text oneLine = new Text();
            try {
                while (reader.next((Object)key, (Object)oneLine)) {
                    ++this._nrows;
                }
            }
            catch (Exception e) {
                this._rc = false;
                this._errMsg = "RecordReader error libsvm format. split: " + this._split.toString() + e.getMessage();
                throw new IOException(this._errMsg);
            }
            finally {
                IOUtilFunctions.closeSilently(reader);
            }
            return null;
        }
    }

    private static class SplitOffsetInfos {
        private int[] offsetPerSplit = null;
        private int[] lenghtPerSplit = null;

        public SplitOffsetInfos(int numSplits) {
            this.lenghtPerSplit = new int[numSplits];
            this.offsetPerSplit = new int[numSplits];
        }

        public int getLenghtPerSplit(int split) {
            return this.lenghtPerSplit[split];
        }

        public void setLenghtPerSplit(int split, int r) {
            this.lenghtPerSplit[split] = r;
        }

        public int getOffsetPerSplit(int split) {
            return this.offsetPerSplit[split];
        }

        public void setOffsetPerSplit(int split, int o) {
            this.offsetPerSplit[split] = o;
        }
    }
}

