/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.bitmap.ABitmap;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.compress.utils.Util;
import org.apache.sysds.runtime.controlprogram.parfor.stat.Timing;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;

public abstract class CompressedSizeEstimator {
    protected static final Log LOG = LogFactory.getLog((String)CompressedSizeEstimator.class.getName());
    protected final MatrixBlock _data;
    protected final CompressionSettings _cs;

    protected CompressedSizeEstimator(MatrixBlock data, CompressionSettings cs) {
        this._data = data;
        this._cs = cs;
    }

    public int getNumRows() {
        return this._cs.transposed ? this._data.getNumColumns() : this._data.getNumRows();
    }

    public int getNumColumns() {
        return this._cs.transposed ? this._data.getNumRows() : this._data.getNumColumns();
    }

    public MatrixBlock getData() {
        return this._data;
    }

    public CompressedSizeInfo computeCompressedSizeInfos(int k) {
        List<CompressedSizeInfoColGroup> sizeInfos = Arrays.asList(this.estimateIndividualColumnGroupSizes(k));
        return new CompressedSizeInfo(sizeInfos);
    }

    public List<CompressedSizeInfoColGroup> computeCompressedSizeInfos(Collection<int[]> columnLists, int k) {
        if (k == 1) {
            return this.computeCompressedSizeInfos(columnLists);
        }
        try {
            ExecutorService pool = CommonThreadPool.get(k);
            ArrayList<SizeEstimationTask> tasks = new ArrayList<SizeEstimationTask>();
            for (int[] g : columnLists) {
                tasks.add(new SizeEstimationTask(this, g));
            }
            List rtask = pool.invokeAll(tasks);
            ArrayList<CompressedSizeInfoColGroup> ret = new ArrayList<CompressedSizeInfoColGroup>();
            for (Future lrtask : rtask) {
                ret.add((CompressedSizeInfoColGroup)lrtask.get());
            }
            pool.shutdown();
            return ret;
        }
        catch (InterruptedException | ExecutionException e) {
            return this.computeCompressedSizeInfos(columnLists);
        }
    }

    public List<CompressedSizeInfoColGroup> computeCompressedSizeInfos(Collection<int[]> columnLists) {
        ArrayList<CompressedSizeInfoColGroup> ret = new ArrayList<CompressedSizeInfoColGroup>();
        for (int[] g : columnLists) {
            ret.add(this.estimateCompressedColGroupSize(g));
        }
        return ret;
    }

    private CompressedSizeInfoColGroup[] estimateIndividualColumnGroupSizes(int k) {
        int _numCols = this.getNumColumns();
        if (LOG.isDebugEnabled()) {
            Timing time = new Timing(true);
            CompressedSizeInfoColGroup[] ret = k > 1 ? this.CompressedSizeInfoColGroup(_numCols, k) : this.CompressedSizeInfoColGroup(_numCols);
            LOG.debug((Object)("CompressedSizeInfo for each column [ms]:" + time.stop()));
            return ret;
        }
        return k > 1 ? this.CompressedSizeInfoColGroup(_numCols, k) : this.CompressedSizeInfoColGroup(_numCols);
    }

    public CompressedSizeInfoColGroup estimateCompressedColGroupSize() {
        int[] colIndexes = this.makeColIndexes();
        return this.estimateCompressedColGroupSize(colIndexes);
    }

    public CompressedSizeInfoColGroup estimateCompressedColGroupSize(int[] colIndexes) {
        return this.estimateCompressedColGroupSize(colIndexes, 8, this.worstCaseUpperBound(colIndexes));
    }

    public abstract CompressedSizeInfoColGroup estimateCompressedColGroupSize(int[] var1, int var2, int var3);

    public final CompressedSizeInfoColGroup estimateJoinCompressedSize(CompressedSizeInfoColGroup g1, CompressedSizeInfoColGroup g2) {
        int[] joined = Util.join(g1.getColumns(), g2.getColumns());
        return this.estimateJoinCompressedSize(joined, g1, g2);
    }

    public CompressedSizeInfoColGroup estimateJoinCompressedSize(int[] joined, CompressedSizeInfoColGroup g1, CompressedSizeInfoColGroup g2) {
        int worstCase;
        int g2V;
        int g1V = g1.getNumVals();
        long max = Math.min((long)(g1V + 1) * (long)((g2V = g2.getNumVals()) + 1), (long)(worstCase = this.worstCaseUpperBound(joined)));
        if (max > Integer.MAX_VALUE) {
            return null;
        }
        if (g1.getMap() == null && g2V != 0 || g2.getMap() == null && g2V != 0) {
            return this.estimateCompressedColGroupSize(joined, Math.max(g1V, g2V), (int)max);
        }
        return this.estimateJoinCompressedSize(joined, g1, g2, (int)max);
    }

    protected abstract int worstCaseUpperBound(int[] var1);

    protected abstract CompressedSizeInfoColGroup estimateJoinCompressedSize(int[] var1, CompressedSizeInfoColGroup var2, CompressedSizeInfoColGroup var3, int var4);

    public EstimationFactors estimateCompressedColGroupSize(ABitmap ubm, int[] colIndexes) {
        return CompressedSizeEstimator.estimateCompressedColGroupSize(ubm, colIndexes, this.getNumRows(), this._cs);
    }

    public static EstimationFactors estimateCompressedColGroupSize(ABitmap ubm, int[] colIndexes, int nrRows, CompressionSettings cs) {
        return EstimationFactors.computeSizeEstimationFactors(ubm, nrRows, cs.validCompressions.contains((Object)AColGroup.CompressionType.RLE), colIndexes);
    }

    protected CompressedSizeInfoColGroup[] CompressedSizeInfoColGroup(int clen) {
        CompressedSizeInfoColGroup[] ret = new CompressedSizeInfoColGroup[clen];
        for (int col = 0; col < clen; ++col) {
            ret[col] = this.estimateCompressedColGroupSize(new int[]{col});
        }
        return ret;
    }

    protected CompressedSizeInfoColGroup[] CompressedSizeInfoColGroup(int clen, int k) {
        try {
            ExecutorService pool = CommonThreadPool.get(k);
            ArrayList<SizeEstimationTask> tasks = new ArrayList<SizeEstimationTask>();
            for (int col = 0; col < clen; ++col) {
                tasks.add(new SizeEstimationTask(this, col));
            }
            List rtask = pool.invokeAll(tasks);
            ArrayList ret = new ArrayList();
            for (Future lrtask : rtask) {
                ret.add(lrtask.get());
            }
            pool.shutdown();
            return ret.toArray(new CompressedSizeInfoColGroup[0]);
        }
        catch (InterruptedException | ExecutionException e) {
            return this.CompressedSizeInfoColGroup(clen);
        }
    }

    private int[] makeColIndexes() {
        int _numCols = this.getNumColumns();
        int[] colIndexes = new int[_numCols];
        for (int i = 0; i < _numCols; ++i) {
            colIndexes[i] = i;
        }
        return colIndexes;
    }

    protected static class SizeEstimationTask
    implements Callable<CompressedSizeInfoColGroup> {
        private final CompressedSizeEstimator _estimator;
        private final int[] _cols;

        protected SizeEstimationTask(CompressedSizeEstimator estimator, int col) {
            this._estimator = estimator;
            this._cols = new int[]{col};
        }

        protected SizeEstimationTask(CompressedSizeEstimator estimator, int[] cols) {
            this._estimator = estimator;
            this._cols = cols;
        }

        @Override
        public CompressedSizeInfoColGroup call() {
            return this._estimator.estimateCompressedColGroupSize(this._cols);
        }
    }
}

