/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.io.TensorWriter;
import org.apache.sysds.runtime.io.TensorWriterBinaryBlock;
import org.apache.sysds.runtime.io.TensorWriterTextCell;

public class TensorWriterFactory {
    public static TensorWriter createTensorWriter(Types.FileFormat fmt) {
        TensorWriter writer = null;
        if (fmt == Types.FileFormat.TEXT) {
            writer = new TensorWriterTextCell();
        } else if (fmt == Types.FileFormat.BINARY) {
            writer = new TensorWriterBinaryBlock();
        } else {
            throw new DMLRuntimeException("Failed to create tensor writer for unknown format: " + fmt.toString());
        }
        return writer;
    }
}

