/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.validator;

import org.apache.tapestry5.Field;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.ioc.MessageFormatter;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.javascript.DataConstants;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.validator.AbstractValidator;

class CheckboxValidator
extends AbstractValidator<Void, Object> {
    private final Boolean expectedValue;
    private final String expectedStatus;

    public CheckboxValidator(JavaScriptSupport javaScriptSupport, String messageKey, Boolean expectedValue, String expectedStatus) {
        super(null, Object.class, messageKey, javaScriptSupport);
        this.expectedValue = expectedValue;
        this.expectedStatus = expectedStatus;
    }

    @Override
    public void validate(Field field, Void constraintValue, MessageFormatter formatter, Object value) throws ValidationException {
        if (!this.expectedValue.equals(value)) {
            throw new ValidationException(this.buildMessage(formatter, field));
        }
    }

    private String buildMessage(MessageFormatter formatter, Field field) {
        return formatter.format(new Object[]{field.getLabel()});
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    @Override
    public void render(Field field, Void constraintValue, MessageFormatter formatter, MarkupWriter writer, FormSupport formSupport) {
        if (formSupport.isClientValidationEnabled()) {
            this.javaScriptSupport.require("t5/core/validation");
            writer.attributes(DataConstants.VALIDATION_ATTRIBUTE, true, "data-expected-status", this.expectedStatus, "data-checked-message", this.buildMessage(formatter, field));
        }
    }

    public String toString() {
        return "Checkbox must be " + this.expectedStatus + " validator";
    }
}

