/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import org.apache.tapestry5.ComponentAction;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.PropertyOverrides;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.beanmodel.BeanModel;
import org.apache.tapestry5.beanmodel.BeanModelUtils;
import org.apache.tapestry5.beanmodel.services.BeanModelSource;
import org.apache.tapestry5.commons.internal.util.TapestryException;
import org.apache.tapestry5.internal.BeanEditContextImpl;
import org.apache.tapestry5.internal.BeanValidationContext;
import org.apache.tapestry5.internal.BeanValidationContextImpl;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.apache.tapestry5.services.BeanEditContext;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.FormSupport;

@SupportsInformalParameters
public class BeanEditor {
    private static final ComponentAction<BeanEditor> CLEANUP_ENVIRONMENT = new CleanupEnvironment();
    @Parameter(autoconnect=true)
    private Object object;
    @Parameter(defaultPrefix="literal")
    private String include;
    @Parameter(defaultPrefix="literal")
    private String exclude;
    @Parameter(defaultPrefix="literal")
    private String reorder;
    @Parameter(defaultPrefix="literal")
    private String add;
    @Parameter
    @Property(write=false)
    private BeanModel model;
    @Parameter(value="this", allowNull=false)
    @Property(write=false)
    private PropertyOverrides overrides;
    @Inject
    private BeanModelSource modelSource;
    @Inject
    private ComponentResources resources;
    @Inject
    private Environment environment;
    @Environmental
    private FormSupport formSupport;
    @Property
    private String propertyName;
    private Object cachedObject;

    public Object getObject() {
        return this.cachedObject;
    }

    void setupRender() {
        this.formSupport.storeAndExecute(this, new Prepare());
    }

    void cleanupRender() {
        this.formSupport.storeAndExecute(this, CLEANUP_ENVIRONMENT);
    }

    void doPrepare() {
        if (this.model == null) {
            Class type = this.resources.getBoundType("object");
            this.model = this.modelSource.createEditModel(type, this.overrides.getOverrideMessages());
            BeanModelUtils.modify((BeanModel)this.model, (String)this.add, (String)this.include, (String)this.exclude, (String)this.reorder);
        }
        if (this.object == null) {
            try {
                this.object = this.model.newInstance();
            }
            catch (Exception ex) {
                String message = String.format("Exception instantiating instance of %s (for component '%s'): %s", PlasticUtils.toTypeName((Class)this.model.getBeanType()), this.resources.getCompleteId(), ex);
                throw new TapestryException(message, this.resources.getLocation(), (Throwable)ex);
            }
        }
        BeanEditContextImpl context = new BeanEditContextImpl(this.model.getBeanType());
        this.cachedObject = this.object;
        this.environment.push(BeanEditContext.class, context);
        this.environment.push(BeanValidationContext.class, new BeanValidationContextImpl(this.object));
    }

    void cleanupEnvironment() {
        this.environment.pop(BeanEditContext.class);
        this.environment.pop(BeanValidationContext.class);
    }

    void inject(ComponentResources resources, PropertyOverrides overrides, BeanModelSource source, Environment environment) {
        this.resources = resources;
        this.overrides = overrides;
        this.environment = environment;
        this.modelSource = source;
    }

    public static class Prepare
    implements ComponentAction<BeanEditor> {
        private static final long serialVersionUID = 6273600092955522585L;

        @Override
        public void execute(BeanEditor component) {
            component.doPrepare();
        }

        public String toString() {
            return "BeanEditor.Prepare";
        }
    }

    static class CleanupEnvironment
    implements ComponentAction<BeanEditor> {
        private static final long serialVersionUID = 6867226962459227016L;

        CleanupEnvironment() {
        }

        @Override
        public void execute(BeanEditor component) {
            component.cleanupEnvironment();
        }

        public String toString() {
            return "BeanEditor.CleanupEnvironment";
        }
    }
}

