/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

@ChannelHandler.Sharable
public class HttpContentDecompressionHandler
extends ChannelInboundHandlerAdapter {
    private static final AttributeKey<Inflater> INFLATER = AttributeKey.valueOf((String)"inflater");
    private static final int MIN_BUFFER_SIZE = 16;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Object out = msg;
        if (msg instanceof HttpResponse && this.hasDeflateTransferEncoding(((HttpResponse)msg).headers())) {
            ctx.attr(INFLATER).set((Object)new Inflater());
        }
        if (msg instanceof HttpContent) {
            Inflater decompressor = (Inflater)ctx.attr(INFLATER).get();
            if (null == decompressor) {
                super.channelRead(ctx, msg);
                return;
            }
            ByteBuf chunk = ((HttpContent)msg).content();
            decompressor.setInput(ByteBufUtil.getBytes((ByteBuf)chunk));
            int decompressedSizeEstimate = chunk.readableBytes() * 8;
            byte[] outBuf = new byte[Math.max(decompressedSizeEstimate, 16)];
            try {
                int writeIdx = 0;
                int bytesWritten = decompressor.inflate(outBuf, writeIdx, outBuf.length);
                while (bytesWritten == outBuf.length - writeIdx) {
                    outBuf = Arrays.copyOf(outBuf, outBuf.length * 2);
                    bytesWritten = decompressor.inflate(outBuf, writeIdx += bytesWritten, outBuf.length - writeIdx);
                }
                out = ((HttpContent)msg).replace(Unpooled.wrappedBuffer((byte[])outBuf).writerIndex(writeIdx += bytesWritten));
                ReferenceCountUtil.release((Object)msg);
                if (out instanceof LastHttpContent) {
                    ((Inflater)ctx.attr(INFLATER).getAndSet(null)).end();
                }
            }
            catch (DataFormatException dfe) {
                ((Inflater)ctx.attr(INFLATER).getAndSet(null)).end();
                ctx.fireExceptionCaught((Throwable)dfe);
                return;
            }
        }
        super.channelRead(ctx, out);
    }

    private boolean hasDeflateTransferEncoding(HttpHeaders headers) {
        for (String value : headers.getAll((CharSequence)HttpHeaderNames.CONTENT_ENCODING)) {
            if (!"deflate".equals(value)) continue;
            return true;
        }
        return false;
    }
}

