/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.messaging;

import jakarta.servlet.ServletRequest;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.AbstractCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.X509Credential;

public class ServletRequestX509CredentialAdapter
extends AbstractCredential
implements X509Credential {
    @Nonnull
    @NotEmpty
    public static final String X509_CERT_REQUEST_ATTRIBUTE = "javax.servlet.request.X509Certificate";
    @Nonnull
    @NotEmpty
    public static final String JAKARTA_X509_CERT_REQUEST_ATTRIBUTE = "jakarta.servlet.request.X509Certificate";
    @Nonnull
    private X509Certificate cert;
    @Nonnull
    private List<X509Certificate> certChain;

    public ServletRequestX509CredentialAdapter(@Nonnull ServletRequest request) throws SecurityException {
        X509Certificate[] chain = (X509Certificate[])request.getAttribute(JAKARTA_X509_CERT_REQUEST_ATTRIBUTE);
        if (chain == null || chain.length == 0) {
            chain = (X509Certificate[])request.getAttribute(X509_CERT_REQUEST_ATTRIBUTE);
        }
        if (chain == null || chain.length == 0) {
            throw new SecurityException("Servlet request does not contain X.509 certificates");
        }
        this.cert = chain[0];
        this.certChain = CollectionSupport.copyToList(Arrays.asList(chain));
        this.setUsageType(UsageType.SIGNING);
    }

    @Override
    @Nonnull
    public Class<? extends Credential> getCredentialType() {
        return X509Credential.class;
    }

    @Override
    @Nonnull
    public X509Certificate getEntityCertificate() {
        return this.cert;
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public Collection<X509Certificate> getEntityCertificateChain() {
        return this.certChain;
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    public Collection<X509CRL> getCRLs() {
        return null;
    }

    @Override
    @Nullable
    public PublicKey getPublicKey() {
        return this.getEntityCertificate().getPublicKey();
    }
}

