/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.dynamic;

import java.sql.Connection;
import java.util.List;
import java.util.Set;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicRole;
import org.apache.fulcrum.security.torque.om.TorqueDynamicGroupRole;
import org.apache.fulcrum.security.torque.om.TorqueDynamicGroupRolePeer;
import org.apache.fulcrum.security.torque.om.TorqueDynamicPermissionPeer;
import org.apache.fulcrum.security.torque.om.TorqueDynamicRolePeer;
import org.apache.fulcrum.security.torque.om.TorqueDynamicRolePermission;
import org.apache.fulcrum.security.torque.om.TorqueDynamicRolePermissionPeer;
import org.apache.fulcrum.security.torque.security.TorqueAbstractSecurityEntity;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.SimpleKey;

public abstract class TorqueAbstractDynamicRole
extends TorqueAbstractSecurityEntity
implements DynamicRole {
    private static final long serialVersionUID = 2163956770966574224L;
    private Set<Group> groupSet = null;
    private Set<Permission> permissionSet = null;

    protected List<TorqueDynamicRolePermission> getTorqueDynamicRolePermissionsJoinTorqueDynamicPermission(Criteria criteria, Connection con) throws TorqueException {
        criteria.and((Object)TorqueDynamicRolePermissionPeer.ROLE_ID, (Object)this.getEntityId());
        return TorqueDynamicRolePermissionPeer.doSelectJoinTorqueDynamicPermission(criteria, con);
    }

    protected List<TorqueDynamicGroupRole> getTorqueDynamicGroupRolesJoinTorqueDynamicGroup(Criteria criteria, Connection con) throws TorqueException {
        criteria.and((Object)TorqueDynamicGroupRolePeer.ROLE_ID, (Object)this.getEntityId());
        return TorqueDynamicGroupRolePeer.doSelectJoinTorqueDynamicGroup(criteria, con);
    }

    public void addGroup(Group group) {
        this.getGroups().add((SecurityEntity)group);
    }

    public void addPermission(Permission permission) {
        this.getPermissions().add((SecurityEntity)permission);
    }

    public GroupSet getGroups() {
        if (this.groupSet == null) {
            this.groupSet = new GroupSet();
        } else if (!(this.groupSet instanceof GroupSet)) {
            this.groupSet = new GroupSet(this.groupSet);
        }
        return (GroupSet)this.groupSet;
    }

    public <T extends Group> Set<T> getGroupsAsSet() {
        return this.groupSet;
    }

    public PermissionSet getPermissions() {
        if (this.permissionSet == null) {
            this.permissionSet = new PermissionSet();
        } else if (!(this.permissionSet instanceof PermissionSet)) {
            this.permissionSet = new PermissionSet(this.permissionSet);
        }
        return (PermissionSet)this.permissionSet;
    }

    public <T extends Permission> Set<T> getPermissionsAsSet() {
        return this.permissionSet;
    }

    public void removeGroup(Group group) {
        this.getGroups().remove((Object)group);
    }

    public void removePermission(Permission permission) {
        this.getPermissions().remove((Object)permission);
    }

    public void setGroups(GroupSet groups) {
        this.groupSet = groups != null ? groups : new GroupSet();
    }

    public <T extends Group> void setGroupsAsSet(Set<T> groups) {
        this.setGroups(new GroupSet(groups));
    }

    public void setPermissions(PermissionSet permissionSet) {
        this.permissionSet = permissionSet != null ? permissionSet : new PermissionSet();
    }

    public <T extends Permission> void setPermissionsAsSet(Set<T> permissions) {
        this.setPermissions(new PermissionSet(permissions));
    }

    public String getDatabaseName() {
        return TorqueDynamicPermissionPeer.DATABASE_NAME;
    }

    @Override
    public void retrieveAttachedObjects(Connection con) throws DataBackendException {
        this.retrieveAttachedObjects(con, false);
    }

    @Override
    public void retrieveAttachedObjects(Connection con, Boolean lazy) throws DataBackendException {
        this.permissionSet = new PermissionSet();
        try {
            List<TorqueDynamicRolePermission> rolepermissions = this.getTorqueDynamicRolePermissionsJoinTorqueDynamicPermission(new Criteria(), con);
            for (TorqueDynamicRolePermission tdrp : rolepermissions) {
                this.permissionSet.add((Permission)tdrp.getTorqueDynamicPermission());
            }
            this.groupSet = new GroupSet();
            List<TorqueDynamicGroupRole> grouproles = this.getTorqueDynamicGroupRolesJoinTorqueDynamicGroup(new Criteria(), con);
            for (TorqueDynamicGroupRole tdgr : grouproles) {
                this.groupSet.add((Group)tdgr.getTorqueDynamicGroup());
            }
        }
        catch (TorqueException e) {
            throw new DataBackendException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void update(Connection con) throws TorqueException {
        Criteria criteria;
        if (this.permissionSet != null) {
            criteria = new Criteria();
            criteria.where((Object)TorqueDynamicRolePermissionPeer.ROLE_ID, (Object)this.getEntityId());
            TorqueDynamicRolePermissionPeer.doDelete(criteria, con);
            for (Permission p : this.permissionSet) {
                TorqueDynamicRolePermission rp = new TorqueDynamicRolePermission();
                rp.setPermissionId((Integer)p.getId());
                rp.setRoleId(this.getEntityId());
                rp.save(con);
            }
        }
        if (this.groupSet != null) {
            criteria = new Criteria();
            criteria.where((Object)TorqueDynamicGroupRolePeer.ROLE_ID, (Object)this.getEntityId());
            TorqueDynamicGroupRolePeer.doDelete(criteria, con);
            for (Group g : this.groupSet) {
                TorqueDynamicGroupRole gr = new TorqueDynamicGroupRole();
                gr.setGroupId((Integer)g.getId());
                gr.setRoleId(this.getEntityId());
                gr.save(con);
            }
        }
        try {
            this.save(con);
        }
        catch (Exception e) {
            throw new TorqueException((Throwable)e);
        }
    }

    @Override
    public void delete() throws TorqueException {
        TorqueDynamicRolePeer.doDelete(SimpleKey.keyFor((Number)this.getEntityId()));
    }
}

