/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.context;

import java.io.File;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.fulcrum.yaafi.framework.util.Validate;

public class YaafiToAvalonContextMapper {
    private String urnAvalonName;
    private ClassLoader urnAvalonClassLoader;

    public YaafiToAvalonContextMapper(String urnAvalonName, ClassLoader urnAvalonClassLoader) {
        Validate.notEmpty(urnAvalonName, "urnAvalonName");
        Validate.notNull(urnAvalonClassLoader, "urnAvalonClassLoader");
        this.urnAvalonName = urnAvalonName;
        this.urnAvalonClassLoader = urnAvalonClassLoader;
    }

    public ClassLoader getUrnAvalonClassLoader() {
        return this.urnAvalonClassLoader;
    }

    public String getUrnAvalonName() {
        return this.urnAvalonName;
    }

    public DefaultContext mapTo(Context context, String to) throws ContextException {
        Validate.notNull(context, "context");
        Validate.notEmpty(to, "to");
        if ("phoenix".equals(to)) {
            return this.mapToPhoenix(context);
        }
        if ("fortress".equals(to)) {
            return this.mapToFortress(context);
        }
        if ("merlin".equals(to)) {
            return this.mapToMerlin(context);
        }
        if ("yaafi".equals(to)) {
            return this.mapToYaafi(context);
        }
        String msg = "Don't know the following container type : " + to;
        throw new IllegalArgumentException(msg);
    }

    private DefaultContext mapToPhoenix(Context context) throws ContextException {
        DefaultContext result = this.createDefaultContext(context);
        String urnAvalonPartition = (String)context.get((Object)"urn:avalon:partition");
        File urnAvalonHome = (File)context.get((Object)"urn:avalon:home");
        String urnAvalonName = this.getUrnAvalonName();
        result.put((Object)"app.name", (Object)urnAvalonPartition);
        result.put((Object)"app.home", (Object)urnAvalonHome);
        result.put((Object)"block.name", (Object)urnAvalonName);
        return result;
    }

    private DefaultContext mapToFortress(Context context) throws ContextException {
        DefaultContext result = this.createDefaultContext(context);
        String urnAvalonPartition = (String)context.get((Object)"urn:avalon:partition");
        File urnAvalonHome = (File)context.get((Object)"urn:avalon:home");
        File urnAvalonTemp = (File)context.get((Object)"urn:avalon:temp");
        String urnAvalonName = this.getUrnAvalonName();
        result.put((Object)"component.id", (Object)urnAvalonPartition);
        result.put((Object)"component.logger", (Object)urnAvalonName);
        result.put((Object)"context-root", (Object)urnAvalonHome);
        result.put((Object)"impl.workDir", (Object)urnAvalonTemp);
        return result;
    }

    private DefaultContext mapToMerlin(Context context) throws ContextException {
        DefaultContext result = this.createDefaultContext(context);
        String urnAvalonPartition = (String)context.get((Object)"urn:avalon:partition");
        File urnAvalonHome = (File)context.get((Object)"urn:avalon:home");
        File urnAvalonTemp = (File)context.get((Object)"urn:avalon:temp");
        String urnAvalonName = this.getUrnAvalonName();
        ClassLoader urnAvalonClossLoader = this.getUrnAvalonClassLoader();
        result.put((Object)"urn:avalon:partition", (Object)urnAvalonPartition);
        result.put((Object)"urn:avalon:name", (Object)urnAvalonName);
        result.put((Object)"urn:avalon:home", (Object)urnAvalonHome);
        result.put((Object)"urn:avalon:temp", (Object)urnAvalonTemp);
        result.put((Object)"urn:avalon:classloader", (Object)urnAvalonClossLoader);
        return result;
    }

    private DefaultContext mapToYaafi(Context context) throws ContextException {
        DefaultContext result = this.createDefaultContext(context);
        String urnAvalonPartition = (String)context.get((Object)"urn:avalon:partition");
        File urnAvalonHome = (File)context.get((Object)"urn:avalon:home");
        File urnAvalonTemp = (File)context.get((Object)"urn:avalon:temp");
        String urnAvalonName = this.getUrnAvalonName();
        ClassLoader urnAvalonClossLoader = this.getUrnAvalonClassLoader();
        result.put((Object)"urn:avalon:partition", (Object)urnAvalonPartition);
        result.put((Object)"urn:avalon:name", (Object)urnAvalonName);
        result.put((Object)"urn:avalon:home", (Object)urnAvalonHome);
        result.put((Object)"urn:avalon:temp", (Object)urnAvalonTemp);
        result.put((Object)"urn:avalon:classloader", (Object)urnAvalonClossLoader);
        result.put((Object)"componentAppRoot", (Object)urnAvalonHome.getAbsolutePath());
        return result;
    }

    private DefaultContext createDefaultContext(Context context) {
        return new DefaultContext(context);
    }
}

