/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratum.ojb;

import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.exception.NestableException;
import org.apache.stratum.lifecycle.Configurable;
import org.apache.stratum.lifecycle.Initializable;

public class OJBComponent
implements Configurable,
Initializable {
    private PersistenceBroker pBroker = null;
    private String propLocation;
    private String repositoryLocation;

    public void configure(Configuration configuration) throws NestableException {
        this.propLocation = configuration.getString("ojb.properties.location");
        this.repositoryLocation = configuration.getString("ojb.repository.location");
    }

    public void initialize() throws Exception {
        if (this.propLocation == null) {
            throw new Exception("The property ojb.properties.location was not found in the properties file");
        }
        if (this.repositoryLocation == null) {
            throw new Exception("The property ojb.repository.location was not found in the properties file");
        }
        System.setProperty("OJB.properties", this.propLocation);
        this.pBroker = PersistenceBrokerFactory.createPersistenceBroker((String)this.repositoryLocation);
    }

    public PersistenceBroker getPersistenceBroker() {
        return this.pBroker;
    }
}

