/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messagelet;

import java.util.Iterator;
import javax.jms.JMSException;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.messagelet.SubscriptionManager;
import org.apache.commons.messagelet.model.SubscriptionDigester;
import org.apache.commons.messagelet.model.SubscriptionList;
import org.apache.commons.messenger.Messenger;
import org.apache.commons.messenger.MessengerManager;

public class Main {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$messagelet$Main == null ? (class$org$apache$commons$messagelet$Main = Main.class$("org.apache.commons.messagelet.Main")) : class$org$apache$commons$messagelet$Main));
    private MessengerManager manager;
    private SubscriptionList subscriptionList;
    private String connectionsConfig = "Messenger.xml";
    private String subscriptionsConfig = "subscriptions.xml";
    private boolean useStopWatch = false;
    static /* synthetic */ Class class$org$apache$commons$messagelet$Main;

    public static void main(String[] args) {
        Main main = new Main();
        if (args.length <= 0) {
            System.out.println("Usage <subscriptionConfigFile> [<connectionsConfigFile>]");
            return;
        }
        if (args.length > 0) {
            main.setSubscriptionsConfig(args[0]);
        }
        if (args.length > 1) {
            main.setConnectionsConfig(args[1]);
        }
        try {
            main.run();
        }
        catch (Exception e) {
            log.error((Object)("Caught: " + e), (Throwable)e);
        }
    }

    public void run() throws Exception {
        SubscriptionManager subscriber = new SubscriptionManager();
        subscriber.setMessengerManager(this.getMessengerManager());
        subscriber.setSubscriptionList(this.createSubscriptionList());
        subscriber.setServletContext(this.getServletContext());
        subscriber.subscribe();
        Iterator iter = this.manager.getMessengerNames();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Messenger messenger = this.manager.getMessenger(name);
            try {
                messenger.getConnection().start();
            }
            catch (JMSException e) {
                log.error((Object)("Caught exception trying to start messenger: " + name + ". Exception: " + (Object)((Object)e)), (Throwable)e);
            }
        }
    }

    public Messenger getMessenger(String name) throws JMSException {
        return this.getMessengerManager().getMessenger(name);
    }

    public String getConnectionsConfig() {
        return this.connectionsConfig;
    }

    public void setConnectionsConfig(String connectionsConfig) {
        this.connectionsConfig = connectionsConfig;
    }

    public String getSubscriptionsConfig() {
        return this.subscriptionsConfig;
    }

    public void setSubscriptionsConfig(String subscriptionsConfig) {
        this.subscriptionsConfig = subscriptionsConfig;
    }

    public MessengerManager getMessengerManager() throws JMSException {
        if (this.manager == null) {
            this.manager = this.createMessengerManager();
            MessengerManager.setInstance(this.manager);
        }
        return this.manager;
    }

    public void setMessengerManager(MessengerManager manager) {
        this.manager = manager;
    }

    protected MessengerManager createMessengerManager() throws JMSException {
        String config = this.connectionsConfig;
        log.info((Object)("Creating the JMS connections from the file: " + config));
        try {
            return MessengerManager.load(config);
        }
        catch (JMSException e) {
            log.error((Object)("Could not parse Messenger connection XML deployment document for URL: " + config), (Throwable)e);
            throw new JMSException("Could not parse Messenger connection XML deployment document for URL: " + config + " reason: " + (Object)((Object)e));
        }
    }

    protected SubscriptionList createSubscriptionList() throws JMSException {
        String config = this.subscriptionsConfig;
        log.info((Object)("Loading the JMS subscriptions from: " + config));
        try {
            SubscriptionDigester digester = new SubscriptionDigester();
            return (SubscriptionList)digester.parse(config);
        }
        catch (Exception e) {
            log.error((Object)("Could not parse Messenger subscription XML deployment document for URL: " + config), (Throwable)e);
            throw new JMSException("Could not parse Messenger subscription XML deployment document for URL: " + config + " reason: " + e);
        }
    }

    protected ServletContext getServletContext() {
        return null;
    }

    protected void waitForever() {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            while (true) {
                try {
                    lock.wait();
                }
                catch (Exception e) {
                    log.warn((Object)("Main thread interupted: " + e), (Throwable)e);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

