/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.security;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public abstract class SecuritySet
implements Serializable {
    protected Map nameMap = new TreeMap();
    protected Map idMap = new TreeMap();

    public Set getSet() {
        return new HashSet(this.nameMap.values());
    }

    public Set getNames() {
        return this.nameMap.keySet();
    }

    public Set getIds() {
        return this.idMap.keySet();
    }

    public void clear() {
        this.nameMap.clear();
        this.idMap.clear();
    }

    public boolean contains(String groupName) {
        return this.containsName(groupName);
    }

    public boolean containsName(String name) {
        return StringUtils.isNotEmpty((String)name) ? this.nameMap.containsKey(name) : false;
    }

    public boolean containsId(int id) {
        return id == 0 ? false : this.idMap.containsKey(new Integer(id));
    }

    public Iterator iterator() {
        return this.nameMap.values().iterator();
    }

    public Iterator elements() {
        return this.iterator();
    }

    public int size() {
        return this.nameMap.size();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(12 * this.size());
        Iterator it = this.nameMap.keySet().iterator();
        while (it.hasNext()) {
            sbuf.append((String)it.next());
            if (!it.hasNext()) continue;
            sbuf.append(", ");
        }
        return sbuf.toString();
    }
}

