/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.manager;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.StackObjectPool;
import org.apache.jcs.access.GroupCacheAccess;
import org.apache.jcs.access.exception.CacheException;
import org.apache.torque.TorqueException;
import org.apache.torque.manager.MethodCacheKey;

public class MethodResultCache {
    private ObjectPool pool;
    private GroupCacheAccess jcsCache;
    private Map groups;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$torque$manager$MethodResultCache == null ? (class$org$apache$torque$manager$MethodResultCache = MethodResultCache.class$("org.apache.torque.manager.MethodResultCache")) : class$org$apache$torque$manager$MethodResultCache));
    static /* synthetic */ Class class$org$apache$torque$manager$MethodResultCache;

    public MethodResultCache(GroupCacheAccess cache) throws TorqueException {
        this.jcsCache = cache;
        this.groups = new HashMap();
        this.pool = new StackObjectPool((PoolableObjectFactory)new MethodCacheKey.Factory(), 10000);
    }

    protected MethodResultCache() {
    }

    public void clear() {
        if (this.jcsCache != null) {
            try {
                this.jcsCache.clear();
                this.groups.clear();
            }
            catch (CacheException ce) {
                log.error((Object)new TorqueException("Could not clear cache due to internal JCS error.", ce));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getImpl(MethodCacheKey key) {
        Object result = null;
        if (this.jcsCache != null) {
            MethodResultCache methodResultCache = this;
            synchronized (methodResultCache) {
                result = this.jcsCache.getFromGroup((Object)key, key.getGroupKey());
            }
        }
        if (result != null && log.isDebugEnabled()) {
            log.debug((Object)("MethodResultCache saved expensive operation: " + key));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object putImpl(MethodCacheKey key, Object value) throws TorqueException {
        String group = key.getGroupKey();
        if (!this.groups.containsKey(group)) {
            this.groups.put(group, null);
        }
        Object old = null;
        if (this.jcsCache != null) {
            try {
                MethodResultCache methodResultCache = this;
                synchronized (methodResultCache) {
                    old = this.jcsCache.getFromGroup((Object)key, group);
                    this.jcsCache.putInGroup((Object)key, group, value);
                }
            }
            catch (CacheException ce) {
                throw new TorqueException("Could not cache due to internal JCS error", ce);
            }
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object removeImpl(MethodCacheKey key) throws TorqueException {
        Object old = null;
        if (this.jcsCache != null) {
            MethodResultCache methodResultCache = this;
            synchronized (methodResultCache) {
                old = this.jcsCache.getFromGroup((Object)key, key.getGroupKey());
                this.jcsCache.remove((Object)key, key.getGroupKey());
            }
        }
        return old;
    }

    public Object get(Serializable instanceOrClass, String method) {
        Object result = null;
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
                key.init(instanceOrClass, method);
                result = this.getImpl(key);
                try {
                    this.pool.returnObject((Object)key);
                }
                catch (Exception e) {
                    log.warn((Object)"Nonfatal error.  Could not return key to pool", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return result;
    }

    public Object get(Serializable instanceOrClass, String method, Serializable arg1) {
        Object result = null;
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
                key.init(instanceOrClass, method, arg1);
                result = this.getImpl(key);
                try {
                    this.pool.returnObject((Object)key);
                }
                catch (Exception e) {
                    log.warn((Object)"Nonfatal error.  Could not return key to pool", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return result;
    }

    public Object get(Serializable instanceOrClass, String method, Serializable arg1, Serializable arg2) {
        Object result = null;
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
                key.init(instanceOrClass, method, arg1, arg2);
                result = this.getImpl(key);
                try {
                    this.pool.returnObject((Object)key);
                }
                catch (Exception e) {
                    log.warn((Object)"Nonfatal error.  Could not return key to pool", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return result;
    }

    public Object get(Serializable instanceOrClass, String method, Serializable arg1, Serializable arg2, Serializable arg3) {
        Object result = null;
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
                key.init(instanceOrClass, method, arg1, arg2, arg3);
                result = this.getImpl(key);
                try {
                    this.pool.returnObject((Object)key);
                }
                catch (Exception e) {
                    log.warn((Object)"Nonfatal error.  Could not return key to pool", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return result;
    }

    public Object get(Serializable[] keys) {
        Object result = null;
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
                key.init(keys);
                result = this.getImpl(key);
                try {
                    this.pool.returnObject((Object)key);
                }
                catch (Exception e) {
                    log.warn((Object)"Nonfatal error.  Could not return key to pool", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return result;
    }

    public void put(Object value, Serializable instanceOrClass, String method) {
        try {
            MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
            key.init(instanceOrClass, method);
            this.putImpl(key, value);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public void put(Object value, Serializable instanceOrClass, String method, Serializable arg1) {
        try {
            MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
            key.init(instanceOrClass, method, arg1);
            this.putImpl(key, value);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public void put(Object value, Serializable instanceOrClass, String method, Serializable arg1, Serializable arg2) {
        try {
            MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
            key.init(instanceOrClass, method, arg1, arg2);
            this.putImpl(key, value);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public void put(Object value, Serializable instanceOrClass, String method, Serializable arg1, Serializable arg2, Serializable arg3) {
        try {
            MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
            key.init(instanceOrClass, method, arg1, arg2, arg3);
            this.putImpl(key, value);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public void put(Object value, Serializable[] keys) {
        try {
            MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
            key.init(keys);
            this.putImpl(key, value);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public void removeAll(Serializable instanceOrClass, String method) {
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
                key.init(instanceOrClass, method);
                String groupName = key.getGroupKey();
                this.jcsCache.invalidateGroup(groupName);
                this.groups.remove(groupName);
                try {
                    this.pool.returnObject((Object)key);
                }
                catch (Exception e) {
                    log.warn((Object)"Nonfatal error.  Could not return key to pool", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
    }

    public Object remove(Serializable instanceOrClass, String method) {
        Object result = null;
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
                key.init(instanceOrClass, method);
                result = this.removeImpl(key);
                try {
                    this.pool.returnObject((Object)key);
                }
                catch (Exception e) {
                    log.warn((Object)"Nonfatal error.  Could not return key to pool", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return result;
    }

    public Object remove(Serializable instanceOrClass, String method, Serializable arg1) {
        Object result = null;
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
                key.init(instanceOrClass, method, arg1);
                result = this.removeImpl(key);
                try {
                    this.pool.returnObject((Object)key);
                }
                catch (Exception e) {
                    log.warn((Object)"Nonfatal error.  Could not return key to pool", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error removing element", (Throwable)e);
            }
        }
        return result;
    }

    public Object remove(Serializable instanceOrClass, String method, Serializable arg1, Serializable arg2) {
        Object result = null;
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
                key.init(instanceOrClass, method, arg1, arg2);
                result = this.removeImpl(key);
                try {
                    this.pool.returnObject((Object)key);
                }
                catch (Exception e) {
                    log.warn((Object)"Nonfatal error: Could not return key to pool", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error removing element from cache", (Throwable)e);
            }
        }
        return result;
    }

    public Object remove(Serializable instanceOrClass, String method, Serializable arg1, Serializable arg2, Serializable arg3) {
        Object result = null;
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
                key.init(instanceOrClass, method, arg1, arg2, arg3);
                result = this.removeImpl(key);
                try {
                    this.pool.returnObject((Object)key);
                }
                catch (Exception e) {
                    log.warn((Object)"Nonfatal error.  Could not return key to pool", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error removing element from cache", (Throwable)e);
            }
        }
        return result;
    }

    public Object remove(Serializable[] keys) {
        Object result = null;
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
                key.init(keys);
                result = this.removeImpl(key);
                try {
                    this.pool.returnObject((Object)key);
                }
                catch (Exception e) {
                    log.warn((Object)"Nonfatal error: Could not return key to pool", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error removing element from cache", (Throwable)e);
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

