/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.jsp.util;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.modules.NavigationLoader;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.template.TemplateService;
import org.apache.turbine.util.RunData;

public class JspNavigation {
    private static Log log = LogFactory.getLog(JspNavigation.class);
    private final RunData data;

    public JspNavigation(RunData data) {
        this.data = data;
    }

    public void setTemplate(String template) {
        this.data.getTemplateInfo().setNavigationTemplate(template);
        String module = null;
        try {
            TemplateService templateService = (TemplateService)TurbineServices.getInstance().getService("TemplateService");
            module = templateService.getNavigationName(template);
            NavigationLoader.getInstance().exec(this.data, module);
        }
        catch (Exception e) {
            String message = "Error processing navigation template:" + template + " using module: " + module;
            log.error((Object)message, (Throwable)e);
            try {
                this.data.getResponse().getWriter().print("Error processing navigation template: " + template + " using module: " + module);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }
}

