/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.jdbc.dsfactory;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.jdbc.dsfactory.DataSourceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JndiDataSourceFactory
implements DataSourceFactory {
    private static Log log = LogFactory.getLog(JndiDataSourceFactory.class);
    private String name;
    private String path;
    private Context ctx;
    private DataSource ds = null;
    private long lastLookup = 0L;
    private long ttl = 0L;

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSource getDataSource() throws SQLException {
        long time = System.currentTimeMillis();
        if (this.ds == null || time - this.lastLookup > this.ttl) {
            try {
                Context context = this.ctx;
                synchronized (context) {
                    this.ds = (DataSource)this.ctx.lookup(this.path);
                }
                this.lastLookup = time;
            }
            catch (NamingException e) {
                throw new SQLException(e);
            }
        }
        return this.ds;
    }

    @Override
    public void initialize(JDBCDiskCacheAttributes config) throws SQLException {
        this.name = config.getConnectionPoolName();
        this.initJNDI(config);
    }

    private void initJNDI(JDBCDiskCacheAttributes config) throws SQLException {
        log.debug((Object)"Starting initJNDI");
        try {
            this.path = config.getJndiPath();
            if (log.isDebugEnabled()) {
                log.debug((Object)("JNDI path: " + this.path));
            }
            this.ttl = config.getJndiTTL();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Time between context lookups: " + this.ttl));
            }
            Hashtable env = new Hashtable();
            this.ctx = new InitialContext(env);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Created new InitialContext");
                this.debugCtx(this.ctx);
            }
        }
        catch (NamingException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void close() {
    }

    private void debugCtx(Context ctx) throws NamingException {
        log.debug((Object)"InitialContext -------------------------------");
        Hashtable<?, ?> env = ctx.getEnvironment();
        Iterator qw = env.entrySet().iterator();
        log.debug((Object)("Environment properties:" + env.size()));
        while (qw.hasNext()) {
            Map.Entry entry = qw.next();
            log.debug((Object)("    " + entry.getKey() + ": " + entry.getValue()));
        }
        log.debug((Object)"----------------------------------------------");
    }
}

