/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.runtime.CommonToken;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.Type;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.jcas.tcas.DocumentAnnotation;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.list.SimpleBooleanListExpression;
import org.apache.uima.ruta.expression.list.SimpleNumberListExpression;
import org.apache.uima.ruta.expression.list.SimpleStringListExpression;
import org.apache.uima.ruta.expression.list.SimpleTypeListExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.resource.LiteralWordListExpression;
import org.apache.uima.ruta.expression.resource.LiteralWordTableExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.expression.type.SimpleTypeExpression;
import org.apache.uima.ruta.resource.CSVTable;
import org.apache.uima.ruta.resource.MultiTreeWordList;
import org.apache.uima.ruta.resource.RutaTable;
import org.apache.uima.ruta.resource.RutaWordList;
import org.apache.uima.ruta.resource.TreeWordList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RutaEnvironment {
    private final Object annotationTypeDummy = new Object();
    private Map<String, Type> types;
    private Map<String, RutaWordList> wordLists;
    private Map<String, CSVTable> tables;
    private RutaBlock owner;
    private Map<String, String> namespaces;
    private Map<String, Object> variableValues;
    private Map<String, Class<?>> variableTypes;
    private Map<String, Class<?>> availableTypes;
    private Map<String, Class<?>> variableGenericTypes;
    private Map<String, Class<?>> availableListTypes;
    private String[] resourcePaths = null;
    private CAS cas;
    private Map<String, Object> initializedVariables;

    public RutaEnvironment(RutaBlock owner) {
        this.owner = owner;
        this.types = new HashMap<String, Type>();
        this.namespaces = new HashMap<String, String>();
        this.wordLists = new HashMap<String, RutaWordList>();
        this.tables = new HashMap<String, CSVTable>();
        this.variableValues = new HashMap<String, Object>();
        this.variableTypes = new HashMap();
        this.variableGenericTypes = new HashMap();
        this.availableTypes = new HashMap();
        this.availableTypes.put("INT", Integer.class);
        this.availableTypes.put("STRING", String.class);
        this.availableTypes.put("DOUBLE", Double.class);
        this.availableTypes.put("FLOAT", Float.class);
        this.availableTypes.put("BOOLEAN", Boolean.class);
        this.availableTypes.put("TYPE", Type.class);
        this.availableTypes.put("CONDITION", AbstractRutaCondition.class);
        this.availableTypes.put("ACTION", AbstractRutaAction.class);
        this.availableTypes.put("WORDLIST", RutaWordList.class);
        this.availableTypes.put("WORDTABLE", RutaTable.class);
        this.availableTypes.put("BOOLEANLIST", List.class);
        this.availableTypes.put("INTLIST", List.class);
        this.availableTypes.put("DOUBLELIST", List.class);
        this.availableTypes.put("FLOATLIST", List.class);
        this.availableTypes.put("STRINGLIST", List.class);
        this.availableTypes.put("TYPELIST", List.class);
        this.availableListTypes = new HashMap();
        this.availableListTypes.put("BOOLEANLIST", Boolean.class);
        this.availableListTypes.put("INTLIST", Integer.class);
        this.availableListTypes.put("DOUBLELIST", Double.class);
        this.availableListTypes.put("FLOATLIST", Float.class);
        this.availableListTypes.put("STRINGLIST", String.class);
        this.availableListTypes.put("TYPELIST", Type.class);
        this.resourcePaths = this.getResourcePaths();
        this.initializedVariables = new HashMap<String, Object>();
    }

    public void initializeTypes(CAS cas) {
        this.cas = cas;
        Type topType = null;
        try {
            topType = cas.getJCas().getCasType(TOP.type);
            if (topType != null) {
                List list = cas.getTypeSystem().getProperlySubsumedTypes(topType);
                for (Type type : list) {
                    this.addType(type);
                }
            }
            Type documentType = cas.getJCas().getCasType(DocumentAnnotation.type);
            this.addType("Document", documentType);
            Type annotationType = cas.getJCas().getCasType(Annotation.type);
            this.addType("Annotation", annotationType);
        }
        catch (CASException cASException) {
            // empty catch block
        }
    }

    public String[] getResourcePaths() {
        RutaBlock parent;
        if (this.resourcePaths == null && (parent = this.owner.getParent()) != null) {
            return parent.getEnvironment().getResourcePaths();
        }
        return this.resourcePaths;
    }

    public void setResourcePaths(String[] resourcePaths) {
        this.resourcePaths = resourcePaths;
    }

    public boolean ownsType(String match) {
        match = this.expand(match);
        return this.types.keySet().contains(match);
    }

    private String expand(String string) {
        String complete;
        if (string.indexOf(".") == -1) {
            complete = this.namespaces.get(string);
            if (complete == null) {
                complete = string;
            }
        } else {
            complete = string;
            String[] split = complete.split("\\p{Punct}");
            String name = split[split.length - 1];
            this.namespaces.put(name, complete);
        }
        return complete;
    }

    public Type getType(String match) {
        RutaBlock parent;
        String expanded = this.expand(match);
        Type type = this.types.get(expanded);
        if (type == null && (parent = this.owner.getParent()) != null) {
            type = parent.getEnvironment().getType(match);
        }
        return type;
    }

    public void addType(String string, Type type) {
        this.namespaces.put(string, type.getName());
        this.types.put(type.getName(), type);
    }

    public void addType(Type type) {
        this.addType(type.getShortName(), type);
    }

    public RutaWordList getWordList(String list) {
        RutaWordList result = this.wordLists.get(list);
        if (result == null) {
            InputStream stream;
            boolean found = false;
            if (this.resourcePaths != null) {
                for (String eachPath : this.resourcePaths) {
                    File file = new File(eachPath, list);
                    if (!file.exists()) continue;
                    found = true;
                    try {
                        if (file.getName().endsWith("mtwl")) {
                            this.wordLists.put(list, new MultiTreeWordList(file.getAbsolutePath()));
                            break;
                        }
                        this.wordLists.put(list, new TreeWordList(file.getAbsolutePath()));
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error reading word list", e);
                        found = false;
                    }
                    break;
                }
            }
            if (!found && (stream = ClassLoader.getSystemResourceAsStream(list)) != null) {
                found = true;
                try {
                    if (list.endsWith(".mtwl")) {
                        this.wordLists.put(list, new MultiTreeWordList(stream, list));
                    } else {
                        this.wordLists.put(list, new TreeWordList(stream, list));
                    }
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error reading word list from classpath", e);
                    found = false;
                }
            }
            if (!found) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Can't find " + list + "!");
            }
        }
        return this.wordLists.get(list);
    }

    public RutaTable getWordTable(String table) {
        RutaTable result = this.tables.get(table);
        if (result == null) {
            boolean found = false;
            for (String eachPath : this.resourcePaths) {
                File file = new File(eachPath, table);
                if (!file.exists()) continue;
                found = true;
                this.tables.put(table, new CSVTable(file.getAbsolutePath()));
                break;
            }
            if (!found) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Can't find " + table + "!");
            }
        }
        return this.tables.get(table);
    }

    public void addVariable(String name, Class<?> type, Class<?> generic) {
        this.variableTypes.put(name, type);
        if (generic != null) {
            this.variableGenericTypes.put(name, generic);
        }
        this.variableValues.put(name, this.getInitialValue(name, type));
    }

    private Object getInitialValue(String name, Class<?> type) {
        Object init = this.initializedVariables.get(name);
        if (init != null) {
            if (init instanceof List) {
                ArrayList list = new ArrayList();
                list.addAll((Collection)init);
                return list;
            }
            return init;
        }
        if (Integer.class.equals(type)) {
            return 0;
        }
        if (Double.class.equals(type)) {
            return 0.0;
        }
        if (Float.class.equals(type)) {
            return Float.valueOf(0.0f);
        }
        if (String.class.equals(type)) {
            return "";
        }
        if (Boolean.class.equals(type)) {
            return false;
        }
        if (Type.class.equals(type)) {
            if (this.cas == null) {
                return this.annotationTypeDummy;
            }
            return this.cas.getAnnotationType();
        }
        if (List.class.equals(type)) {
            return new ArrayList();
        }
        return null;
    }

    public void addVariable(String name, String type) {
        this.addVariable(name, this.availableTypes.get(type), this.availableListTypes.get(type));
    }

    public boolean ownsVariable(String name) {
        return this.variableTypes.containsKey(name);
    }

    public boolean ownsVariableOfType(String name, String type) {
        Class<?> varclass = this.variableTypes.get(name);
        Class<?> aclass = this.availableTypes.get(type);
        boolean list = true;
        if (aclass.equals(List.class)) {
            Class<?> vt = this.variableGenericTypes.get(name);
            Class<?> at = this.availableListTypes.get(type);
            list = vt != null && vt.equals(at);
        }
        return list && varclass != null && varclass.equals(aclass);
    }

    public boolean isVariable(String name) {
        return this.ownsVariable(name) || this.owner.getParent().getEnvironment().isVariable(name);
    }

    public boolean isVariableOfType(String name, String type) {
        return this.ownsVariableOfType(name, type) || this.owner.getParent() != null && this.owner.getParent().getEnvironment().isVariableOfType(name, type);
    }

    public Class<?> getVariableType(String name) {
        Class<?> result = this.variableTypes.get(name);
        if (result != null) {
            return result;
        }
        if (this.owner.getParent() != null) {
            return this.owner.getParent().getEnvironment().getVariableType(name);
        }
        return null;
    }

    public Class<?> getVariableGenericType(String name) {
        Class<?> result = this.variableGenericTypes.get(name);
        if (result != null) {
            return result;
        }
        if (this.owner.getParent() != null) {
            return this.owner.getParent().getEnvironment().getVariableGenericType(name);
        }
        return null;
    }

    public <T> T getVariableValue(String name, Class<T> type) {
        boolean containsKey = this.variableValues.containsKey(name);
        Object result = this.variableValues.get(name);
        if (result instanceof String && type.equals(Type.class)) {
            result = this.types.get(result);
        }
        if (containsKey && result == null) {
            return type.cast(this.getInitialValue(name, type));
        }
        if (result == this.annotationTypeDummy) {
            return type.cast(this.cas.getAnnotationType());
        }
        if (result != null) {
            return type.cast(result);
        }
        if (this.owner.getParent() != null) {
            return this.owner.getParent().getEnvironment().getVariableValue(name, type);
        }
        return null;
    }

    public Object getVariableValue(String name) {
        return this.getVariableValue(name, Object.class);
    }

    public Object getLiteralValue(String var, Object value) {
        if (this.ownsVariable(var)) {
            String typeName;
            Object list;
            Class<?> clazz = this.variableTypes.get(var);
            if (value instanceof NumberExpression) {
                NumberExpression ne = (NumberExpression)value;
                if (clazz.equals(Integer.class)) {
                    return ne.getIntegerValue(this.owner);
                }
                if (clazz.equals(Double.class)) {
                    return ne.getDoubleValue(this.owner);
                }
                if (clazz.equals(Float.class)) {
                    return Float.valueOf(ne.getFloatValue(this.owner));
                }
                if (clazz.equals(String.class)) {
                    return ne.getStringValue(this.owner);
                }
            } else {
                if (clazz.equals(String.class) && value instanceof StringExpression) {
                    StringExpression se = (StringExpression)value;
                    return se.getStringValue(this.owner);
                }
                if (clazz.equals(Boolean.class) && value instanceof BooleanExpression) {
                    BooleanExpression be = (BooleanExpression)value;
                    return be.getBooleanValue(this.owner);
                }
            }
            if (clazz.equals(RutaWordList.class) && value instanceof LiteralWordListExpression) {
                LiteralWordListExpression lle = (LiteralWordListExpression)value;
                String path = lle.getText();
                RutaWordList wordList = this.getWordList(path);
                return wordList;
            }
            if (clazz.equals(RutaWordList.class)) {
                list = this.getWordList((String)value);
                return list;
            }
            if (clazz.equals(RutaTable.class) && value instanceof LiteralWordTableExpression) {
                LiteralWordTableExpression lte = (LiteralWordTableExpression)value;
                String path = lte.getText();
                RutaTable table = this.getWordTable(path);
                return table;
            }
            if (clazz.equals(RutaTable.class)) {
                RutaTable table = this.getWordTable((String)value);
                return table;
            }
            if (clazz.equals(List.class) && value instanceof ListExpression) {
                list = this.getList((ListExpression)value);
                return list;
            }
            if (clazz.equals(Type.class) && value instanceof CommonToken) {
                typeName = ((CommonToken)value).getText();
                return typeName;
            }
            if (clazz.equals(Type.class) && value instanceof SimpleTypeExpression) {
                typeName = ((SimpleTypeExpression)value).getTypeString();
                return typeName;
            }
            return null;
        }
        return this.owner.getParent().getEnvironment().getLiteralValue(var, value);
    }

    public void setInitialVariableValue(String var, Object value) {
        if (this.ownsVariable(var)) {
            if (value instanceof List) {
                ArrayList initValue = new ArrayList();
                initValue.addAll((Collection)value);
                this.initializedVariables.put(var, initValue);
            } else {
                this.initializedVariables.put(var, value);
            }
            this.setVariableValue(var, value);
        } else if (this.owner.getParent() != null) {
            this.owner.getParent().getEnvironment().setInitialVariableValue(var, value);
        }
    }

    public void setVariableValue(String var, Object value) {
        if (this.ownsVariable(var)) {
            Class<?> clazz = this.variableTypes.get(var);
            if (value == null) {
                value = this.getInitialValue(var, clazz);
            }
            this.variableValues.put(var, value);
        } else if (this.owner.getParent() != null) {
            this.owner.getParent().getEnvironment().setVariableValue(var, value);
        }
    }

    private List getList(ListExpression value) {
        if (value instanceof SimpleBooleanListExpression) {
            SimpleBooleanListExpression e = (SimpleBooleanListExpression)value;
            return e.getList();
        }
        if (value instanceof SimpleNumberListExpression) {
            SimpleNumberListExpression e = (SimpleNumberListExpression)value;
            return e.getList();
        }
        if (value instanceof SimpleStringListExpression) {
            SimpleStringListExpression e = (SimpleStringListExpression)value;
            return e.getList();
        }
        if (value instanceof SimpleTypeListExpression) {
            SimpleTypeListExpression e = (SimpleTypeListExpression)value;
            return e.getList();
        }
        return null;
    }

    public void reset(CAS cas) {
        this.cas = cas;
        Set<Map.Entry<String, Object>> entrySet = this.variableValues.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String key = entry.getKey();
            Object initialValue = this.getInitialValue(key, this.variableTypes.get(key));
            if (initialValue == null) continue;
            entry.setValue(initialValue);
        }
    }
}

