/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.RutaElement;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.rule.ComposedRuleElement;
import org.apache.uima.ruta.rule.ComposedRuleElementMatch;
import org.apache.uima.ruta.rule.RuleApply;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementContainer;
import org.apache.uima.ruta.rule.RuleElementMatch;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.rule.RutaRule;
import org.apache.uima.ruta.rule.quantifier.NormalQuantifier;
import org.apache.uima.ruta.rule.quantifier.RuleElementQuantifier;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRuleElement
extends RutaElement
implements RuleElement {
    protected RuleElementQuantifier quantifier;
    protected List<AbstractRutaCondition> conditions;
    protected List<AbstractRutaAction> actions;
    private RuleElementContainer container;
    protected RutaBlock parent;
    protected final InferenceCrowd emptyCrowd = new InferenceCrowd(Collections.EMPTY_LIST);

    public AbstractRuleElement(RuleElementQuantifier quantifier, List<AbstractRutaCondition> conditions, List<AbstractRutaAction> actions, RuleElementContainer container, RutaBlock parent) {
        this.quantifier = quantifier;
        this.conditions = conditions;
        this.actions = actions;
        this.container = container;
        this.parent = parent;
        if (this.conditions == null) {
            this.conditions = new ArrayList<AbstractRutaCondition>();
        }
        if (this.actions == null) {
            this.actions = new ArrayList<AbstractRutaAction>();
        }
        if (this.quantifier == null) {
            this.quantifier = new NormalQuantifier();
        }
    }

    protected void doneMatching(RuleMatch ruleMatch, RuleApply ruleApply, RutaStream stream, InferenceCrowd crowd) {
        if (!ruleMatch.isApplied()) {
            ruleApply.add(ruleMatch);
            if (ruleMatch.matchedCompletely()) {
                ((RutaRule)ruleMatch.getRule()).getRoot().applyRuleElements(ruleMatch, stream, crowd);
            }
            ruleMatch.setApplied(true);
        }
    }

    @Override
    public void apply(RuleMatch ruleMatch, RutaStream stream, InferenceCrowd crowd) {
        for (AbstractRutaAction action : this.actions) {
            crowd.beginVisit(action, null);
            action.execute(ruleMatch, this, stream, crowd);
            crowd.endVisit(action, null);
        }
    }

    protected List<RuleElementMatch> getMatch(RuleMatch ruleMatch, ComposedRuleElementMatch containerMatch) {
        List<RuleElementMatch> matchInfo = containerMatch != null ? containerMatch.getInnerMatches().get(this) : ruleMatch.getMatchInfo(this).get(0);
        return matchInfo;
    }

    @Override
    public List<RuleElementMatch> evaluateMatches(List<RuleElementMatch> matches, RutaBlock parent) {
        return this.quantifier.evaluateMatches(matches, parent, this.emptyCrowd);
    }

    @Override
    public List<Integer> getSelfIndexList() {
        ArrayList<Integer> result = new ArrayList<Integer>(1);
        if (this.getContainer() == null) {
            return null;
        }
        int indexOf = this.getContainer().getRuleElements().indexOf(this);
        result.add(indexOf + 1);
        return result;
    }

    @Override
    public boolean hasAncestor(boolean after) {
        RuleElementContainer c = this.getContainer();
        if (c == null) {
            return false;
        }
        RuleElement nextElement = c.getNextElement(after, this);
        if (nextElement != null) {
            return true;
        }
        if (c instanceof ComposedRuleElement) {
            return ((ComposedRuleElement)c).hasAncestor(after);
        }
        return false;
    }

    @Override
    public RuleElementQuantifier getQuantifier() {
        return this.quantifier;
    }

    @Override
    public RutaBlock getParent() {
        return this.parent;
    }

    @Override
    public List<AbstractRutaCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<AbstractRutaCondition> conditions) {
        this.conditions = conditions;
    }

    @Override
    public List<AbstractRutaAction> getActions() {
        return this.actions;
    }

    public void setActions(List<AbstractRutaAction> actions) {
        this.actions = actions;
    }

    public void setQuantifier(RuleElementQuantifier quantifier) {
        this.quantifier = quantifier;
    }

    @Override
    public RutaRule getRule() {
        return this.container.getRule();
    }

    @Override
    public RuleElementContainer getContainer() {
        return this.container;
    }
}

