/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.apache.uima.UIMAException;
import org.apache.uima.pear.tools.InstallationController;
import org.apache.uima.pear.tools.InstallationDescriptor;
import org.apache.uima.pear.tools.InstallationDescriptorHandler;
import org.apache.uima.pear.tools.InstallationProcessor;
import org.apache.uima.pear.tools.InstallationTester;
import org.apache.uima.pear.tools.PackageBrowser;
import org.apache.uima.pear.util.FileUtil;
import org.apache.uima.resource.ResourceInitializationException;

public class LocalInstallationAgent {
    protected static final String BACKUP_FILE_SUFFIX = ".$";
    protected static final String MAIN_ROOT = "$main_root";
    protected static final String COMP_ROOT_PREFIX = "$";
    protected static final String COMP_ROOT_SUFFIX = "$root";
    private String _osName;
    private String _uimaHomePath;
    private File _mainRootDir;
    private Properties _packageConfig = new Properties();
    private InstallationDescriptor _insdObject;
    private File[] _localizedFiles;

    public static boolean checkPackageConfig(Properties packageConfig, InstallationDescriptor insdObject) {
        boolean isOk = false;
        if (packageConfig.getProperty(MAIN_ROOT) != null) {
            Hashtable<String, InstallationDescriptor.ComponentInfo> dlgTable = insdObject.getDelegateComponents();
            Iterator<String> idList = dlgTable.keySet().iterator();
            int counter = 0;
            while (idList.hasNext()) {
                String id = idList.next();
                String idRoot = COMP_ROOT_PREFIX + id + COMP_ROOT_SUFFIX;
                if (packageConfig.getProperty(idRoot) == null) continue;
                ++counter;
            }
            if (counter == dlgTable.size()) {
                isOk = true;
            }
        }
        return isOk;
    }

    public static void localizeComponentFile(File file, InstallationDescriptor insdObject, Properties packageConfig) throws IOException {
        String mainRootPath = packageConfig.getProperty(MAIN_ROOT);
        if (mainRootPath != null) {
            String replacement = FileUtil.localPathToFileUrl(mainRootPath);
            FileUtil.replaceStringInFile(file, "\\$main_root_url", replacement);
            replacement = mainRootPath;
            FileUtil.replaceStringInFile(file, "\\$main_root", replacement);
        }
        for (String id : insdObject.getDelegateComponents().keySet()) {
            String idRoot = COMP_ROOT_PREFIX + id + COMP_ROOT_SUFFIX;
            String compRootPath = packageConfig.getProperty(idRoot);
            String regExp = InstallationProcessor.componentIdRootRegExp(id, "\\$root_rel");
            String replacement = FileUtil.computeRelativePath(file.getParentFile(), new File(compRootPath));
            FileUtil.replaceStringInFile(file, regExp, replacement);
            regExp = InstallationProcessor.componentIdRootRegExp(id, "\\$root_url");
            replacement = FileUtil.localPathToFileUrl(compRootPath);
            FileUtil.replaceStringInFile(file, regExp, replacement);
            regExp = InstallationProcessor.componentIdRootRegExp(id, "\\$root");
            replacement = compRootPath;
            FileUtil.replaceStringInFile(file, regExp, replacement);
        }
    }

    public static void localizeInstallationDescriptor(InstallationDescriptor insdObject, Properties packageConfig) {
        String mainRootPath = packageConfig.getProperty(MAIN_ROOT);
        insdObject.setMainComponentRoot(mainRootPath);
        for (String id : insdObject.getDelegateComponents().keySet()) {
            String idRoot = COMP_ROOT_PREFIX + id + COMP_ROOT_SUFFIX;
            String compRootPath = packageConfig.getProperty(idRoot);
            insdObject.setDelegateComponentRoot(id, compRootPath);
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("usage: LocalInstallationAgent main_component_root_dir");
            return;
        }
        LocalInstallationAgent installer = new LocalInstallationAgent(args[0]);
        try {
            if (installer.localizeComponent()) {
                System.out.println("[LocalInstallationAgent]: localization completed successfully");
                if (installer.verifyLocalizedComponent()) {
                    System.out.println("[LocalInstallationAgent]: verification completed successfully");
                } else {
                    System.out.println("[LocalInstallationAgent]: verification failed");
                }
            } else {
                System.out.println("[LocalInstallationAgent]: localization failed");
            }
        }
        catch (Throwable err) {
            System.err.println("Error in LocalInstallationAgent: " + err);
            err.printStackTrace(System.err);
        }
        finally {
            try {
                if (!installer.undoComponentLocalization()) {
                    throw new RuntimeException("failed to undo changes");
                }
            }
            catch (Throwable e) {
                System.err.println("Error trying to undo component localization: " + e);
                System.out.println("> Please, make sure that all *.$ files in conf and desc dirs\n> are renamed back to their original names");
            }
        }
    }

    public LocalInstallationAgent(String mainComponentRootPath) {
        this._uimaHomePath = System.getProperty("UIMA_HOME");
        if (this._uimaHomePath != null) {
            this._uimaHomePath = this._uimaHomePath.replace('\\', '/');
        }
        this._osName = System.getProperty("os.name");
        System.out.println("[LocalInstallationAgent]: OS - " + this._osName);
        this._mainRootDir = new File(mainComponentRootPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean localizeComponent() throws IOException {
        boolean completed = false;
        InstallationDescriptorHandler insdHandler = new InstallationDescriptorHandler();
        File insdFile = new File(this._mainRootDir, "metadata/install.xml");
        try {
            insdHandler.parse(insdFile);
        }
        catch (IOException exc) {
            throw exc;
        }
        catch (Exception err) {
            throw new RuntimeException(err);
        }
        this._insdObject = insdHandler.getInstallationDescriptor();
        if (this._insdObject == null) {
            throw new RuntimeException("failed to load installation descriptor");
        }
        System.out.println("[LocalInstallationAgent]: loaded installation descriptor");
        File packageConfigFile = new File(this._mainRootDir, "metadata/PEAR.properties");
        FileInputStream iStream = null;
        try {
            iStream = new FileInputStream(packageConfigFile);
            this._packageConfig.load(iStream);
            ((InputStream)iStream).close();
            System.out.println("[LocalInstallationAgent]: loaded PEAR configuration");
        }
        finally {
            if (iStream != null) {
                try {
                    ((InputStream)iStream).close();
                }
                catch (Exception exception) {}
            }
        }
        if (LocalInstallationAgent.checkPackageConfig(this._packageConfig, this._insdObject)) {
            this._localizedFiles = this.localizeComponentFiles();
            LocalInstallationAgent.localizeInstallationDescriptor(this._insdObject, this._packageConfig);
            completed = true;
        } else {
            System.err.println("[LocalInstallationAgent]: PEAR properties do not comply with installation descriptor");
        }
        return completed;
    }

    protected synchronized File[] localizeComponentFiles() throws IOException {
        File bakFile;
        String bakFileName;
        File confDir = new File(this._mainRootDir, "conf");
        Collection<File> confDirFiles = FileUtil.createFileList(confDir, false);
        File descDir = new File(this._mainRootDir, "desc");
        Collection<File> descDirFiles = FileUtil.createFileList(descDir, false);
        File[] fileList = new File[confDirFiles.size() + descDirFiles.size()];
        int fileCounter = 0;
        for (File orgFile : confDirFiles) {
            bakFileName = orgFile.getName().concat(BACKUP_FILE_SUFFIX);
            bakFile = new File(orgFile.getParent(), bakFileName);
            if (!FileUtil.copyFile(orgFile, bakFile)) continue;
            LocalInstallationAgent.localizeComponentFile(orgFile, this._insdObject, this._packageConfig);
            fileList[fileCounter++] = orgFile;
        }
        for (File orgFile : descDirFiles) {
            bakFileName = orgFile.getName().concat(BACKUP_FILE_SUFFIX);
            bakFile = new File(orgFile.getParent(), bakFileName);
            if (!FileUtil.copyFile(orgFile, bakFile)) continue;
            LocalInstallationAgent.localizeComponentFile(orgFile, this._insdObject, this._packageConfig);
            fileList[fileCounter++] = orgFile;
        }
        return fileList;
    }

    public synchronized boolean undoComponentLocalization() throws IOException {
        boolean completed = false;
        int counter = 0;
        for (int i = 0; i < this._localizedFiles.length; ++i) {
            File orgFile = this._localizedFiles[i];
            String bakFileName = orgFile.getName().concat(BACKUP_FILE_SUFFIX);
            File bakFile = new File(orgFile.getParent(), bakFileName);
            if (FileUtil.copyFile(bakFile, orgFile)) {
                bakFile.delete();
                ++counter;
                continue;
            }
            System.err.println("[LocalInstallationAgent]: failed to undo changes for the file " + orgFile.getAbsolutePath());
        }
        completed = counter == this._localizedFiles.length;
        return completed;
    }

    public synchronized boolean verifyLocalizedComponent() throws IOException, ResourceInitializationException, UIMAException {
        if (this._insdObject == null) {
            throw new RuntimeException("null installation descriptor");
        }
        if (this._mainRootDir == null) {
            throw new RuntimeException("main root directory not specified");
        }
        String mainDescPath = this._insdObject.getMainComponentDesc();
        if (mainDescPath == null) {
            throw new RuntimeException("main descriptor path not specified");
        }
        InstallationTester installTester = new InstallationTester(new PackageBrowser(new File(this._mainRootDir.getAbsolutePath())));
        InstallationController.TestStatus status = installTester.doTest();
        if (status.getRetCode() == 0) {
            return true;
        }
        System.err.println("[LocalInstallationAgent]: localization test failed =>");
        System.out.println("> Error message: " + status.getMessage());
        return false;
    }

    public synchronized void setUimaHomePath(String uimaHomePath) {
        this._uimaHomePath = uimaHomePath.replace('\\', '/');
    }
}

