/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.jmx.monitor;

import java.text.DecimalFormat;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.jmx.monitor.JmxMonitorListener;
import org.apache.uima.aae.jmx.monitor.ServiceMetrics;
import org.apache.uima.util.Level;

public class SingleLineUimaJmxMonitorListener
implements JmxMonitorListener {
    private static final Class CLASS_NAME = JmxMonitorListener.class;
    private boolean firsttime = true;
    private double lastSampleTime = 0.0;
    private double period;

    @Override
    public void onNewMetrics(long sampleTime, ServiceMetrics[] metrics) {
        String items;
        if (this.firsttime) {
            this.firsttime = false;
            items = "\tTimestamp";
            for (ServiceMetrics serviceMetrics : metrics) {
                String srvName = serviceMetrics.getServiceName();
                srvName = srvName.substring(0, srvName.indexOf("_Service Performance"));
                if (serviceMetrics.isTopLevelService()) {
                    srvName = "(S)" + srvName;
                } else if (serviceMetrics.isServiceRemote()) {
                    srvName = "(R)" + srvName;
                }
                items = items + "\t" + srvName + "-CPU";
                items = items + "\t" + srvName + "-Idle";
                items = items + "\t" + srvName + "-CASes";
                items = items + "\t" + srvName + "-InQ";
                if (!serviceMetrics.isTopLevelService()) {
                    items = items + "\t" + srvName + "-RepQ";
                }
                if (serviceMetrics.isTopLevelService() || serviceMetrics.isCasMultiplier() && serviceMetrics.isServiceRemote()) {
                    items = items + "\t" + srvName + "-CPW";
                }
                if (serviceMetrics.isCasMultiplier() && !serviceMetrics.isServiceRemote()) {
                    items = items + "\t" + srvName + "-CmFreeCP";
                }
                if (!serviceMetrics.isTopLevelService()) continue;
                items = items + "\t" + srvName + "-SvcFreeCP";
            }
            UIMAFramework.getLogger((Class)CLASS_NAME).log(Level.INFO, items);
        }
        items = "\t";
        items = items + this.format((double)sampleTime / 1.0E9);
        this.period = ((double)sampleTime - this.lastSampleTime) / 1000000.0;
        this.lastSampleTime = sampleTime;
        for (ServiceMetrics serviceMetrics : metrics) {
            items = items + "\t" + this.format(serviceMetrics.getAnalysisTime() / this.period);
            items = items + "\t" + this.format(serviceMetrics.getIdleTime() / this.period);
            items = items + "\t" + serviceMetrics.getProcessCount();
            items = items + "\t" + serviceMetrics.getInputQueueDepth();
            if (!serviceMetrics.isTopLevelService()) {
                items = items + "\t" + serviceMetrics.getReplyQueueDepth();
            }
            if (serviceMetrics.isTopLevelService()) {
                items = items + "\t" + this.format(serviceMetrics.getCasPoolWaitTime() / this.period);
            } else if (serviceMetrics.isCasMultiplier()) {
                items = serviceMetrics.isServiceRemote() ? items + "\t" + this.format(serviceMetrics.getShadowCasPoolWaitTime() / this.period) : items + "\t" + serviceMetrics.getCmFreeCasInstanceCount();
            }
            if (!serviceMetrics.isTopLevelService()) continue;
            items = items + "\t" + serviceMetrics.getSvcFreeCasInstanceCount();
        }
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).log(Level.INFO, items);
        }
    }

    private String format(double value) {
        DecimalFormat formatter = new DecimalFormat();
        return formatter.format(value);
    }
}

