/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Int64Value;

public class Last
extends SystemFunction {
    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        if (itemType == null) {
            StaticError staticError = new StaticError("The context for last() is undefined");
            staticError.setErrorCode("XPDY0002");
            staticError.setIsTypeError(true);
            staticError.setLocator(this);
            throw staticError;
        }
        return super.typeCheck(staticContext, itemType);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return Int64Value.makeIntegerValue(xPathContext.getLast());
    }

    public int getIntrinsicDependencies() {
        return 8;
    }
}

