/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.caseditor.editor.ICasEditor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.texteditor.IElementStateListener;

public abstract class CasDocumentProvider {
    public static final int TYPE_SYSTEM_NOT_AVAILABLE_STATUS_CODE = 12;
    private Set<IElementStateListener> elementStateListeners = new HashSet<IElementStateListener>();
    protected Map<Object, IStatus> elementErrorStatus = new HashMap<Object, IStatus>();

    protected ElementInfo createElementInfo(Object element) {
        return new ElementInfo(element);
    }

    protected void disposeElementInfo(Object element, ElementInfo info) {
    }

    protected abstract ICasDocument createDocument(Object var1) throws CoreException;

    protected abstract void doSaveDocument(IProgressMonitor var1, Object var2, ICasDocument var3, boolean var4) throws CoreException;

    public IStatus getStatus(Object element) {
        return this.elementErrorStatus.get(element);
    }

    public abstract IPreferenceStore getTypeSystemPreferenceStore(Object var1);

    public abstract void saveTypeSystemPreferenceStore(Object var1);

    public abstract IPreferenceStore getSessionPreferenceStore(Object var1);

    public abstract Composite createTypeSystemSelectorForm(ICasEditor var1, Composite var2, IStatus var3);

    public void addElementStateListener(IElementStateListener listener) {
        this.elementStateListeners.add(listener);
    }

    public void removeElementStateListener(IElementStateListener listener) {
        this.elementStateListeners.remove(listener);
    }

    protected void fireElementDeleted(Object element) {
        for (IElementStateListener listener : this.elementStateListeners) {
            listener.elementDeleted(element);
        }
    }

    protected void fireElementChanged(Object element) {
        for (IElementStateListener listener : this.elementStateListeners) {
            listener.elementContentReplaced(element);
        }
    }

    protected void fireElementDirtyStateChanged(Object element, boolean isDirty) {
        for (IElementStateListener listener : this.elementStateListeners) {
            listener.elementDirtyStateChanged(element, isDirty);
        }
    }

    protected static class ElementInfo {
        public int referenceCount;
        public final Object element;

        protected ElementInfo(Object element) {
            this.element = element;
        }
    }
}

