/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples;

import java.io.File;
import java.io.PrintStream;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.FloatArrayFS;
import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.XMLInputSource;

public class PrintAnnotations {
    public static void printAnnotations(CAS aCAS, PrintStream aOut) {
        aCAS.select(Annotation.class).forEach(fs -> PrintAnnotations.printFS((FeatureStructure)fs, aCAS, 0, aOut));
    }

    public static void printAnnotations(CAS aCAS, Type aAnnotType, PrintStream aOut) {
        FSIterator iter = aCAS.getAnnotationIndex(aAnnotType).iterator();
        while (iter.isValid()) {
            FeatureStructure fs = iter.get();
            PrintAnnotations.printFS(fs, aCAS, 0, aOut);
            iter.moveToNext();
        }
    }

    public static void printFS(FeatureStructure aFS, CAS aCAS, int aNestingLevel, PrintStream aOut) {
        Type stringType = aCAS.getTypeSystem().getType("uima.cas.String");
        PrintAnnotations.printTabs(aNestingLevel, aOut);
        aOut.println(aFS.getType().getName());
        if (aFS instanceof AnnotationFS) {
            AnnotationFS annot = (AnnotationFS)aFS;
            String coveredText = annot.getCoveredText();
            PrintAnnotations.printTabs(aNestingLevel + 1, aOut);
            aOut.print("\"");
            if (coveredText.length() <= 64) {
                aOut.print(coveredText);
            } else {
                aOut.println(coveredText.substring(0, 64) + "...");
            }
            aOut.println("\"");
        }
        List aFeatures = aFS.getType().getFeatures();
        for (Feature feat : aFeatures) {
            int i;
            Object[] vals;
            StringArrayFS arrayFS;
            PrintAnnotations.printTabs(aNestingLevel + 1, aOut);
            aOut.print(feat.getShortName());
            aOut.print(" = ");
            String rangeTypeName = feat.getRange().getName();
            if (aCAS.getTypeSystem().subsumes(stringType, feat.getRange())) {
                Object str = aFS.getStringValue(feat);
                if (str == null) {
                    aOut.println("null");
                    continue;
                }
                aOut.print("\"");
                if (((String)str).length() > 64) {
                    str = ((String)str).substring(0, 64) + "...";
                }
                aOut.print((String)str);
                aOut.println("\"");
                continue;
            }
            if ("uima.cas.Integer".equals(rangeTypeName)) {
                aOut.println(aFS.getIntValue(feat));
                continue;
            }
            if ("uima.cas.Float".equals(rangeTypeName)) {
                aOut.println(aFS.getFloatValue(feat));
                continue;
            }
            if ("uima.cas.StringArray".equals(rangeTypeName)) {
                arrayFS = (StringArrayFS)aFS.getFeatureValue(feat);
                if (arrayFS == null) {
                    aOut.println("null");
                    continue;
                }
                vals = arrayFS.toArray();
                aOut.print("[");
                for (i = 0; i < vals.length - 1; ++i) {
                    aOut.print(vals[i]);
                    aOut.print(',');
                }
                if (vals.length > 0) {
                    aOut.print(vals[vals.length - 1]);
                }
                aOut.println("]\"");
                continue;
            }
            if ("uima.cas.IntegerArray".equals(rangeTypeName)) {
                arrayFS = (IntArrayFS)aFS.getFeatureValue(feat);
                if (arrayFS == null) {
                    aOut.println("null");
                    continue;
                }
                vals = arrayFS.toArray();
                aOut.print("[");
                for (i = 0; i < vals.length - 1; ++i) {
                    aOut.print((int)vals[i]);
                    aOut.print(',');
                }
                if (vals.length > 0) {
                    aOut.print((int)vals[vals.length - 1]);
                }
                aOut.println("]\"");
                continue;
            }
            if ("uima.cas.FloatArray".equals(rangeTypeName)) {
                arrayFS = (FloatArrayFS)aFS.getFeatureValue(feat);
                if (arrayFS == null) {
                    aOut.println("null");
                    continue;
                }
                vals = arrayFS.toArray();
                aOut.print("[");
                for (i = 0; i < vals.length - 1; ++i) {
                    aOut.print((float)vals[i]);
                    aOut.print(',');
                }
                if (vals.length > 0) {
                    aOut.print((float)vals[vals.length - 1]);
                }
                aOut.println("]\"");
                continue;
            }
            FeatureStructure val = aFS.getFeatureValue(feat);
            if (val == null) {
                aOut.println("null");
                continue;
            }
            PrintAnnotations.printFS(val, aCAS, aNestingLevel + 1, aOut);
        }
    }

    private static void printTabs(int aNumTabs, PrintStream aOut) {
        for (int i = 0; i < aNumTabs; ++i) {
            aOut.print("\t");
        }
    }

    public static void main(String[] args) {
        try {
            File taeDescriptor = new File(args[0]);
            File inputFile = new File(args[1]);
            XMLInputSource in = new XMLInputSource(taeDescriptor);
            ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
            AnalysisEngine ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)specifier);
            CAS cas = ae.newCAS();
            ResultSpecification resultSpec = null;
            if (args.length > 2) {
                resultSpec = ae.createResultSpecification(cas.getTypeSystem());
                for (int i = 2; i < args.length; ++i) {
                    if (args[i].indexOf(58) > 0) {
                        resultSpec.addResultFeature(args[i]);
                        continue;
                    }
                    resultSpec.addResultType(args[i], false);
                }
            }
            String document = FileUtils.file2String((File)inputFile);
            cas.setDocumentText(document);
            ae.process(cas, resultSpec);
            Type annotationType = cas.getTypeSystem().getType("uima.tcas.Annotation");
            PrintAnnotations.printAnnotations(cas, annotationType, System.out);
            ae.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

