/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaSerializable;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIndexRepository;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.ArrayElement;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSData;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.OutOfTypeSystemData;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.impl.XCASParsingException;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.internal.util.Pair;
import org.apache.uima.internal.util.StringUtils;
import org.apache.uima.internal.util.XMLUtils;
import org.apache.uima.internal.util.rb_trees.RedBlackTree;
import org.apache.uima.jcas.cas.CommonPrimitiveArray;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.Sofa;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.util.impl.Constants;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XCASDeserializer {
    private final TypeSystemImpl ts;
    private String docTypeName = "uima.tcas.Document";

    public XCASDeserializer(TypeSystem ts, UimaContext uimaContext) {
        this.ts = (TypeSystemImpl)ts;
    }

    public XCASDeserializer(TypeSystem ts) {
        this(ts, null);
    }

    public DefaultHandler getXCASHandler(CAS cas) {
        return this.getXCASHandler(cas, null);
    }

    public DefaultHandler getXCASHandler(CAS cas, OutOfTypeSystemData outOfTypeSystemData) {
        return new XCASDeserializerHandler((CASImpl)cas, outOfTypeSystemData);
    }

    public String getDocumentTypeName() {
        return this.docTypeName;
    }

    public void setDocumentTypeName(String aDocTypeName) {
        this.docTypeName = aDocTypeName;
    }

    public static void deserialize(InputStream aStream, CAS aCAS) throws SAXException, IOException {
        XCASDeserializer.deserialize(aStream, aCAS, false);
    }

    public static void deserialize(Reader aReader, CAS aCAS, boolean aLenient) throws SAXException, IOException {
        XCASDeserializer.deserialize(new InputSource(aReader), aCAS, aLenient);
    }

    public static void deserialize(InputStream aStream, CAS aCAS, boolean aLenient) throws SAXException, IOException {
        XCASDeserializer.deserialize(new InputSource(aStream), aCAS, aLenient);
    }

    public static void deserialize(InputSource aSource, CAS aCAS, boolean aLenient) throws SAXException, IOException {
        XMLReader xmlReader = XMLUtils.createXMLReader();
        XCASDeserializer deser = new XCASDeserializer(aCAS.getTypeSystem());
        DefaultHandler handler = aLenient ? deser.getXCASHandler(aCAS, new OutOfTypeSystemData()) : deser.getXCASHandler(aCAS);
        xmlReader.setContentHandler(handler);
        xmlReader.parse(aSource);
        CASImpl casImpl = (CASImpl)aCAS.getLowLevelCAS();
        if (casImpl.is_ll_enableV2IdRefs()) {
            TOP highest_fs = ((XCASDeserializerHandler)handler).highestIdFs;
            casImpl.setLastUsedFsId(highest_fs._id);
            casImpl.setLastFsV2Size(highest_fs._getTypeImpl().getFsSpaceReq(highest_fs));
        }
    }

    private class XCASDeserializerHandler
    extends DefaultHandler {
        private static final int DOC_STATE = 0;
        private static final int FS_STATE = 1;
        private static final int FEAT_STATE = 2;
        private static final int CONTENT_STATE = 3;
        private static final int FEAT_CONTENT_STATE = 4;
        private static final int ARRAY_ELE_CONTENT_STATE = 5;
        private static final int ARRAY_ELE_STATE = 6;
        private static final int DOC_TEXT_STATE = 7;
        private static final int OOTS_FEAT_STATE = 8;
        private static final int OOTS_CONTENT_STATE = 9;
        private static final String DEFAULT_CONTENT_FEATURE = "value";
        private static final String reservedAttrPrefix = "_";
        private static final String unknownXMLSource = "<unknown>";
        private static final int sofaTypeCode = 33;
        private Locator locator;
        private final CASImpl cas;
        private final RedBlackTree<FSInfo> fsTree;
        private final List<FSInfo> idLess;
        private final List<Runnable> fixupToDos = new ArrayList<Runnable>();
        private final List<Runnable> uimaSerializableFixups = new ArrayList<Runnable>();
        private int state;
        private StringBuffer buffer;
        private TOP currentFs;
        private String currentContentFeat = "value";
        private int arrayPos;
        private OutOfTypeSystemData outOfTypeSystemData;
        private FSData currentOotsFs;
        private final List<FSIndexRepository> indexRepositories;
        private final List<CAS> views;
        private final IntVector sofaRefMap;
        private final IntVector indexMap;
        private int nextIndex;
        private TOP highestIdFs = null;
        private int fsId;

        private XCASDeserializerHandler(CASImpl aCAS, OutOfTypeSystemData ootsData) {
            this.cas = aCAS.getBaseCAS();
            this.cas.resetNoQuestions();
            this.fsTree = new RedBlackTree();
            this.idLess = new ArrayList<FSInfo>();
            this.buffer = new StringBuffer();
            this.outOfTypeSystemData = ootsData;
            this.indexRepositories = new ArrayList<FSIndexRepository>();
            this.views = new ArrayList<CAS>();
            this.indexRepositories.add(this.cas.getBaseIndexRepository());
            this.indexRepositories.add(this.cas.getView("_InitialView").getIndexRepository());
            this.sofaRefMap = new IntVector();
            this.indexMap = new IntVector();
            this.sofaRefMap.add(1);
            this.indexMap.add(0);
        }

        private final void resetBuffer() {
            this.buffer = new StringBuffer();
        }

        @Override
        public void startDocument() throws SAXException {
            this.state = 0;
        }

        @Override
        public void startElement(String nameSpaceURI, String localName, String qualifiedName, Attributes attrs) throws SAXException {
            this.resetBuffer();
            switch (this.state) {
                case 0: {
                    if (!qualifiedName.equals("CAS")) {
                        throw this.createException(0, qualifiedName);
                    }
                    this.state = 1;
                    break;
                }
                case 1: {
                    this.currentContentFeat = DEFAULT_CONTENT_FEATURE;
                    if (qualifiedName.equals(XCASDeserializer.this.getDocumentTypeName())) {
                        this.readDocument(attrs);
                        break;
                    }
                    this.readFS(qualifiedName, attrs);
                    break;
                }
                case 6: {
                    this.readArrayElement(qualifiedName, attrs);
                    break;
                }
                default: {
                    throw this.createException(1, qualifiedName);
                }
            }
        }

        private void readDocument(Attributes attrs) {
            this.state = 7;
        }

        private void readArrayElement(String eleName, Attributes attrs) throws SAXParseException {
            if (!eleName.equals("i")) {
                throw this.createException(2, eleName);
            }
            if (attrs.getLength() > 0) {
                throw this.createException(3);
            }
            this.state = 5;
        }

        private void readFS(String qualifiedName, Attributes attrs) throws SAXParseException {
            String typeName;
            TypeImpl type;
            this.fsId = Integer.parseInt(attrs.getValue("_id"));
            if (qualifiedName.equals("uima.cas.SofA")) {
                qualifiedName = "uima.cas.Sofa";
            }
            if ((type = XCASDeserializer.this.ts.getType(typeName = this.getCasTypeName(qualifiedName))) == null) {
                if (this.outOfTypeSystemData == null) {
                    throw this.createException(4, typeName);
                }
                this.addToOutOfTypeSystemData(typeName, attrs);
            } else {
                if (type.isArray()) {
                    this.readArray(type, attrs);
                    return;
                }
                this.readFS(type, attrs, true);
            }
        }

        private void readFS(TypeImpl type, Attributes attrs, boolean toIndex) throws SAXParseException {
            TOP fs;
            int typecode = type.getCode();
            if (33 == typecode) {
                String sofaID = attrs.getValue("sofaID");
                if (sofaID.equals("_DefaultTextSofaName")) {
                    sofaID = "_InitialView";
                }
                boolean isInitialView = sofaID.equals("_InitialView");
                String sofaNum = attrs.getValue("sofaNum");
                int extSofaNum = Integer.parseInt(sofaNum);
                if (this.indexMap.size() == 1) {
                    if (isInitialView) {
                        if (extSofaNum == 2) {
                            this.indexMap.add(-1);
                            this.indexMap.add(1);
                            this.nextIndex = 2;
                        } else {
                            this.indexMap.add(1);
                            this.nextIndex = 2;
                        }
                    } else if (extSofaNum > 1) {
                        this.indexMap.add(1);
                        assert (extSofaNum == 2);
                        this.indexMap.add(2);
                        this.nextIndex = 3;
                    } else {
                        this.indexMap.add(2);
                        this.nextIndex = 3;
                    }
                } else if (isInitialView) {
                    if (this.indexMap.size() == extSofaNum) {
                        this.indexMap.add(1);
                    }
                } else {
                    this.indexMap.add(this.nextIndex);
                    ++this.nextIndex;
                }
                if (this.sofaRefMap.size() == extSofaNum) {
                    this.sofaRefMap.add(this.fsId);
                } else if (this.sofaRefMap.size() > extSofaNum) {
                    this.sofaRefMap.set(extSofaNum, this.fsId);
                } else {
                    this.sofaRefMap.setSize(extSofaNum + 1);
                    this.sofaRefMap.set(extSofaNum, this.fsId);
                }
                String sofaMimeType = attrs.getValue("mimeType");
                String finalSofaId = sofaID;
                fs = this.maybeCreateWithV2Id(this.fsId, () -> this.cas.createSofa(this.indexMap.get(extSofaNum), finalSofaId, sofaMimeType));
            } else if (type.isAnnotationBaseType()) {
                CAS casView;
                String extSofaNum = attrs.getValue("sofa");
                if (extSofaNum != null) {
                    casView = this.cas.getView(this.indexMap.size() == 1 ? 1 : this.indexMap.get(Integer.parseInt(extSofaNum)));
                } else {
                    String extSofaRefString = attrs.getValue("_ref_sofa");
                    if (null == extSofaRefString || extSofaRefString.length() == 0) {
                        throw this.createException(13);
                    }
                    casView = this.cas.getView((Sofa)this.fsTree.get((int)Integer.parseInt((String)extSofaRefString)).fs);
                }
                if (type.getCode() == 36) {
                    fs = this.maybeCreateWithV2Id(this.fsId, () -> (TOP)casView.getDocumentAnnotation());
                    this.cas.removeFromCorruptableIndexAnyView(fs, this.cas.getAddbackSingle());
                } else {
                    fs = this.maybeCreateWithV2Id(this.fsId, () -> (TOP)casView.createFS(type));
                    if (this.currentFs instanceof UimaSerializable) {
                        UimaSerializable ufs = (UimaSerializable)((Object)this.currentFs);
                        this.uimaSerializableFixups.add(() -> ufs._init_from_cas_data());
                    }
                }
            } else {
                fs = this.maybeCreateWithV2Id(this.fsId, () -> (TOP)this.cas.createFS(type));
                if (this.currentFs instanceof UimaSerializable) {
                    UimaSerializable ufs = (UimaSerializable)((Object)this.currentFs);
                    this.uimaSerializableFixups.add(() -> ufs._init_from_cas_data());
                }
            }
            this.currentFs = fs;
            int extId = -1;
            IntVector indexRep = new IntVector(1);
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrName = attrs.getQName(i);
                String attrValue = attrs.getValue(i);
                if (attrName.startsWith(reservedAttrPrefix)) {
                    if (attrName.equals("_id")) {
                        try {
                            extId = Integer.parseInt(attrValue);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw this.createException(5, attrValue);
                        }
                    }
                    if (attrName.equals("_content")) {
                        this.currentContentFeat = attrValue;
                        continue;
                    }
                    if (attrName.equals("_indexed")) {
                        String[] arrayvals = this.parseArray(attrValue);
                        for (int s = 0; s < arrayvals.length; ++s) {
                            indexRep.add(Integer.parseInt(arrayvals[s]));
                        }
                        continue;
                    }
                    this.handleFeature(type, fs, attrName, attrValue, false);
                    continue;
                }
                if (33 == typecode && attrName.equals("sofaID") && attrValue.equals("_DefaultTextSofaName")) {
                    attrValue = "_InitialView";
                }
                if (type.isAnnotationBaseType() && attrName.equals("sofa")) continue;
                this.handleFeature(type, fs, attrName, attrValue, false);
            }
            if (type.getCode() == 36) {
                this.cas.addbackSingle(fs);
            }
            if (33 == typecode) {
                Sofa sofa = (Sofa)fs;
                this.cas.getBaseIndexRepository().addFS(sofa);
                CASImpl view = this.cas.getView(sofa);
                if (sofa.getSofaRef() == 1) {
                    this.cas.registerInitialSofa();
                } else {
                    this.indexRepositories.add(this.cas.getSofaIndexRepository(sofa));
                }
                view.registerView(sofa);
                this.views.add(view);
            }
            FSInfo fsInfo = new FSInfo(fs, indexRep);
            if (extId < 0) {
                this.idLess.add(fsInfo);
            } else {
                this.fsTree.put(extId, fsInfo);
            }
            this.state = 3;
        }

        private void readArray(TypeImpl type, Attributes attrs) throws SAXParseException {
            IntVector indexRep = new IntVector();
            int size = 0;
            int id = -1;
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrName = attrs.getQName(i);
                String attrVal = attrs.getValue(i);
                if (attrName.equals("_id")) {
                    try {
                        id = Integer.parseInt(attrVal);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw this.createException(5, attrVal);
                    }
                }
                if (attrName.equals("size")) {
                    try {
                        size = Integer.parseInt(attrVal);
                        if (size >= 0) continue;
                        throw this.createException(6, attrVal);
                    }
                    catch (NumberFormatException e) {
                        throw this.createException(9, attrVal);
                    }
                }
                if (attrName.equals("_indexed")) {
                    String[] arrayvals = this.parseArray(attrVal);
                    for (int s = 0; s < arrayvals.length; ++s) {
                        indexRep.add(Integer.parseInt(arrayvals[s]));
                    }
                    continue;
                }
                throw this.createException(7, attrName);
            }
            int finalSize = size;
            TOP fs = this.maybeCreateWithV2Id(this.fsId, () -> this.cas.createArray(type, finalSize));
            FSInfo fsInfo = new FSInfo(fs, indexRep);
            if (id >= 0) {
                this.fsTree.put(id, fsInfo);
            } else {
                this.idLess.add(fsInfo);
            }
            this.currentFs = fs;
            this.arrayPos = 0;
            this.state = 6;
        }

        private final boolean emptyVal(String val) {
            return val == null || val.length() == 0;
        }

        private void handleFeature(TOP fs, String featName, String featVal, boolean lenient) throws SAXParseException {
            TypeImpl type = fs._getTypeImpl();
            this.handleFeature(type, fs, featName, featVal, lenient);
        }

        private void handleFeature(Type type, TOP fs, String featName, String featValIn, boolean lenient) throws SAXParseException {
            String featVal = featName.equals("sofa") && ((TypeImpl)type).isAnnotationBaseType() ? Integer.toString(this.sofaRefMap.get(((Sofa)this.fsTree.get((int)Integer.parseInt((String)featValIn)).fs).getSofaNum())) : featValIn;
            String realFeatName = this.getRealFeatName(featName);
            FeatureImpl feat = (FeatureImpl)type.getFeatureByBaseName(realFeatName);
            if (feat == null) {
                if (this.outOfTypeSystemData != null) {
                    List ootsAttrs = this.outOfTypeSystemData.extraFeatureValues.computeIfAbsent(fs, k -> new ArrayList());
                    ootsAttrs.add(new Pair<String, String>(featName, featVal));
                } else if (!lenient) {
                    throw this.createException(8, featName);
                }
            } else if (feat.getRangeImpl().isRefType) {
                this.fixupToDos.add(() -> this.finalizeRefValue(Integer.parseInt(featVal), fs, feat));
            } else {
                CASImpl.setFeatureValueFromStringNoDocAnnotUpdate(fs, feat, featVal);
            }
        }

        private String getRealFeatName(String featName) {
            return featName.startsWith("_ref_") ? featName.substring("_ref_".length()) : featName;
        }

        @Override
        public void characters(char[] chars, int start, int length) throws SAXException {
            switch (this.state) {
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 9: {
                    this.buffer.append(chars, start, length);
                    break;
                }
            }
        }

        boolean isAllWhitespace(StringBuffer b) {
            int len = b.length();
            for (int i = 0; i < len; ++i) {
                if (Character.isWhitespace(b.charAt(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public void endElement(String nsURI, String localName, String qualifiedName) throws SAXException {
            switch (this.state) {
                case 0: {
                    break;
                }
                case 1: {
                    this.state = 0;
                    break;
                }
                case 2: {
                    this.state = 1;
                    break;
                }
                case 3: {
                    if (!this.isAllWhitespace(this.buffer)) {
                        try {
                            this.handleFeature(this.currentFs, this.currentContentFeat, this.buffer.toString(), true);
                        }
                        catch (XCASParsingException xCASParsingException) {
                            // empty catch block
                        }
                    }
                    this.state = 1;
                    break;
                }
                case 4: {
                    this.handleFeature(this.currentFs, qualifiedName, this.buffer.toString(), false);
                    this.state = 2;
                    break;
                }
                case 5: {
                    this.addArrayElement(this.buffer.toString());
                    this.state = 6;
                    break;
                }
                case 6: {
                    this.state = 1;
                    break;
                }
                case 7: {
                    Sofa newSofa = (Sofa)this.maybeCreateWithV2Id(1, () -> this.cas.createInitialSofa("text"));
                    CASImpl initialView = this.cas.getInitialView();
                    initialView.registerView(newSofa);
                    initialView.setDocTextFromDeserializtion(this.buffer.toString());
                    int id = 1;
                    this.sofaRefMap.add(id);
                    FSInfo fsInfo = new FSInfo(newSofa, new IntVector());
                    this.fsTree.put(id, fsInfo);
                    this.state = 1;
                    break;
                }
                case 9: {
                    if (!this.isAllWhitespace(this.buffer)) {
                        this.currentOotsFs.featVals.put(this.currentContentFeat, this.buffer.toString());
                    }
                    this.state = 1;
                    break;
                }
                case 8: {
                    this.state = 1;
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        private void addArrayElement(String content) throws SAXParseException {
            if (this.currentFs instanceof CommonPrimitiveArray) {
                fsa = (CommonPrimitiveArray)this.currentFs;
                if (this.arrayPos >= fsa.size()) {
                    throw this.createException(11);
                }
                try {
                    if (this.emptyVal(content)) ** GOTO lbl17
                    fsa.setArrayValueFromString(this.arrayPos, content);
                }
                catch (NumberFormatException e) {
                    throw this.createException(9, content);
                }
            } else if (content != null && content.length() > 0) {
                fsa = (FSArray)this.currentFs;
                pos = this.arrayPos;
                extId = Integer.parseInt(content);
                this.fixupToDos.add((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$addArrayElement$10(int int org.apache.uima.jcas.cas.FSArray ), ()V)((XCASDeserializerHandler)this, (int)extId, (int)pos, (FSArray)fsa));
            }
lbl17:
            // 5 sources

            ++this.arrayPos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endDocument() throws SAXException {
            for (Runnable fixup : this.fixupToDos) {
                fixup.run();
            }
            for (FSInfo fsInfo : this.fsTree) {
                this.finalizeFS(fsInfo);
            }
            for (int i = 0; i < this.idLess.size(); ++i) {
                this.finalizeFS(this.idLess.get(i));
            }
            if (this.outOfTypeSystemData != null) {
                for (FSData fsData : this.outOfTypeSystemData.fsList) {
                    this.finalizeOutOfTypeSystemFS(fsData);
                }
                this.finalizeOutOfTypeSystemFeatures();
            }
            for (CAS view : this.views) {
                AutoCloseable ac = view.protectIndexes();
                try {
                    ((CASImpl)view).updateDocumentAnnotation();
                }
                finally {
                    try {
                        ac.close();
                    }
                    catch (Exception e) {
                        Misc.internalError();
                    }
                }
            }
            for (Runnable r : this.uimaSerializableFixups) {
                r.run();
            }
        }

        private void finalizeFS(FSInfo fsInfo) {
            this.finalizeAddToIndexes(fsInfo);
        }

        private void finalizeRefValue(int extId, TOP fs, FeatureImpl fi) {
            FSInfo fsInfo = this.fsTree.get(extId);
            if (fsInfo == null) {
                if (extId != 0 && this.outOfTypeSystemData != null) {
                    List ootsAttrs = this.outOfTypeSystemData.extraFeatureValues.computeIfAbsent(fs, k -> new ArrayList());
                    String featFullName = fi.getName();
                    int separatorOffset = featFullName.indexOf(58);
                    String featName = "_ref_" + featFullName.substring(separatorOffset + 1);
                    ootsAttrs.add(new Pair<CallSite, String>((CallSite)((Object)featName), Integer.toString(extId)));
                }
                CASImpl.setFeatureValueMaybeSofa(fs, fi, null);
            } else if (fi.getCode() != 15) {
                if (fs instanceof Sofa) {
                    Sofa sofa = (Sofa)fs;
                    switch (fi.getRangeImpl().getCode()) {
                        case 12: {
                            sofa.setLocalSofaData(fsInfo.fs);
                            break;
                        }
                        default: {
                            throw new CASRuntimeException("INTERNAL_ERROR", new Object[0]);
                        }
                    }
                    return;
                }
                XCASDeserializer.this.ts.fixupFSArrayTypes(fi.getRangeImpl(), fsInfo.fs);
                CASImpl.setFeatureValueMaybeSofa(fs, fi, fsInfo.fs);
            }
        }

        private void finalizeArrayRefValue(int extId, int pos, FSArray fs) {
            FSInfo fsInfo = this.fsTree.get(extId);
            if (fsInfo == null) {
                if (extId != 0 && this.outOfTypeSystemData != null) {
                    List ootsElements = this.outOfTypeSystemData.arrayElements.computeIfAbsent(fs, k -> new ArrayList());
                    ArrayElement ootsElem = new ArrayElement(pos, "a" + Integer.toString(extId));
                    ootsElements.add(ootsElem);
                }
                fs.set(pos, null);
            } else {
                fs.set(pos, fsInfo.fs);
            }
        }

        private void finalizeAddToIndexes(FSInfo fsInfo) {
            if (fsInfo.indexRep.size() >= 0) {
                for (int i = 0; i < fsInfo.indexRep.size(); ++i) {
                    if (this.indexMap.size() == 1) {
                        ((FSIndexRepositoryImpl)this.indexRepositories.get(fsInfo.indexRep.get(i))).addFS(fsInfo.fs);
                        continue;
                    }
                    ((FSIndexRepositoryImpl)this.indexRepositories.get(this.indexMap.get(fsInfo.indexRep.get(i)))).addFS(fsInfo.fs);
                }
            }
        }

        private void finalizeOutOfTypeSystemFS(FSData aFS) {
            aFS.id = "a" + aFS.id;
            for (Map.Entry<String, Object> entry : aFS.featVals.entrySet()) {
                int val;
                String attrName = entry.getKey();
                if (!attrName.startsWith("_ref_") || (val = Integer.parseInt((String)entry.getValue())) < 0) continue;
                FSInfo fsValInfo = this.fsTree.get(val);
                if (fsValInfo != null) {
                    entry.setValue(fsValInfo.fs);
                    continue;
                }
                entry.setValue("a" + val);
            }
        }

        private void finalizeOutOfTypeSystemFeatures() {
            for (List<Pair<String, Object>> attrs : this.outOfTypeSystemData.extraFeatureValues.values()) {
                for (Pair<String, Object> p : attrs) {
                    int val;
                    String sv;
                    String string = sv = p.u instanceof String ? (String)p.u : "";
                    if (!((String)p.t).startsWith("_ref_") || (val = Integer.parseInt(sv)) < 0) continue;
                    FSInfo fsValInfo = this.fsTree.get(val);
                    if (fsValInfo != null) {
                        p.u = fsValInfo.fs;
                        continue;
                    }
                    p.u = "a" + val;
                }
            }
        }

        private XCASParsingException createException(int code) {
            XCASParsingException e = new XCASParsingException(code);
            String source = unknownXMLSource;
            String line = unknownXMLSource;
            String col = unknownXMLSource;
            if (this.locator != null) {
                source = this.locator.getSystemId();
                if (source == null) {
                    source = this.locator.getPublicId();
                }
                if (source == null) {
                    source = unknownXMLSource;
                }
                line = Integer.toString(this.locator.getLineNumber());
                col = Integer.toString(this.locator.getColumnNumber());
            }
            e.addArgument(source);
            e.addArgument(line);
            e.addArgument(col);
            return e;
        }

        private XCASParsingException createException(int code, String arg) {
            XCASParsingException e = this.createException(code);
            e.addArgument(arg);
            return e;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator loc) {
            this.locator = loc;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            throw e;
        }

        private void addToOutOfTypeSystemData(String typeName, Attributes attrs) throws XCASParsingException {
            if (this.outOfTypeSystemData != null) {
                FSData fsData = new FSData();
                fsData.type = typeName;
                fsData.indexRep = null;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String attrName = attrs.getQName(i);
                    String attrValue = attrs.getValue(i);
                    if (attrName.startsWith(reservedAttrPrefix)) {
                        if (attrName.equals("_id")) {
                            fsData.id = attrValue;
                            continue;
                        }
                        if (attrName.equals("_content")) {
                            this.currentContentFeat = attrValue;
                            continue;
                        }
                        if (attrName.equals("_indexed")) {
                            fsData.indexRep = attrValue;
                            continue;
                        }
                        fsData.featVals.put(attrName, attrValue);
                        continue;
                    }
                    fsData.featVals.put(attrName, attrValue);
                }
                this.outOfTypeSystemData.fsList.add(fsData);
                this.currentOotsFs = fsData;
                this.state = 9;
            }
        }

        private String[] parseArray(String val) {
            String[] arrayVals = this.emptyVal(val = val.trim()) ? Constants.EMPTY_STRING_ARRAY : val.split("\\s+");
            return arrayVals;
        }

        private String getCasTypeName(String aTagName) {
            if (aTagName.indexOf(58) == -1 && aTagName.indexOf(45) == -1) {
                return aTagName;
            }
            return StringUtils.replaceAll(StringUtils.replaceAll(aTagName, ":", "_colon_"), "-", "_dash_");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TOP maybeCreateWithV2Id(int id, Supplier<TOP> create) {
            if (this.cas.is_ll_enableV2IdRefs()) {
                this.cas.set_reuseId(id);
                try {
                    TOP fs = create.get();
                    if (this.highestIdFs == null) {
                        this.highestIdFs = fs;
                    } else if (this.highestIdFs._id < fs._id) {
                        this.highestIdFs = fs;
                    }
                    TOP tOP = fs;
                    return tOP;
                }
                finally {
                    this.cas.set_reuseId(0);
                }
            }
            return create.get();
        }

        private /* synthetic */ void lambda$addArrayElement$10(int extId, int pos, FSArray fsa) {
            this.finalizeArrayRefValue(extId, pos, fsa);
        }
    }

    private static class FSInfo {
        private final TOP fs;
        private final IntVector indexRep;

        private FSInfo(TOP fs, IntVector indexRep) {
            this.fs = fs;
            this.indexRep = indexRep;
        }
    }
}

