/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple.ast;

import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.language.simple.ast.BaseSimpleNode;
import org.apache.camel.language.simple.ast.BlockStart;
import org.apache.camel.language.simple.ast.CompositeNodes;
import org.apache.camel.language.simple.ast.SimpleNode;
import org.apache.camel.language.simple.types.SimpleToken;

public class DoubleQuoteStart
extends BaseSimpleNode
implements BlockStart {
    private final CompositeNodes block;

    public DoubleQuoteStart(SimpleToken token) {
        super(token);
        this.block = new CompositeNodes(token);
    }

    @Override
    public String toString() {
        return "\"" + this.block + "\"";
    }

    @Override
    public Expression createExpression(String expression) {
        Expression answer = null;
        if (this.block != null) {
            answer = this.block.createExpression(expression);
        }
        if (answer == null) {
            answer = ExpressionBuilder.constantExpression("");
        }
        return answer;
    }

    @Override
    public boolean acceptAndAddNode(SimpleNode node) {
        this.block.addChild(node);
        return true;
    }
}

