/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.lifecycle;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleWatcher
implements SynchronousBundleListener,
ServiceListener {
    private static final Logger logger = LoggerFactory.getLogger((String)BundleWatcher.class.getName());
    private long startupTime;
    private Map<String, Long> bundleStartupTimes = new LinkedHashMap<String, Long>();
    private long unomiStartedBundleCount = 0L;
    private long requiredStartedBundleCount;
    private String requiredServices;
    private Set<Filter> requiredServicesFilters = new LinkedHashSet<Filter>();
    private long matchedRequiredServicesCount = 0L;
    private BundleContext bundleContext;
    private boolean startupMessageAlreadyDisplayed = false;
    private boolean shutdownMessageAlreadyDisplayed = false;
    private List<String> logoLines = new ArrayList<String>();

    public void setRequiredStartedBundleCount(long requiredStartedBundleCount) {
        this.requiredStartedBundleCount = requiredStartedBundleCount;
    }

    public void setRequiredServices(String requiredServices) {
        this.requiredServices = requiredServices;
        String[] requiredServiceArray = requiredServices.split(",");
        this.requiredServicesFilters.clear();
        for (String requiredService : requiredServiceArray) {
            try {
                this.requiredServicesFilters.add(this.bundleContext.createFilter(requiredService.trim()));
            }
            catch (InvalidSyntaxException e) {
                logger.error("Error creating require service filter {}", (Object)requiredService.trim(), (Object)e);
            }
        }
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void init() {
        this.bundleContext.addBundleListener((BundleListener)this);
        this.bundleContext.addServiceListener((ServiceListener)this);
        this.loadLogo();
        this.startupTime = System.currentTimeMillis();
        System.out.println("Initializing Unomi...");
        logger.info("Bundle watcher initialized.");
    }

    public void destroy() {
        this.bundleContext.removeServiceListener((ServiceListener)this);
        this.bundleContext.removeBundleListener((BundleListener)this);
        logger.info("Bundle watcher shutdown.");
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 128: {
                break;
            }
            case 2: {
                if (!event.getBundle().getSymbolicName().startsWith("org.apache.unomi")) break;
                ++this.unomiStartedBundleCount;
                this.checkStartupComplete();
                break;
            }
            case 256: {
                break;
            }
            case 4: {
                if (!event.getBundle().getSymbolicName().startsWith("org.apache.unomi")) break;
                --this.unomiStartedBundleCount;
            }
        }
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference serviceReference = event.getServiceReference();
        if (serviceReference == null) {
            return;
        }
        switch (event.getType()) {
            case 1: {
                this.addStartedService(serviceReference);
                this.checkStartupComplete();
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                this.removeStartedService(serviceReference);
            }
        }
    }

    private void addStartedService(ServiceReference serviceReference) {
        for (Filter requiredService : this.requiredServicesFilters) {
            if (!requiredService.match(serviceReference)) continue;
            ++this.matchedRequiredServicesCount;
        }
    }

    private void removeStartedService(ServiceReference serviceReference) {
        for (Filter requiredService : this.requiredServicesFilters) {
            if (!requiredService.match(serviceReference)) continue;
            --this.matchedRequiredServicesCount;
            if (!this.shutdownMessageAlreadyDisplayed) {
                System.out.println("Apache Unomi shutting down...");
                logger.info("Apache Unomi no longer available, as required service {} is shutdown !", (Object)serviceReference);
                this.shutdownMessageAlreadyDisplayed = true;
            }
            this.startupMessageAlreadyDisplayed = false;
        }
    }

    private void checkStartupComplete() {
        if (!this.isStartupComplete()) {
            return;
        }
        if (!this.startupMessageAlreadyDisplayed) {
            long totalStartupTime = System.currentTimeMillis() - this.startupTime;
            if (this.logoLines.size() > 0) {
                for (String logoLine : this.logoLines) {
                    System.out.println(logoLine);
                }
            }
            String buildNumber = "n/a";
            if (this.bundleContext.getBundle().getHeaders().get("Implementation-Build") != null) {
                buildNumber = (String)this.bundleContext.getBundle().getHeaders().get("Implementation-Build");
            }
            String timestamp = "n/a";
            if (this.bundleContext.getBundle().getHeaders().get("Implementation-TimeStamp") != null) {
                timestamp = (String)this.bundleContext.getBundle().getHeaders().get("Implementation-TimeStamp");
            }
            String versionMessage = "  " + this.bundleContext.getBundle().getVersion().toString() + "  Build:" + buildNumber + "  Timestamp:" + timestamp;
            System.out.println(versionMessage);
            System.out.println("--------------------------------------------------------------------------");
            System.out.println("Successfully started " + this.unomiStartedBundleCount + " bundles and " + this.matchedRequiredServicesCount + " required services in " + totalStartupTime + " ms");
            logger.info("Apache Unomi version: " + versionMessage);
            logger.info("Apache Unomi successfully started {} bundles and {} required services in {} ms", new Object[]{this.unomiStartedBundleCount, this.matchedRequiredServicesCount, totalStartupTime});
            this.startupMessageAlreadyDisplayed = true;
            this.shutdownMessageAlreadyDisplayed = false;
        }
    }

    public boolean isStartupComplete() {
        if (this.unomiStartedBundleCount < this.requiredStartedBundleCount) {
            return false;
        }
        return this.matchedRequiredServicesCount >= (long)this.requiredServicesFilters.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLogo() {
        URL logoURL = this.bundleContext.getBundle().getResource("logo.txt");
        if (logoURL != null) {
            BufferedReader bufferedReader = null;
            try {
                String line;
                bufferedReader = new BufferedReader(new InputStreamReader(logoURL.openStream()));
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.trim().startsWith("#")) continue;
                    this.logoLines.add(line);
                }
            }
            catch (IOException e) {
                logger.error("Error loading logo lines", (Throwable)e);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

