/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.function.ScriptScoreFunction;
import org.elasticsearch.common.lucene.search.function.ScriptScoreQuery;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.InnerHitContextBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.functionscore.ScriptScoreFunctionBuilder;
import org.elasticsearch.script.Script;

public class ScriptScoreQueryBuilder
extends AbstractQueryBuilder<ScriptScoreQueryBuilder> {
    public static final String NAME = "script_score";
    public static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    public static final ParseField SCRIPT_FIELD = new ParseField("script", new String[0]);
    public static final ParseField MIN_SCORE_FIELD = new ParseField("min_score", new String[0]);
    private static ConstructingObjectParser<ScriptScoreQueryBuilder, Void> PARSER = new ConstructingObjectParser("script_score", false, args -> {
        ScriptScoreFunctionBuilder ssFunctionBuilder = new ScriptScoreFunctionBuilder((Script)args[1]);
        ScriptScoreQueryBuilder ssQueryBuilder = new ScriptScoreQueryBuilder((QueryBuilder)args[0], ssFunctionBuilder);
        if (args[2] != null) {
            ssQueryBuilder.setMinScore(((Float)args[2]).floatValue());
        }
        if (args[3] != null) {
            ssQueryBuilder.boost(((Float)args[3]).floatValue());
        }
        if (args[4] != null) {
            ssQueryBuilder.queryName((String)args[4]);
        }
        return ssQueryBuilder;
    });
    private final QueryBuilder query;
    private Float minScore = null;
    private final ScriptScoreFunctionBuilder scriptScoreFunctionBuilder;

    public static ScriptScoreQueryBuilder fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public ScriptScoreQueryBuilder(QueryBuilder query, ScriptScoreFunctionBuilder scriptScoreFunctionBuilder) {
        if (query == null) {
            throw new IllegalArgumentException("script_score: query must not be null");
        }
        if (scriptScoreFunctionBuilder == null) {
            throw new IllegalArgumentException("script_score: script must not be null");
        }
        this.query = query;
        this.scriptScoreFunctionBuilder = scriptScoreFunctionBuilder;
    }

    public ScriptScoreQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.query = in.readNamedWriteable(QueryBuilder.class);
        this.scriptScoreFunctionBuilder = in.readNamedWriteable(ScriptScoreFunctionBuilder.class);
        this.minScore = in.readOptionalFloat();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.query);
        out.writeNamedWriteable(this.scriptScoreFunctionBuilder);
        out.writeOptionalFloat(this.minScore);
    }

    public QueryBuilder query() {
        return this.query;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName());
        this.query.toXContent(builder, params);
        builder.field(SCRIPT_FIELD.getPreferredName(), this.scriptScoreFunctionBuilder.getScript());
        if (this.minScore != null) {
            builder.field(MIN_SCORE_FIELD.getPreferredName(), this.minScore);
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public ScriptScoreQueryBuilder setMinScore(float minScore) {
        this.minScore = Float.valueOf(minScore);
        return this;
    }

    public Float getMinScore() {
        return this.minScore;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected boolean doEquals(ScriptScoreQueryBuilder other) {
        return Objects.equals(this.query, other.query) && Objects.equals(this.scriptScoreFunctionBuilder, other.scriptScoreFunctionBuilder) && Objects.equals(this.minScore, other.minScore);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.query, this.scriptScoreFunctionBuilder, this.minScore);
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        ScriptScoreFunction function = (ScriptScoreFunction)this.scriptScoreFunctionBuilder.toFunction(context);
        Query query = this.query.toQuery(context);
        return new ScriptScoreQuery(query, function, this.minScore);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        QueryBuilder newQuery = this.query.rewrite(queryRewriteContext);
        if (newQuery != this.query) {
            ScriptScoreQueryBuilder newQueryBuilder = new ScriptScoreQueryBuilder(newQuery, this.scriptScoreFunctionBuilder);
            newQueryBuilder.setMinScore(this.minScore.floatValue());
            return newQueryBuilder;
        }
        return this;
    }

    @Override
    protected void extractInnerHitBuilders(Map<String, InnerHitContextBuilder> innerHits) {
        InnerHitContextBuilder.extractInnerHits(this.query(), innerHits);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ScriptScoreQueryBuilder.parseInnerQueryBuilder(p), QUERY_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Script.parse(p), SCRIPT_FIELD);
        PARSER.declareFloat(ConstructingObjectParser.optionalConstructorArg(), MIN_SCORE_FIELD);
        PARSER.declareFloat(ConstructingObjectParser.optionalConstructorArg(), AbstractQueryBuilder.BOOST_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), AbstractQueryBuilder.NAME_FIELD);
    }
}

