/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.shell.handler;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.cellar.core.command.Command;
import org.apache.karaf.cellar.core.control.ManageHandlersCommand;
import org.apache.karaf.cellar.core.control.ManageHandlersResult;
import org.apache.karaf.cellar.shell.ClusterCommandSupport;
import org.apache.karaf.shell.support.table.ShellTable;

public abstract class HandlersSupport
extends ClusterCommandSupport {
    protected Object doExecute(String handlerName, List<String> nodeIdsOrAliases, Boolean status) throws Exception {
        ManageHandlersCommand command = new ManageHandlersCommand(this.clusterManager.generateId());
        command.setTimeout(this.timeout * 1000L);
        Set<Node> recipientList = new HashSet<Node>();
        if (nodeIdsOrAliases != null && !nodeIdsOrAliases.isEmpty()) {
            for (String nodeIdOrAlias : nodeIdsOrAliases) {
                Node node = this.clusterManager.findNodeByIdOrAlias(nodeIdOrAlias);
                if (node == null) {
                    System.err.println("Cluster node " + nodeIdOrAlias + " doesn't exist");
                    continue;
                }
                recipientList.add(node);
            }
        } else if (status == null) {
            recipientList = this.clusterManager.listNodes();
        } else {
            recipientList.add(this.clusterManager.getNode());
        }
        if (recipientList.size() < 1) {
            return null;
        }
        command.setDestination(recipientList);
        command.setHandlerName(handlerName);
        command.setStatus(status);
        Map results = this.executionContext.execute((Command)command);
        if (results == null || results.isEmpty()) {
            System.out.println("No result received within given timeout");
        } else {
            ShellTable table = new ShellTable();
            table.column(" ");
            table.column("Node");
            table.column("Status");
            table.column("Event Handler");
            for (Map.Entry handlersResultEntry : results.entrySet()) {
                ManageHandlersResult result;
                Node node = (Node)handlersResultEntry.getKey();
                String local = "";
                if (node.equals(this.clusterManager.getNode())) {
                    local = "x";
                }
                if ((result = (ManageHandlersResult)handlersResultEntry.getValue()) == null || result.getHandlers() == null) continue;
                for (Map.Entry handlerEntry : result.getHandlers().entrySet()) {
                    String handler = (String)handlerEntry.getKey();
                    String s = (String)handlerEntry.getValue();
                    String nodeName = node.getAlias();
                    if (nodeName == null) {
                        nodeName = node.getId();
                    }
                    table.addRow().addContent(new Object[]{local, nodeName, s, handler});
                }
            }
            table.print(System.out);
        }
        return null;
    }
}

