/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.lifecycle;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleWatcher
implements SynchronousBundleListener,
ServiceListener {
    private static final Logger logger = LoggerFactory.getLogger((String)BundleWatcher.class.getName());
    private long startupTime;
    private Map<String, Boolean> requiredBundles = new ConcurrentHashMap<String, Boolean>();
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> scheduledFuture;
    private String requiredServices;
    private Set<Filter> requiredServicesFilters = new LinkedHashSet<Filter>();
    private long matchedRequiredServicesCount = 0L;
    private BundleContext bundleContext;
    private boolean startupMessageAlreadyDisplayed = false;
    private boolean shutdownMessageAlreadyDisplayed = false;
    private List<String> logoLines = new ArrayList<String>();
    private Integer checkStartupStateRefreshInterval = 60;

    public void setRequiredBundles(Map<String, Boolean> requiredBundles) {
        this.requiredBundles = new ConcurrentHashMap<String, Boolean>(requiredBundles);
    }

    public void setCheckStartupStateRefreshInterval(Integer checkStartupStateRefreshInterval) {
        this.checkStartupStateRefreshInterval = checkStartupStateRefreshInterval;
    }

    public void setRequiredServices(String requiredServices) {
        this.requiredServices = requiredServices;
        String[] requiredServiceArray = requiredServices.split(",");
        this.requiredServicesFilters.clear();
        for (String requiredService : requiredServiceArray) {
            try {
                this.requiredServicesFilters.add(this.bundleContext.createFilter(requiredService.trim()));
            }
            catch (InvalidSyntaxException e) {
                logger.error("Error creating require service filter {}", (Object)requiredService.trim(), (Object)e);
            }
        }
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void init() {
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.checkExistingBundles();
        this.bundleContext.addBundleListener((BundleListener)this);
        this.bundleContext.addServiceListener((ServiceListener)this);
        this.loadLogo();
        this.startupTime = System.currentTimeMillis();
        System.out.println("Initializing Unomi...");
        logger.info("Bundle watcher initialized.");
    }

    private boolean allBundleStarted() {
        return this.getInactiveBundles().isEmpty();
    }

    private void displayLogsForInactiveBundles() {
        this.getInactiveBundles().forEach(inactiveBundle -> logger.warn("The bundle {} is in not active, some errors could happen when using the application", inactiveBundle));
    }

    private List<String> getInactiveBundles() {
        return this.requiredBundles.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public void destroy() {
        this.bundleContext.removeServiceListener((ServiceListener)this);
        this.bundleContext.removeBundleListener((BundleListener)this);
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        logger.info("Bundle watcher shutdown.");
    }

    public void checkExistingBundles() {
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (!bundle.getSymbolicName().startsWith("org.apache.unomi") || !this.requiredBundles.containsKey(bundle.getSymbolicName())) continue;
            if (bundle.getState() == 32) {
                this.requiredBundles.put(bundle.getSymbolicName(), true);
                continue;
            }
            this.requiredBundles.put(bundle.getSymbolicName(), false);
        }
        this.checkStartupComplete();
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 128: {
                break;
            }
            case 2: {
                if (!event.getBundle().getSymbolicName().startsWith("org.apache.unomi") || !this.requiredBundles.containsKey(event.getBundle().getSymbolicName())) break;
                logger.info("Bundle {} was started.", (Object)event.getBundle().getSymbolicName());
                this.requiredBundles.put(event.getBundle().getSymbolicName(), true);
                this.checkStartupComplete();
                break;
            }
            case 256: {
                break;
            }
            case 4: {
                if (!event.getBundle().getSymbolicName().startsWith("org.apache.unomi") || !this.requiredBundles.containsKey(event.getBundle().getSymbolicName())) break;
                logger.info("Bundle {} was stopped", (Object)event.getBundle().getSymbolicName());
                this.requiredBundles.put(event.getBundle().getSymbolicName(), false);
                break;
            }
        }
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference serviceReference = event.getServiceReference();
        if (serviceReference == null) {
            return;
        }
        switch (event.getType()) {
            case 1: {
                this.addStartedService(serviceReference);
                this.checkStartupComplete();
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                this.removeStartedService(serviceReference);
            }
        }
    }

    private void addStartedService(ServiceReference serviceReference) {
        for (Filter requiredService : this.requiredServicesFilters) {
            if (!requiredService.match(serviceReference)) continue;
            ++this.matchedRequiredServicesCount;
        }
    }

    private void removeStartedService(ServiceReference serviceReference) {
        for (Filter requiredService : this.requiredServicesFilters) {
            if (!requiredService.match(serviceReference)) continue;
            --this.matchedRequiredServicesCount;
            if (!this.shutdownMessageAlreadyDisplayed) {
                System.out.println("Apache Unomi shutting down...");
                logger.info("Apache Unomi no longer available, as required service {} is shutdown !", (Object)serviceReference);
                this.shutdownMessageAlreadyDisplayed = true;
            }
            this.startupMessageAlreadyDisplayed = false;
        }
    }

    private void displayLogsForInactiveServices() {
        this.requiredServicesFilters.forEach(requiredServicesFilter -> {
            ServiceReference[] serviceReference = new ServiceReference[]{};
            String filterToString = requiredServicesFilter.toString();
            try {
                serviceReference = this.bundleContext.getServiceReferences((String)null, filterToString);
            }
            catch (InvalidSyntaxException e) {
                logger.error("Failed to get the service reference for {}", (Object)filterToString, (Object)e);
            }
            if (serviceReference == null) {
                logger.warn("No service found for the filter {}, some errors could happen when using the application", (Object)filterToString);
            }
        });
    }

    private void checkStartupComplete() {
        if (!this.isStartupComplete()) {
            if (this.scheduledFuture == null || this.scheduledFuture.isCancelled()) {
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        BundleWatcher.this.displayLogsForInactiveBundles();
                        BundleWatcher.this.displayLogsForInactiveServices();
                        BundleWatcher.this.checkStartupComplete();
                    }
                };
                this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(task, this.checkStartupStateRefreshInterval.intValue(), this.checkStartupStateRefreshInterval.intValue(), TimeUnit.SECONDS);
            }
            return;
        }
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
        if (!this.startupMessageAlreadyDisplayed) {
            long totalStartupTime = System.currentTimeMillis() - this.startupTime;
            if (!this.logoLines.isEmpty()) {
                this.logoLines.forEach(System.out::println);
            }
            String buildNumber = "n/a";
            if (this.bundleContext.getBundle().getHeaders().get("Implementation-Build") != null) {
                buildNumber = (String)this.bundleContext.getBundle().getHeaders().get("Implementation-Build");
            }
            String timestamp = "n/a";
            if (this.bundleContext.getBundle().getHeaders().get("Implementation-TimeStamp") != null) {
                timestamp = (String)this.bundleContext.getBundle().getHeaders().get("Implementation-TimeStamp");
            }
            String versionMessage = "  " + this.bundleContext.getBundle().getVersion().toString() + "  Build:" + buildNumber + "  Timestamp:" + timestamp;
            System.out.println(versionMessage);
            System.out.println("--------------------------------------------------------------------------");
            System.out.println("Successfully started " + this.requiredBundles.size() + " bundles and " + this.requiredServicesFilters.size() + " required services in " + totalStartupTime + " ms");
            logger.info("Apache Unomi version: {}", (Object)versionMessage);
            logger.info("Apache Unomi successfully started {} bundles and {} required services in {} ms", new Object[]{this.requiredBundles.size(), this.requiredServicesFilters.size(), totalStartupTime});
            this.startupMessageAlreadyDisplayed = true;
            this.shutdownMessageAlreadyDisplayed = false;
        }
    }

    public boolean isStartupComplete() {
        return this.allBundleStarted() && this.matchedRequiredServicesCount == (long)this.requiredServicesFilters.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLogo() {
        URL logoURL = this.bundleContext.getBundle().getResource("logo.txt");
        if (logoURL != null) {
            BufferedReader bufferedReader = null;
            try {
                String line;
                bufferedReader = new BufferedReader(new InputStreamReader(logoURL.openStream()));
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.trim().startsWith("#")) continue;
                    this.logoLines.add(line);
                }
            }
            catch (IOException e) {
                logger.error("Error loading logo lines", (Throwable)e);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

