/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.keys;

import java.nio.file.Path;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.client.config.keys.ClientIdentitiesWatcher;
import org.apache.sshd.client.config.keys.ClientIdentity;
import org.apache.sshd.client.config.keys.ClientIdentityLoader;
import org.apache.sshd.client.config.keys.ClientIdentityLoaderHolder;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.BuiltinIdentities;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.FilePasswordProviderHolder;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;

public class BuiltinClientIdentitiesWatcher
extends ClientIdentitiesWatcher {
    private final boolean supportedOnly;

    public BuiltinClientIdentitiesWatcher(Path keysFolder, boolean supportedOnly, ClientIdentityLoader loader, FilePasswordProvider provider, boolean strict) {
        this(keysFolder, NamedResource.getNameList(BuiltinIdentities.VALUES), supportedOnly, loader, provider, strict);
    }

    public BuiltinClientIdentitiesWatcher(Path keysFolder, Collection<String> ids, boolean supportedOnly, ClientIdentityLoader loader, FilePasswordProvider provider, boolean strict) {
        this(keysFolder, ids, supportedOnly, ClientIdentityLoaderHolder.loaderHolderOf(Objects.requireNonNull(loader, "No client identity loader")), FilePasswordProviderHolder.providerHolderOf(Objects.requireNonNull(provider, "No password provider")), strict);
    }

    public BuiltinClientIdentitiesWatcher(Path keysFolder, boolean supportedOnly, ClientIdentityLoaderHolder loader, FilePasswordProviderHolder provider, boolean strict) {
        this(keysFolder, NamedResource.getNameList(BuiltinIdentities.VALUES), supportedOnly, loader, provider, strict);
    }

    public BuiltinClientIdentitiesWatcher(Path keysFolder, Collection<String> ids, boolean supportedOnly, ClientIdentityLoaderHolder loader, FilePasswordProviderHolder provider, boolean strict) {
        super(BuiltinClientIdentitiesWatcher.getBuiltinIdentitiesPaths(keysFolder, ids), loader, provider, strict);
        this.supportedOnly = supportedOnly;
    }

    public final boolean isSupportedOnly() {
        return this.supportedOnly;
    }

    @Override
    public Iterable<KeyPair> loadKeys(SessionContext session) {
        return this.isSupportedOnly() ? this.loadKeys(session, p -> this.isSupported(session, (KeyPair)p)) : super.loadKeys(session);
    }

    protected boolean isSupported(SessionContext session, KeyPair kp) {
        BuiltinIdentities id = BuiltinIdentities.fromKeyPair(kp);
        if (id != null && id.isSupported()) {
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("loadKeys - remove unsupported identity={}, key-type={}, key={}", new Object[]{id, KeyUtils.getKeyType(kp), KeyUtils.getFingerPrint(kp.getPublic())});
        }
        return false;
    }

    public static List<Path> getDefaultBuiltinIdentitiesPaths(Path keysFolder) {
        return BuiltinClientIdentitiesWatcher.getBuiltinIdentitiesPaths(keysFolder, NamedResource.getNameList(BuiltinIdentities.VALUES));
    }

    public static List<Path> getBuiltinIdentitiesPaths(Path keysFolder, Collection<String> ids) {
        Objects.requireNonNull(keysFolder, "No keys folder");
        if (GenericUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        ArrayList<Path> paths = new ArrayList<Path>(ids.size());
        for (String id : ids) {
            String fileName = ClientIdentity.getIdentityFileName(id);
            paths.add(keysFolder.resolve(fileName));
        }
        return paths;
    }
}

