/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.settings.def;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IComponentAwareEventSink;
import org.apache.wicket.IDetachListener;
import org.apache.wicket.IEventDispatcher;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.serialize.java.JavaSerializer;
import org.apache.wicket.settings.IFrameworkSettings;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class FrameworkSettings
implements IFrameworkSettings {
    private IDetachListener detachListener;
    private List<IEventDispatcher> eventDispatchers = null;
    private ISerializer pageSerializer;

    public FrameworkSettings(Application application) {
        this.pageSerializer = new JavaSerializer(application.getApplicationKey());
    }

    @Override
    public String getVersion() {
        String implVersion = null;
        Package pkg = this.getClass().getPackage();
        if (pkg != null) {
            implVersion = pkg.getImplementationVersion();
        }
        return Strings.isEmpty(implVersion) ? "n/a" : implVersion;
    }

    @Override
    public IDetachListener getDetachListener() {
        return this.detachListener;
    }

    @Override
    public void setDetachListener(IDetachListener detachListener) {
        this.detachListener = detachListener;
    }

    @Override
    public void add(IEventDispatcher dispatcher) {
        Args.notNull((Object)dispatcher, (String)"dispatcher");
        if (this.eventDispatchers == null) {
            this.eventDispatchers = new ArrayList<IEventDispatcher>();
        }
        if (!this.eventDispatchers.contains(dispatcher)) {
            this.eventDispatchers.add(dispatcher);
        }
    }

    @Override
    public void dispatchEvent(Object sink, IEvent<?> event, Component component) {
        if (component != null && sink instanceof IComponentAwareEventSink) {
            ((IComponentAwareEventSink)sink).onEvent(component, event);
        } else if (sink instanceof IEventSink) {
            ((IEventSink)sink).onEvent(event);
        }
        if (this.eventDispatchers == null) {
            return;
        }
        for (IEventDispatcher dispatcher : this.eventDispatchers) {
            dispatcher.dispatchEvent(sink, event, component);
        }
    }

    @Override
    public void setSerializer(ISerializer pageSerializer) {
        this.pageSerializer = (ISerializer)Args.notNull((Object)pageSerializer, (String)"pageSerializer");
    }

    @Override
    public ISerializer getSerializer() {
        return this.pageSerializer;
    }
}

