/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
#include "messaging_events_types.h"

#include <algorithm>
#include <ostream>

#include <thrift/TToString.h>

namespace apache { namespace airavata { namespace model { namespace messaging { namespace event {

int _kMessageLevelValues[] = {
  MessageLevel::INFO,
  MessageLevel::DEBUG,
  MessageLevel::ERROR,
  MessageLevel::ACK
};
const char* _kMessageLevelNames[] = {
  "INFO",
  "DEBUG",
  "ERROR",
  "ACK"
};
const std::map<int, const char*> _MessageLevel_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(4, _kMessageLevelValues, _kMessageLevelNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kMessageTypeValues[] = {
  MessageType::EXPERIMENT,
  MessageType::EXPERIMENT_CANCEL,
  MessageType::TASK,
  MessageType::PROCESS,
  MessageType::JOB,
  MessageType::LAUNCHPROCESS,
  MessageType::TERMINATEPROCESS,
  MessageType::PROCESSOUTPUT,
  MessageType::DB_EVENT
};
const char* _kMessageTypeNames[] = {
  "EXPERIMENT",
  "EXPERIMENT_CANCEL",
  "TASK",
  "PROCESS",
  "JOB",
  "LAUNCHPROCESS",
  "TERMINATEPROCESS",
  "PROCESSOUTPUT",
  "DB_EVENT"
};
const std::map<int, const char*> _MessageType_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(9, _kMessageTypeValues, _kMessageTypeNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));


ExperimentStatusChangeEvent::~ExperimentStatusChangeEvent() throw() {
}


void ExperimentStatusChangeEvent::__set_state(const  ::apache::airavata::model::status::ExperimentState::type val) {
  this->state = val;
}

void ExperimentStatusChangeEvent::__set_experimentId(const std::string& val) {
  this->experimentId = val;
}

void ExperimentStatusChangeEvent::__set_gatewayId(const std::string& val) {
  this->gatewayId = val;
}

uint32_t ExperimentStatusChangeEvent::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_state = false;
  bool isset_experimentId = false;
  bool isset_gatewayId = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast0;
          xfer += iprot->readI32(ecast0);
          this->state = ( ::apache::airavata::model::status::ExperimentState::type)ecast0;
          isset_state = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->experimentId);
          isset_experimentId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gatewayId);
          isset_gatewayId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_state)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_experimentId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_gatewayId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ExperimentStatusChangeEvent::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("ExperimentStatusChangeEvent");

  xfer += oprot->writeFieldBegin("state", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32((int32_t)this->state);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("experimentId", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->experimentId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("gatewayId", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->gatewayId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ExperimentStatusChangeEvent &a, ExperimentStatusChangeEvent &b) {
  using ::std::swap;
  swap(a.state, b.state);
  swap(a.experimentId, b.experimentId);
  swap(a.gatewayId, b.gatewayId);
}

ExperimentStatusChangeEvent::ExperimentStatusChangeEvent(const ExperimentStatusChangeEvent& other1) {
  state = other1.state;
  experimentId = other1.experimentId;
  gatewayId = other1.gatewayId;
}
ExperimentStatusChangeEvent& ExperimentStatusChangeEvent::operator=(const ExperimentStatusChangeEvent& other2) {
  state = other2.state;
  experimentId = other2.experimentId;
  gatewayId = other2.gatewayId;
  return *this;
}
void ExperimentStatusChangeEvent::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ExperimentStatusChangeEvent(";
  out << "state=" << to_string(state);
  out << ", " << "experimentId=" << to_string(experimentId);
  out << ", " << "gatewayId=" << to_string(gatewayId);
  out << ")";
}


ProcessIdentifier::~ProcessIdentifier() throw() {
}


void ProcessIdentifier::__set_processId(const std::string& val) {
  this->processId = val;
}

void ProcessIdentifier::__set_experimentId(const std::string& val) {
  this->experimentId = val;
}

void ProcessIdentifier::__set_gatewayId(const std::string& val) {
  this->gatewayId = val;
}

uint32_t ProcessIdentifier::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_processId = false;
  bool isset_experimentId = false;
  bool isset_gatewayId = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->processId);
          isset_processId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->experimentId);
          isset_experimentId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gatewayId);
          isset_gatewayId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_processId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_experimentId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_gatewayId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ProcessIdentifier::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("ProcessIdentifier");

  xfer += oprot->writeFieldBegin("processId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->processId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("experimentId", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->experimentId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("gatewayId", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->gatewayId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ProcessIdentifier &a, ProcessIdentifier &b) {
  using ::std::swap;
  swap(a.processId, b.processId);
  swap(a.experimentId, b.experimentId);
  swap(a.gatewayId, b.gatewayId);
}

ProcessIdentifier::ProcessIdentifier(const ProcessIdentifier& other3) {
  processId = other3.processId;
  experimentId = other3.experimentId;
  gatewayId = other3.gatewayId;
}
ProcessIdentifier& ProcessIdentifier::operator=(const ProcessIdentifier& other4) {
  processId = other4.processId;
  experimentId = other4.experimentId;
  gatewayId = other4.gatewayId;
  return *this;
}
void ProcessIdentifier::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ProcessIdentifier(";
  out << "processId=" << to_string(processId);
  out << ", " << "experimentId=" << to_string(experimentId);
  out << ", " << "gatewayId=" << to_string(gatewayId);
  out << ")";
}


TaskIdentifier::~TaskIdentifier() throw() {
}


void TaskIdentifier::__set_taskId(const std::string& val) {
  this->taskId = val;
}

void TaskIdentifier::__set_processId(const std::string& val) {
  this->processId = val;
}

void TaskIdentifier::__set_experimentId(const std::string& val) {
  this->experimentId = val;
}

void TaskIdentifier::__set_gatewayId(const std::string& val) {
  this->gatewayId = val;
}

uint32_t TaskIdentifier::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_taskId = false;
  bool isset_processId = false;
  bool isset_experimentId = false;
  bool isset_gatewayId = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->taskId);
          isset_taskId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->processId);
          isset_processId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->experimentId);
          isset_experimentId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gatewayId);
          isset_gatewayId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_taskId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_processId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_experimentId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_gatewayId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t TaskIdentifier::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("TaskIdentifier");

  xfer += oprot->writeFieldBegin("taskId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->taskId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("processId", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->processId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("experimentId", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->experimentId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("gatewayId", ::apache::thrift::protocol::T_STRING, 4);
  xfer += oprot->writeString(this->gatewayId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(TaskIdentifier &a, TaskIdentifier &b) {
  using ::std::swap;
  swap(a.taskId, b.taskId);
  swap(a.processId, b.processId);
  swap(a.experimentId, b.experimentId);
  swap(a.gatewayId, b.gatewayId);
}

TaskIdentifier::TaskIdentifier(const TaskIdentifier& other5) {
  taskId = other5.taskId;
  processId = other5.processId;
  experimentId = other5.experimentId;
  gatewayId = other5.gatewayId;
}
TaskIdentifier& TaskIdentifier::operator=(const TaskIdentifier& other6) {
  taskId = other6.taskId;
  processId = other6.processId;
  experimentId = other6.experimentId;
  gatewayId = other6.gatewayId;
  return *this;
}
void TaskIdentifier::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "TaskIdentifier(";
  out << "taskId=" << to_string(taskId);
  out << ", " << "processId=" << to_string(processId);
  out << ", " << "experimentId=" << to_string(experimentId);
  out << ", " << "gatewayId=" << to_string(gatewayId);
  out << ")";
}


TaskStatusChangeEvent::~TaskStatusChangeEvent() throw() {
}


void TaskStatusChangeEvent::__set_state(const  ::apache::airavata::model::status::TaskState::type val) {
  this->state = val;
}

void TaskStatusChangeEvent::__set_taskIdentity(const TaskIdentifier& val) {
  this->taskIdentity = val;
}

uint32_t TaskStatusChangeEvent::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_state = false;
  bool isset_taskIdentity = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast7;
          xfer += iprot->readI32(ecast7);
          this->state = ( ::apache::airavata::model::status::TaskState::type)ecast7;
          isset_state = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->taskIdentity.read(iprot);
          isset_taskIdentity = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_state)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_taskIdentity)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t TaskStatusChangeEvent::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("TaskStatusChangeEvent");

  xfer += oprot->writeFieldBegin("state", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32((int32_t)this->state);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("taskIdentity", ::apache::thrift::protocol::T_STRUCT, 2);
  xfer += this->taskIdentity.write(oprot);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(TaskStatusChangeEvent &a, TaskStatusChangeEvent &b) {
  using ::std::swap;
  swap(a.state, b.state);
  swap(a.taskIdentity, b.taskIdentity);
}

TaskStatusChangeEvent::TaskStatusChangeEvent(const TaskStatusChangeEvent& other8) {
  state = other8.state;
  taskIdentity = other8.taskIdentity;
}
TaskStatusChangeEvent& TaskStatusChangeEvent::operator=(const TaskStatusChangeEvent& other9) {
  state = other9.state;
  taskIdentity = other9.taskIdentity;
  return *this;
}
void TaskStatusChangeEvent::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "TaskStatusChangeEvent(";
  out << "state=" << to_string(state);
  out << ", " << "taskIdentity=" << to_string(taskIdentity);
  out << ")";
}


TaskStatusChangeRequestEvent::~TaskStatusChangeRequestEvent() throw() {
}


void TaskStatusChangeRequestEvent::__set_state(const  ::apache::airavata::model::status::TaskState::type val) {
  this->state = val;
}

void TaskStatusChangeRequestEvent::__set_taskIdentity(const TaskIdentifier& val) {
  this->taskIdentity = val;
}

uint32_t TaskStatusChangeRequestEvent::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_state = false;
  bool isset_taskIdentity = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast10;
          xfer += iprot->readI32(ecast10);
          this->state = ( ::apache::airavata::model::status::TaskState::type)ecast10;
          isset_state = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->taskIdentity.read(iprot);
          isset_taskIdentity = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_state)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_taskIdentity)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t TaskStatusChangeRequestEvent::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("TaskStatusChangeRequestEvent");

  xfer += oprot->writeFieldBegin("state", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32((int32_t)this->state);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("taskIdentity", ::apache::thrift::protocol::T_STRUCT, 2);
  xfer += this->taskIdentity.write(oprot);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(TaskStatusChangeRequestEvent &a, TaskStatusChangeRequestEvent &b) {
  using ::std::swap;
  swap(a.state, b.state);
  swap(a.taskIdentity, b.taskIdentity);
}

TaskStatusChangeRequestEvent::TaskStatusChangeRequestEvent(const TaskStatusChangeRequestEvent& other11) {
  state = other11.state;
  taskIdentity = other11.taskIdentity;
}
TaskStatusChangeRequestEvent& TaskStatusChangeRequestEvent::operator=(const TaskStatusChangeRequestEvent& other12) {
  state = other12.state;
  taskIdentity = other12.taskIdentity;
  return *this;
}
void TaskStatusChangeRequestEvent::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "TaskStatusChangeRequestEvent(";
  out << "state=" << to_string(state);
  out << ", " << "taskIdentity=" << to_string(taskIdentity);
  out << ")";
}


ProcessStatusChangeEvent::~ProcessStatusChangeEvent() throw() {
}


void ProcessStatusChangeEvent::__set_state(const  ::apache::airavata::model::status::ProcessState::type val) {
  this->state = val;
}

void ProcessStatusChangeEvent::__set_processIdentity(const ProcessIdentifier& val) {
  this->processIdentity = val;
}

uint32_t ProcessStatusChangeEvent::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_state = false;
  bool isset_processIdentity = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast13;
          xfer += iprot->readI32(ecast13);
          this->state = ( ::apache::airavata::model::status::ProcessState::type)ecast13;
          isset_state = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->processIdentity.read(iprot);
          isset_processIdentity = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_state)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_processIdentity)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ProcessStatusChangeEvent::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("ProcessStatusChangeEvent");

  xfer += oprot->writeFieldBegin("state", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32((int32_t)this->state);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("processIdentity", ::apache::thrift::protocol::T_STRUCT, 2);
  xfer += this->processIdentity.write(oprot);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ProcessStatusChangeEvent &a, ProcessStatusChangeEvent &b) {
  using ::std::swap;
  swap(a.state, b.state);
  swap(a.processIdentity, b.processIdentity);
}

ProcessStatusChangeEvent::ProcessStatusChangeEvent(const ProcessStatusChangeEvent& other14) {
  state = other14.state;
  processIdentity = other14.processIdentity;
}
ProcessStatusChangeEvent& ProcessStatusChangeEvent::operator=(const ProcessStatusChangeEvent& other15) {
  state = other15.state;
  processIdentity = other15.processIdentity;
  return *this;
}
void ProcessStatusChangeEvent::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ProcessStatusChangeEvent(";
  out << "state=" << to_string(state);
  out << ", " << "processIdentity=" << to_string(processIdentity);
  out << ")";
}


ProcessStatusChangeRequestEvent::~ProcessStatusChangeRequestEvent() throw() {
}


void ProcessStatusChangeRequestEvent::__set_state(const  ::apache::airavata::model::status::ProcessState::type val) {
  this->state = val;
}

void ProcessStatusChangeRequestEvent::__set_processIdentity(const ProcessIdentifier& val) {
  this->processIdentity = val;
}

uint32_t ProcessStatusChangeRequestEvent::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_state = false;
  bool isset_processIdentity = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast16;
          xfer += iprot->readI32(ecast16);
          this->state = ( ::apache::airavata::model::status::ProcessState::type)ecast16;
          isset_state = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->processIdentity.read(iprot);
          isset_processIdentity = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_state)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_processIdentity)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ProcessStatusChangeRequestEvent::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("ProcessStatusChangeRequestEvent");

  xfer += oprot->writeFieldBegin("state", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32((int32_t)this->state);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("processIdentity", ::apache::thrift::protocol::T_STRUCT, 2);
  xfer += this->processIdentity.write(oprot);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ProcessStatusChangeRequestEvent &a, ProcessStatusChangeRequestEvent &b) {
  using ::std::swap;
  swap(a.state, b.state);
  swap(a.processIdentity, b.processIdentity);
}

ProcessStatusChangeRequestEvent::ProcessStatusChangeRequestEvent(const ProcessStatusChangeRequestEvent& other17) {
  state = other17.state;
  processIdentity = other17.processIdentity;
}
ProcessStatusChangeRequestEvent& ProcessStatusChangeRequestEvent::operator=(const ProcessStatusChangeRequestEvent& other18) {
  state = other18.state;
  processIdentity = other18.processIdentity;
  return *this;
}
void ProcessStatusChangeRequestEvent::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ProcessStatusChangeRequestEvent(";
  out << "state=" << to_string(state);
  out << ", " << "processIdentity=" << to_string(processIdentity);
  out << ")";
}


TaskOutputChangeEvent::~TaskOutputChangeEvent() throw() {
}


void TaskOutputChangeEvent::__set_output(const std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> & val) {
  this->output = val;
}

void TaskOutputChangeEvent::__set_taskIdentity(const TaskIdentifier& val) {
  this->taskIdentity = val;
}

uint32_t TaskOutputChangeEvent::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_output = false;
  bool isset_taskIdentity = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->output.clear();
            uint32_t _size19;
            ::apache::thrift::protocol::TType _etype22;
            xfer += iprot->readListBegin(_etype22, _size19);
            this->output.resize(_size19);
            uint32_t _i23;
            for (_i23 = 0; _i23 < _size19; ++_i23)
            {
              xfer += this->output[_i23].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          isset_output = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->taskIdentity.read(iprot);
          isset_taskIdentity = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_output)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_taskIdentity)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t TaskOutputChangeEvent::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("TaskOutputChangeEvent");

  xfer += oprot->writeFieldBegin("output", ::apache::thrift::protocol::T_LIST, 1);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->output.size()));
    std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> ::const_iterator _iter24;
    for (_iter24 = this->output.begin(); _iter24 != this->output.end(); ++_iter24)
    {
      xfer += (*_iter24).write(oprot);
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("taskIdentity", ::apache::thrift::protocol::T_STRUCT, 2);
  xfer += this->taskIdentity.write(oprot);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(TaskOutputChangeEvent &a, TaskOutputChangeEvent &b) {
  using ::std::swap;
  swap(a.output, b.output);
  swap(a.taskIdentity, b.taskIdentity);
}

TaskOutputChangeEvent::TaskOutputChangeEvent(const TaskOutputChangeEvent& other25) {
  output = other25.output;
  taskIdentity = other25.taskIdentity;
}
TaskOutputChangeEvent& TaskOutputChangeEvent::operator=(const TaskOutputChangeEvent& other26) {
  output = other26.output;
  taskIdentity = other26.taskIdentity;
  return *this;
}
void TaskOutputChangeEvent::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "TaskOutputChangeEvent(";
  out << "output=" << to_string(output);
  out << ", " << "taskIdentity=" << to_string(taskIdentity);
  out << ")";
}


JobIdentifier::~JobIdentifier() throw() {
}


void JobIdentifier::__set_jobId(const std::string& val) {
  this->jobId = val;
}

void JobIdentifier::__set_taskId(const std::string& val) {
  this->taskId = val;
}

void JobIdentifier::__set_processId(const std::string& val) {
  this->processId = val;
}

void JobIdentifier::__set_experimentId(const std::string& val) {
  this->experimentId = val;
}

void JobIdentifier::__set_gatewayId(const std::string& val) {
  this->gatewayId = val;
}

uint32_t JobIdentifier::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_jobId = false;
  bool isset_taskId = false;
  bool isset_processId = false;
  bool isset_experimentId = false;
  bool isset_gatewayId = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->jobId);
          isset_jobId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->taskId);
          isset_taskId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->processId);
          isset_processId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->experimentId);
          isset_experimentId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gatewayId);
          isset_gatewayId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_jobId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_taskId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_processId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_experimentId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_gatewayId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t JobIdentifier::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("JobIdentifier");

  xfer += oprot->writeFieldBegin("jobId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->jobId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("taskId", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->taskId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("processId", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->processId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("experimentId", ::apache::thrift::protocol::T_STRING, 4);
  xfer += oprot->writeString(this->experimentId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("gatewayId", ::apache::thrift::protocol::T_STRING, 5);
  xfer += oprot->writeString(this->gatewayId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(JobIdentifier &a, JobIdentifier &b) {
  using ::std::swap;
  swap(a.jobId, b.jobId);
  swap(a.taskId, b.taskId);
  swap(a.processId, b.processId);
  swap(a.experimentId, b.experimentId);
  swap(a.gatewayId, b.gatewayId);
}

JobIdentifier::JobIdentifier(const JobIdentifier& other27) {
  jobId = other27.jobId;
  taskId = other27.taskId;
  processId = other27.processId;
  experimentId = other27.experimentId;
  gatewayId = other27.gatewayId;
}
JobIdentifier& JobIdentifier::operator=(const JobIdentifier& other28) {
  jobId = other28.jobId;
  taskId = other28.taskId;
  processId = other28.processId;
  experimentId = other28.experimentId;
  gatewayId = other28.gatewayId;
  return *this;
}
void JobIdentifier::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "JobIdentifier(";
  out << "jobId=" << to_string(jobId);
  out << ", " << "taskId=" << to_string(taskId);
  out << ", " << "processId=" << to_string(processId);
  out << ", " << "experimentId=" << to_string(experimentId);
  out << ", " << "gatewayId=" << to_string(gatewayId);
  out << ")";
}


ExperimentSubmitEvent::~ExperimentSubmitEvent() throw() {
}


void ExperimentSubmitEvent::__set_experimentId(const std::string& val) {
  this->experimentId = val;
}

void ExperimentSubmitEvent::__set_gatewayId(const std::string& val) {
  this->gatewayId = val;
}

uint32_t ExperimentSubmitEvent::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_experimentId = false;
  bool isset_gatewayId = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->experimentId);
          isset_experimentId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gatewayId);
          isset_gatewayId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_experimentId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_gatewayId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ExperimentSubmitEvent::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("ExperimentSubmitEvent");

  xfer += oprot->writeFieldBegin("experimentId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->experimentId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("gatewayId", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->gatewayId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ExperimentSubmitEvent &a, ExperimentSubmitEvent &b) {
  using ::std::swap;
  swap(a.experimentId, b.experimentId);
  swap(a.gatewayId, b.gatewayId);
}

ExperimentSubmitEvent::ExperimentSubmitEvent(const ExperimentSubmitEvent& other29) {
  experimentId = other29.experimentId;
  gatewayId = other29.gatewayId;
}
ExperimentSubmitEvent& ExperimentSubmitEvent::operator=(const ExperimentSubmitEvent& other30) {
  experimentId = other30.experimentId;
  gatewayId = other30.gatewayId;
  return *this;
}
void ExperimentSubmitEvent::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ExperimentSubmitEvent(";
  out << "experimentId=" << to_string(experimentId);
  out << ", " << "gatewayId=" << to_string(gatewayId);
  out << ")";
}


ProcessSubmitEvent::~ProcessSubmitEvent() throw() {
}


void ProcessSubmitEvent::__set_processId(const std::string& val) {
  this->processId = val;
}

void ProcessSubmitEvent::__set_gatewayId(const std::string& val) {
  this->gatewayId = val;
}

void ProcessSubmitEvent::__set_experimentId(const std::string& val) {
  this->experimentId = val;
}

void ProcessSubmitEvent::__set_tokenId(const std::string& val) {
  this->tokenId = val;
}

uint32_t ProcessSubmitEvent::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_processId = false;
  bool isset_gatewayId = false;
  bool isset_experimentId = false;
  bool isset_tokenId = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->processId);
          isset_processId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gatewayId);
          isset_gatewayId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->experimentId);
          isset_experimentId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->tokenId);
          isset_tokenId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_processId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_gatewayId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_experimentId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_tokenId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ProcessSubmitEvent::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("ProcessSubmitEvent");

  xfer += oprot->writeFieldBegin("processId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->processId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("gatewayId", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->gatewayId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("experimentId", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->experimentId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("tokenId", ::apache::thrift::protocol::T_STRING, 4);
  xfer += oprot->writeString(this->tokenId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ProcessSubmitEvent &a, ProcessSubmitEvent &b) {
  using ::std::swap;
  swap(a.processId, b.processId);
  swap(a.gatewayId, b.gatewayId);
  swap(a.experimentId, b.experimentId);
  swap(a.tokenId, b.tokenId);
}

ProcessSubmitEvent::ProcessSubmitEvent(const ProcessSubmitEvent& other31) {
  processId = other31.processId;
  gatewayId = other31.gatewayId;
  experimentId = other31.experimentId;
  tokenId = other31.tokenId;
}
ProcessSubmitEvent& ProcessSubmitEvent::operator=(const ProcessSubmitEvent& other32) {
  processId = other32.processId;
  gatewayId = other32.gatewayId;
  experimentId = other32.experimentId;
  tokenId = other32.tokenId;
  return *this;
}
void ProcessSubmitEvent::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ProcessSubmitEvent(";
  out << "processId=" << to_string(processId);
  out << ", " << "gatewayId=" << to_string(gatewayId);
  out << ", " << "experimentId=" << to_string(experimentId);
  out << ", " << "tokenId=" << to_string(tokenId);
  out << ")";
}


ProcessTerminateEvent::~ProcessTerminateEvent() throw() {
}


void ProcessTerminateEvent::__set_processId(const std::string& val) {
  this->processId = val;
}

void ProcessTerminateEvent::__set_gatewayId(const std::string& val) {
  this->gatewayId = val;
}

void ProcessTerminateEvent::__set_tokenId(const std::string& val) {
  this->tokenId = val;
}

uint32_t ProcessTerminateEvent::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_processId = false;
  bool isset_gatewayId = false;
  bool isset_tokenId = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->processId);
          isset_processId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gatewayId);
          isset_gatewayId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->tokenId);
          isset_tokenId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_processId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_gatewayId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_tokenId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ProcessTerminateEvent::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("ProcessTerminateEvent");

  xfer += oprot->writeFieldBegin("processId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->processId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("gatewayId", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->gatewayId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("tokenId", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->tokenId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ProcessTerminateEvent &a, ProcessTerminateEvent &b) {
  using ::std::swap;
  swap(a.processId, b.processId);
  swap(a.gatewayId, b.gatewayId);
  swap(a.tokenId, b.tokenId);
}

ProcessTerminateEvent::ProcessTerminateEvent(const ProcessTerminateEvent& other33) {
  processId = other33.processId;
  gatewayId = other33.gatewayId;
  tokenId = other33.tokenId;
}
ProcessTerminateEvent& ProcessTerminateEvent::operator=(const ProcessTerminateEvent& other34) {
  processId = other34.processId;
  gatewayId = other34.gatewayId;
  tokenId = other34.tokenId;
  return *this;
}
void ProcessTerminateEvent::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ProcessTerminateEvent(";
  out << "processId=" << to_string(processId);
  out << ", " << "gatewayId=" << to_string(gatewayId);
  out << ", " << "tokenId=" << to_string(tokenId);
  out << ")";
}


JobStatusChangeEvent::~JobStatusChangeEvent() throw() {
}


void JobStatusChangeEvent::__set_state(const  ::apache::airavata::model::status::JobState::type val) {
  this->state = val;
}

void JobStatusChangeEvent::__set_jobIdentity(const JobIdentifier& val) {
  this->jobIdentity = val;
}

uint32_t JobStatusChangeEvent::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_state = false;
  bool isset_jobIdentity = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast35;
          xfer += iprot->readI32(ecast35);
          this->state = ( ::apache::airavata::model::status::JobState::type)ecast35;
          isset_state = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->jobIdentity.read(iprot);
          isset_jobIdentity = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_state)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_jobIdentity)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t JobStatusChangeEvent::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("JobStatusChangeEvent");

  xfer += oprot->writeFieldBegin("state", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32((int32_t)this->state);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("jobIdentity", ::apache::thrift::protocol::T_STRUCT, 2);
  xfer += this->jobIdentity.write(oprot);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(JobStatusChangeEvent &a, JobStatusChangeEvent &b) {
  using ::std::swap;
  swap(a.state, b.state);
  swap(a.jobIdentity, b.jobIdentity);
}

JobStatusChangeEvent::JobStatusChangeEvent(const JobStatusChangeEvent& other36) {
  state = other36.state;
  jobIdentity = other36.jobIdentity;
}
JobStatusChangeEvent& JobStatusChangeEvent::operator=(const JobStatusChangeEvent& other37) {
  state = other37.state;
  jobIdentity = other37.jobIdentity;
  return *this;
}
void JobStatusChangeEvent::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "JobStatusChangeEvent(";
  out << "state=" << to_string(state);
  out << ", " << "jobIdentity=" << to_string(jobIdentity);
  out << ")";
}


JobStatusChangeRequestEvent::~JobStatusChangeRequestEvent() throw() {
}


void JobStatusChangeRequestEvent::__set_state(const  ::apache::airavata::model::status::JobState::type val) {
  this->state = val;
}

void JobStatusChangeRequestEvent::__set_jobIdentity(const JobIdentifier& val) {
  this->jobIdentity = val;
}

uint32_t JobStatusChangeRequestEvent::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_state = false;
  bool isset_jobIdentity = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast38;
          xfer += iprot->readI32(ecast38);
          this->state = ( ::apache::airavata::model::status::JobState::type)ecast38;
          isset_state = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->jobIdentity.read(iprot);
          isset_jobIdentity = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_state)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_jobIdentity)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t JobStatusChangeRequestEvent::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("JobStatusChangeRequestEvent");

  xfer += oprot->writeFieldBegin("state", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32((int32_t)this->state);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("jobIdentity", ::apache::thrift::protocol::T_STRUCT, 2);
  xfer += this->jobIdentity.write(oprot);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(JobStatusChangeRequestEvent &a, JobStatusChangeRequestEvent &b) {
  using ::std::swap;
  swap(a.state, b.state);
  swap(a.jobIdentity, b.jobIdentity);
}

JobStatusChangeRequestEvent::JobStatusChangeRequestEvent(const JobStatusChangeRequestEvent& other39) {
  state = other39.state;
  jobIdentity = other39.jobIdentity;
}
JobStatusChangeRequestEvent& JobStatusChangeRequestEvent::operator=(const JobStatusChangeRequestEvent& other40) {
  state = other40.state;
  jobIdentity = other40.jobIdentity;
  return *this;
}
void JobStatusChangeRequestEvent::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "JobStatusChangeRequestEvent(";
  out << "state=" << to_string(state);
  out << ", " << "jobIdentity=" << to_string(jobIdentity);
  out << ")";
}


Message::~Message() throw() {
}


void Message::__set_event(const std::string& val) {
  this->event = val;
}

void Message::__set_messageId(const std::string& val) {
  this->messageId = val;
}

void Message::__set_messageType(const MessageType::type val) {
  this->messageType = val;
}

void Message::__set_updatedTime(const int64_t val) {
  this->updatedTime = val;
__isset.updatedTime = true;
}

void Message::__set_messageLevel(const MessageLevel::type val) {
  this->messageLevel = val;
__isset.messageLevel = true;
}

uint32_t Message::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_event = false;
  bool isset_messageId = false;
  bool isset_messageType = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readBinary(this->event);
          isset_event = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->messageId);
          isset_messageId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast41;
          xfer += iprot->readI32(ecast41);
          this->messageType = (MessageType::type)ecast41;
          isset_messageType = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->updatedTime);
          this->__isset.updatedTime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast42;
          xfer += iprot->readI32(ecast42);
          this->messageLevel = (MessageLevel::type)ecast42;
          this->__isset.messageLevel = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_event)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_messageId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_messageType)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t Message::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("Message");

  xfer += oprot->writeFieldBegin("event", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeBinary(this->event);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("messageId", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->messageId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("messageType", ::apache::thrift::protocol::T_I32, 3);
  xfer += oprot->writeI32((int32_t)this->messageType);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.updatedTime) {
    xfer += oprot->writeFieldBegin("updatedTime", ::apache::thrift::protocol::T_I64, 4);
    xfer += oprot->writeI64(this->updatedTime);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.messageLevel) {
    xfer += oprot->writeFieldBegin("messageLevel", ::apache::thrift::protocol::T_I32, 5);
    xfer += oprot->writeI32((int32_t)this->messageLevel);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(Message &a, Message &b) {
  using ::std::swap;
  swap(a.event, b.event);
  swap(a.messageId, b.messageId);
  swap(a.messageType, b.messageType);
  swap(a.updatedTime, b.updatedTime);
  swap(a.messageLevel, b.messageLevel);
  swap(a.__isset, b.__isset);
}

Message::Message(const Message& other43) {
  event = other43.event;
  messageId = other43.messageId;
  messageType = other43.messageType;
  updatedTime = other43.updatedTime;
  messageLevel = other43.messageLevel;
  __isset = other43.__isset;
}
Message& Message::operator=(const Message& other44) {
  event = other44.event;
  messageId = other44.messageId;
  messageType = other44.messageType;
  updatedTime = other44.updatedTime;
  messageLevel = other44.messageLevel;
  __isset = other44.__isset;
  return *this;
}
void Message::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "Message(";
  out << "event=" << to_string(event);
  out << ", " << "messageId=" << to_string(messageId);
  out << ", " << "messageType=" << to_string(messageType);
  out << ", " << "updatedTime="; (__isset.updatedTime ? (out << to_string(updatedTime)) : (out << "<null>"));
  out << ", " << "messageLevel="; (__isset.messageLevel ? (out << to_string(messageLevel)) : (out << "<null>"));
  out << ")";
}

}}}}} // namespace
