/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.ssl;

import com.hazelcast.nio.DefaultSocketChannelWrapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class SSLSocketChannelWrapper
extends DefaultSocketChannelWrapper {
    private final ByteBuffer in;
    private final ByteBuffer out;
    private final ByteBuffer cTOs;
    private final ByteBuffer sTOc;
    private final SSLEngine sslEngine;
    private SSLEngineResult sslEngineResult;

    public SSLSocketChannelWrapper(SSLContext sslContext, SocketChannel sc, boolean client) throws Exception {
        super(sc);
        this.sslEngine = sslContext.createSSLEngine();
        this.sslEngine.setUseClientMode(client);
        this.sslEngine.setEnableSessionCreation(true);
        SSLSession session = this.sslEngine.getSession();
        this.in = ByteBuffer.allocate(65536);
        int appBufferMax = session.getApplicationBufferSize();
        int netBufferMax = session.getPacketBufferSize();
        this.out = ByteBuffer.allocate(appBufferMax);
        this.cTOs = ByteBuffer.allocate(netBufferMax);
        this.sTOc = ByteBuffer.allocate(netBufferMax);
        this.write(this.out);
        while (this.sslEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) {
            if (this.sslEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                this.sTOc.clear();
                while (this.socketChannel.read(this.sTOc) < 1) {
                    Thread.sleep(50L);
                }
                this.sTOc.flip();
                this.unwrap(this.sTOc);
                if (this.sslEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) continue;
                this.out.clear();
                this.write(this.out);
                continue;
            }
            if (this.sslEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                this.out.clear();
                this.write(this.out);
                continue;
            }
            Thread.sleep(500L);
        }
        this.in.clear();
        this.in.flip();
    }

    private ByteBuffer unwrap(ByteBuffer b) throws SSLException {
        this.in.clear();
        while (b.hasRemaining()) {
            this.sslEngineResult = this.sslEngine.unwrap(b, this.in);
            if (this.sslEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                Runnable task;
                while ((task = this.sslEngine.getDelegatedTask()) != null) {
                    task.run();
                }
                continue;
            }
            if (this.sslEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED && this.sslEngineResult.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
            return this.in;
        }
        return this.in;
    }

    @Override
    public int write(ByteBuffer input) throws IOException {
        this.sslEngineResult = this.sslEngine.wrap(input, this.cTOs);
        this.cTOs.flip();
        int written = this.socketChannel.write(this.cTOs);
        if (this.cTOs.hasRemaining()) {
            this.cTOs.compact();
        } else {
            this.cTOs.clear();
        }
        return written;
    }

    @Override
    public int read(ByteBuffer output) throws IOException {
        int i;
        int limit;
        int readBytesCount = 0;
        if (this.in.hasRemaining()) {
            int limit2 = Math.min(this.in.remaining(), output.remaining());
            for (int i2 = 0; i2 < limit2; ++i2) {
                output.put(this.in.get());
                ++readBytesCount;
            }
            return readBytesCount;
        }
        if (this.sTOc.hasRemaining()) {
            this.unwrap(this.sTOc);
            this.in.flip();
            limit = Math.min(this.in.limit(), output.remaining());
            for (i = 0; i < limit; ++i) {
                output.put(this.in.get());
                ++readBytesCount;
            }
            if (this.sslEngineResult.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                this.sTOc.clear();
                this.sTOc.flip();
                return readBytesCount;
            }
        }
        if (this.sTOc.hasRemaining()) {
            this.sTOc.compact();
        } else {
            this.sTOc.clear();
        }
        if (this.socketChannel.read(this.sTOc) == -1) {
            this.sTOc.clear();
            this.sTOc.flip();
            return -1;
        }
        this.sTOc.flip();
        this.unwrap(this.sTOc);
        this.in.flip();
        limit = Math.min(this.in.limit(), output.remaining());
        for (i = 0; i < limit; ++i) {
            output.put(this.in.get());
            ++readBytesCount;
        }
        return readBytesCount;
    }

    @Override
    public void close() throws IOException {
        this.sslEngine.closeOutbound();
        try {
            this.out.clear();
            this.write(this.out);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socketChannel.close();
    }

    @Override
    public long read(ByteBuffer[] byteBuffers, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long write(ByteBuffer[] byteBuffers, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }
}

