/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.controls.search.entryChange;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.LongDecoder;
import org.apache.directory.api.asn1.ber.tlv.LongDecoderException;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.controls.search.entryChange.EntryChangeContainer;
import org.apache.directory.api.ldap.codec.controls.search.entryChange.EntryChangeStates;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.controls.ChangeType;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntryChangeGrammar
extends AbstractGrammar<EntryChangeContainer> {
    static final Logger LOG = LoggerFactory.getLogger(EntryChangeGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<?> instance = new EntryChangeGrammar();

    private EntryChangeGrammar() {
        this.setName(EntryChangeGrammar.class.getName());
        this.transitions = new GrammarTransition[EntryChangeStates.LAST_EC_STATE.ordinal()][256];
        this.transitions[EntryChangeStates.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(EntryChangeStates.START_STATE, EntryChangeStates.EC_SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[EntryChangeStates.EC_SEQUENCE_STATE.ordinal()][UniversalTag.ENUMERATED.getValue()] = new GrammarTransition<EntryChangeContainer>(EntryChangeStates.EC_SEQUENCE_STATE, EntryChangeStates.CHANGE_TYPE_STATE, UniversalTag.ENUMERATED.getValue(), new GrammarAction<EntryChangeContainer>("Set EntryChangeControl changeType"){

            @Override
            public void action(EntryChangeContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    int change = IntegerDecoder.parse(value, 1, 8);
                    switch (ChangeType.getChangeType(change)) {
                        case ADD: 
                        case DELETE: 
                        case MODDN: 
                        case MODIFY: {
                            ChangeType changeType = ChangeType.getChangeType(change);
                            if (IS_DEBUG) {
                                LOG.debug("changeType = " + (Object)((Object)changeType));
                            }
                            container.getEntryChangeDecorator().setChangeType(changeType);
                            break;
                        }
                        default: {
                            String msg = I18n.err(I18n.ERR_04044, new Object[0]);
                            LOG.error(msg);
                            throw new DecoderException(msg);
                        }
                    }
                    container.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException ide) {
                    String msg = I18n.err(I18n.ERR_04044, new Object[0]);
                    LOG.error(msg, (Throwable)ide);
                    throw new DecoderException(msg, ide);
                }
                catch (IllegalArgumentException iae) {
                    throw new DecoderException(iae.getLocalizedMessage(), iae);
                }
            }
        });
        this.transitions[EntryChangeStates.CHANGE_TYPE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<EntryChangeContainer>(EntryChangeStates.CHANGE_TYPE_STATE, EntryChangeStates.PREVIOUS_DN_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<EntryChangeContainer>("Set EntryChangeControl previousDN"){

            @Override
            public void action(EntryChangeContainer container) throws DecoderException {
                Dn previousDn;
                ChangeType changeType = container.getEntryChangeDecorator().getChangeType();
                if (changeType != ChangeType.MODDN) {
                    LOG.error(I18n.err(I18n.ERR_04045, new Object[0]));
                    throw new DecoderException(I18n.err(I18n.ERR_04046, new Object[0]));
                }
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    previousDn = new Dn(Strings.utf8ToString(value.getData()));
                }
                catch (LdapInvalidDnException ine) {
                    LOG.error(I18n.err(I18n.ERR_04047, Strings.dumpBytes(value.getData())));
                    throw new DecoderException(I18n.err(I18n.ERR_04048, new Object[0]), ine);
                }
                if (IS_DEBUG) {
                    LOG.debug("previousDN = " + previousDn);
                }
                container.getEntryChangeDecorator().setPreviousDn(previousDn);
                container.setGrammarEndAllowed(true);
            }
        });
        GrammarAction<EntryChangeContainer> setChangeNumberAction = new GrammarAction<EntryChangeContainer>("Set EntryChangeControl changeNumber"){

            @Override
            public void action(EntryChangeContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    long changeNumber = LongDecoder.parse(value);
                    if (IS_DEBUG) {
                        LOG.debug("changeNumber = " + changeNumber);
                    }
                    container.getEntryChangeDecorator().setChangeNumber(changeNumber);
                    container.setGrammarEndAllowed(true);
                }
                catch (LongDecoderException lde) {
                    String msg = I18n.err(I18n.ERR_04049, new Object[0]);
                    LOG.error(msg, (Throwable)lde);
                    throw new DecoderException(msg, lde);
                }
            }
        };
        this.transitions[EntryChangeStates.PREVIOUS_DN_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition<EntryChangeContainer>(EntryChangeStates.PREVIOUS_DN_STATE, EntryChangeStates.CHANGE_NUMBER_STATE, UniversalTag.INTEGER.getValue(), setChangeNumberAction);
        this.transitions[EntryChangeStates.CHANGE_TYPE_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition<EntryChangeContainer>(EntryChangeStates.CHANGE_TYPE_STATE, EntryChangeStates.CHANGE_NUMBER_STATE, UniversalTag.INTEGER.getValue(), setChangeNumberAction);
    }

    public static Grammar<?> getInstance() {
        return instance;
    }
}

