/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.dbcp.AbandonedTrace;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingResultSet;

public class DelegatingStatement
extends AbandonedTrace
implements Statement {
    protected Statement _stmt = null;
    protected DelegatingConnection _conn = null;
    protected boolean _closed = false;

    public DelegatingStatement(DelegatingConnection c, Statement s) {
        super(c);
        this._stmt = s;
        this._conn = c;
    }

    public Statement getDelegate() {
        return this._stmt;
    }

    public boolean equals(Object obj) {
        Statement delegate = this.getInnermostDelegate();
        if (delegate == null) {
            return false;
        }
        if (obj instanceof DelegatingStatement) {
            DelegatingStatement s = (DelegatingStatement)obj;
            return delegate.equals(s.getInnermostDelegate());
        }
        return delegate.equals(obj);
    }

    public int hashCode() {
        Statement obj = this.getInnermostDelegate();
        if (obj == null) {
            return 0;
        }
        return obj.hashCode();
    }

    public Statement getInnermostDelegate() {
        Statement s = this._stmt;
        while (s != null && s instanceof DelegatingStatement) {
            if (this != (s = ((DelegatingStatement)s).getDelegate())) continue;
            return null;
        }
        return s;
    }

    public void setDelegate(Statement s) {
        this._stmt = s;
    }

    protected void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(this.getClass().getName() + " with address: \"" + this.toString() + "\" is closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            try {
                List resultSets;
                if (this._conn != null) {
                    this._conn.removeTrace(this);
                    this._conn = null;
                }
                if ((resultSets = this.getTrace()) != null) {
                    ResultSet[] set = resultSets.toArray(new ResultSet[resultSets.size()]);
                    for (int i = 0; i < set.length; ++i) {
                        set[i].close();
                    }
                    this.clearTrace();
                }
                this._stmt.close();
            }
            catch (SQLException e) {
                this.handleException(e);
            }
        }
        finally {
            this._closed = true;
        }
    }

    protected void handleException(SQLException e) throws SQLException {
        if (this._conn == null) {
            throw e;
        }
        this._conn.handleException(e);
    }

    protected void activate() throws SQLException {
        if (this._stmt instanceof DelegatingStatement) {
            ((DelegatingStatement)this._stmt).activate();
        }
    }

    protected void passivate() throws SQLException {
        if (this._stmt instanceof DelegatingStatement) {
            ((DelegatingStatement)this._stmt).passivate();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkOpen();
        return this._conn;
    }

    @Override
    public ResultSet executeQuery(String sql2) throws SQLException {
        this.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this, this._stmt.executeQuery(sql2));
        }
        catch (SQLException e) {
            this.handleException(e);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this, this._stmt.getResultSet());
        }
        catch (SQLException e) {
            this.handleException(e);
            throw new AssertionError();
        }
    }

    @Override
    public int executeUpdate(String sql2) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.executeUpdate(sql2);
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getMaxFieldSize();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setMaxFieldSize(max);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getMaxRows();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setMaxRows(max);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setEscapeProcessing(enable);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getQueryTimeout();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setQueryTimeout(seconds);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public void cancel() throws SQLException {
        this.checkOpen();
        try {
            this._stmt.cancel();
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getWarnings();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw new AssertionError();
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
        try {
            this._stmt.clearWarnings();
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setCursorName(name);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public boolean execute(String sql2) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.execute(sql2);
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getUpdateCount();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getMoreResults();
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setFetchDirection(direction);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getFetchDirection();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setFetchSize(rows);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getFetchSize();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getResultSetConcurrency();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getResultSetType();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public void addBatch(String sql2) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.addBatch(sql2);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkOpen();
        try {
            this._stmt.clearBatch();
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.executeBatch();
        }
        catch (SQLException e) {
            this.handleException(e);
            throw new AssertionError();
        }
    }

    public String toString() {
        return this._stmt.toString();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getMoreResults(current);
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this, this._stmt.getGeneratedKeys());
        }
        catch (SQLException e) {
            this.handleException(e);
            throw new AssertionError();
        }
    }

    @Override
    public int executeUpdate(String sql2, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.executeUpdate(sql2, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public int executeUpdate(String sql2, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.executeUpdate(sql2, columnIndexes);
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public int executeUpdate(String sql2, String[] columnNames) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.executeUpdate(sql2, columnNames);
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public boolean execute(String sql2, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.execute(sql2, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public boolean execute(String sql2, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.execute(sql2, columnIndexes);
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public boolean execute(String sql2, String[] columnNames) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.execute(sql2, columnNames);
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getResultSetHoldability();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._closed;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass()) || this._stmt.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        if (iface.isAssignableFrom(this._stmt.getClass())) {
            return iface.cast(this._stmt);
        }
        return this._stmt.unwrap(iface);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setPoolable(poolable);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.isPoolable();
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }
}

