/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.client.samples;

import java.util.ArrayList;
import org.apache.airavata.api.Airavata;
import org.apache.airavata.api.client.AiravataClientFactory;
import org.apache.airavata.client.tools.RegisterSampleApplicationsUtils;
import org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionInterface;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionProtocol;
import org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission;
import org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager;
import org.apache.airavata.model.appcatalog.computeresource.ResourceJobManagerType;
import org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference;
import org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile;
import org.apache.airavata.model.application.io.DataType;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.application.io.OutputDataObjectType;
import org.apache.airavata.model.data.movement.DataMovementInterface;
import org.apache.airavata.model.data.movement.DataMovementProtocol;
import org.apache.airavata.model.error.AiravataClientException;
import org.apache.airavata.model.experiment.ExperimentModel;
import org.apache.airavata.model.experiment.UserConfigurationDataModel;
import org.apache.airavata.model.parallelism.ApplicationParallelismType;
import org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel;
import org.apache.airavata.model.security.AuthzToken;
import org.apache.airavata.model.workspace.Gateway;
import org.apache.airavata.model.workspace.GatewayApprovalStatus;
import org.apache.airavata.model.workspace.Project;
import org.apache.thrift.TException;

public class SampleEchoExperiment {
    private static final String THRIFT_SERVER_HOST = "127.0.0.1";
    private static final int THRIFT_SERVER_PORT = 8930;
    private Airavata.Client airavataClient;
    private String localhostId;
    private String echoModuleId;
    private String echoInterfaceId;
    private String echoExperimentId;
    private String gatewayId = "default";
    private String userId = "default-user";

    public static void main(String[] args) throws AiravataClientException, TException {
        SampleEchoExperiment sampleEchoExperiment = new SampleEchoExperiment();
        sampleEchoExperiment.register();
    }

    public void register() throws TException {
        this.airavataClient = AiravataClientFactory.createAiravataClient((String)THRIFT_SERVER_HOST, (int)8930);
        this.gatewayId = this.registerGateway();
        this.registerLocalhost();
        this.registerGatewayProfile();
        this.registerEchoModule();
        this.registerEchoDeployment();
        this.registerEchoInterface();
        this.createEchoExperiment();
    }

    private String registerGateway() throws TException {
        Gateway gateway = new Gateway();
        gateway.setGatewayName(this.gatewayId);
        gateway.setGatewayId(this.gatewayId);
        gateway.setGatewayApprovalStatus(GatewayApprovalStatus.APPROVED);
        return this.airavataClient.addGateway(new AuthzToken(""), gateway);
    }

    private void registerLocalhost() {
        try {
            System.out.println("\n #### Registering Localhost Computational Resource #### \n");
            ComputeResourceDescription computeResourceDescription = RegisterSampleApplicationsUtils.createComputeResourceDescription("localhost", "LocalHost", null, null);
            DataMovementInterface dataMovementInterface = new DataMovementInterface("localhost_data_movement_interface", DataMovementProtocol.LOCAL, 1);
            computeResourceDescription.addToDataMovementInterfaces(dataMovementInterface);
            JobSubmissionInterface jobSubmissionInterface = new JobSubmissionInterface("localhost_job_submission_interface", JobSubmissionProtocol.LOCAL, 1);
            computeResourceDescription.addToJobSubmissionInterfaces(jobSubmissionInterface);
            this.localhostId = this.airavataClient.registerComputeResource(new AuthzToken(""), computeResourceDescription);
            ResourceJobManager resourceJobManager = RegisterSampleApplicationsUtils.createResourceJobManager(ResourceJobManagerType.FORK, null, null, null);
            LOCALSubmission submission = new LOCALSubmission();
            submission.setResourceJobManager(resourceJobManager);
            String localSubmission = this.airavataClient.addLocalSubmissionDetails(new AuthzToken(""), this.localhostId, 1, submission);
            System.out.println(localSubmission);
            System.out.println("LocalHost Resource Id is " + this.localhostId);
        }
        catch (TException e) {
            e.printStackTrace();
        }
    }

    private void registerGatewayProfile() throws TException {
        GatewayResourceProfile gatewayResourceProfile = new GatewayResourceProfile();
        ComputeResourcePreference localhostResourcePreference = RegisterSampleApplicationsUtils.createComputeResourcePreference(this.localhostId, this.gatewayId, false, null, null, null, "/tmp");
        gatewayResourceProfile.setGatewayID(this.gatewayId);
        gatewayResourceProfile.addToComputeResourcePreferences(localhostResourcePreference);
        this.airavataClient.registerGatewayResourceProfile(new AuthzToken(""), gatewayResourceProfile);
    }

    private void registerEchoModule() throws TException {
        this.echoModuleId = this.airavataClient.registerApplicationModule(new AuthzToken(""), this.gatewayId, RegisterSampleApplicationsUtils.createApplicationModule("Echo", "1.0", "Echo application description"));
    }

    private void registerEchoDeployment() throws TException {
        System.out.println("#### Registering Application Deployments on Localhost ####");
        String echoAppDeployId = this.airavataClient.registerApplicationDeployment(new AuthzToken(""), this.gatewayId, RegisterSampleApplicationsUtils.createApplicationDeployment(this.echoModuleId, this.localhostId, "/bin/echo", ApplicationParallelismType.SERIAL, "Echo application description", null, null, null));
        System.out.println("Successfully registered Echo application on localhost, application Id = " + echoAppDeployId);
    }

    private void registerEchoInterface() {
        try {
            System.out.println("#### Registering Echo Interface ####");
            ArrayList<String> appModules = new ArrayList<String>();
            appModules.add(this.echoModuleId);
            InputDataObjectType input1 = RegisterSampleApplicationsUtils.createAppInput("Input_to_Echo", "Hello World", DataType.STRING, null, 1, true, true, false, "A test string to Echo", null);
            ArrayList<InputDataObjectType> applicationInputs = new ArrayList<InputDataObjectType>();
            applicationInputs.add(input1);
            OutputDataObjectType output1 = RegisterSampleApplicationsUtils.createAppOutput("Echoed_Output", "", DataType.STRING, true, false, null);
            ArrayList<OutputDataObjectType> applicationOutputs = new ArrayList<OutputDataObjectType>();
            applicationOutputs.add(output1);
            this.echoInterfaceId = this.airavataClient.registerApplicationInterface(new AuthzToken(""), this.gatewayId, RegisterSampleApplicationsUtils.createApplicationInterfaceDescription("Echo", "Echo application description", appModules, applicationInputs, applicationOutputs));
            System.out.println("Echo Application Interface Id " + this.echoInterfaceId);
        }
        catch (TException e) {
            e.printStackTrace();
        }
    }

    private void createEchoExperiment() throws TException {
        Project project = new Project();
        project.setName("default-project");
        project.setOwner(this.userId);
        String projectId = this.airavataClient.createProject(new AuthzToken(""), this.gatewayId, project);
        ExperimentModel experimentModel = new ExperimentModel();
        experimentModel.setExperimentName("dummy-echo-experiment");
        experimentModel.setProjectId(projectId);
        experimentModel.setUserName(this.userId);
        experimentModel.setGatewayId(this.gatewayId);
        experimentModel.setExecutionId(this.echoInterfaceId);
        UserConfigurationDataModel userConfigurationDataModel = new UserConfigurationDataModel();
        ComputationalResourceSchedulingModel computationalResourceSchedulingModel = new ComputationalResourceSchedulingModel();
        computationalResourceSchedulingModel.setNodeCount(1);
        computationalResourceSchedulingModel.setTotalCPUCount(1);
        computationalResourceSchedulingModel.setTotalPhysicalMemory(512);
        computationalResourceSchedulingModel.setResourceHostId(this.localhostId);
        userConfigurationDataModel.setComputationalResourceScheduling(computationalResourceSchedulingModel);
        experimentModel.setUserConfigurationData(userConfigurationDataModel);
        ArrayList<InputDataObjectType> experimentInputs = new ArrayList<InputDataObjectType>();
        experimentInputs.add(RegisterSampleApplicationsUtils.createAppInput("Input_to_Echo", "Hello World", DataType.STRING, null, 1, true, true, false, "A test string to Echo", null));
        experimentModel.setExperimentInputs(experimentInputs);
        experimentModel.setExperimentOutputs(this.airavataClient.getApplicationOutputs(new AuthzToken(""), this.echoInterfaceId));
        this.echoExperimentId = this.airavataClient.createExperiment(new AuthzToken(""), this.gatewayId, experimentModel);
    }
}

