/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtil {
    private static final Logger logger = LoggerFactory.getLogger(IOUtil.class);

    public static void writeToFile(String content, String path) throws IOException {
        logger.debug("Path:" + path + " Content:" + content);
        FileWriter fw = new FileWriter(path);
        IOUtil.writeToWriter(content, fw);
    }

    public static void writeToFile(String content, File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        IOUtil.writeToWriter(content, fw);
    }

    public static void writeToFile(InputStream inputStream, File file) throws IOException {
        int len;
        FileOutputStream outputStream = new FileOutputStream(file);
        byte[] bytes = new byte[1024];
        while ((len = inputStream.read(bytes)) != -1) {
            outputStream.write(bytes, 0, len);
        }
        outputStream.close();
    }

    public static void writeToWriter(String content, Writer writer) throws IOException {
        writer.write(content);
        writer.close();
    }

    public static String readFileToString(String path) throws IOException {
        FileReader read = new FileReader(path);
        return IOUtil.readToString(read);
    }

    public static String readFileToString(File file) throws IOException {
        FileReader reader = new FileReader(file);
        return IOUtil.readToString(reader);
    }

    public static String readToString(InputStream stream) throws IOException {
        return IOUtil.readToString(new InputStreamReader(stream));
    }

    public static String readToString(Reader reader) throws IOException {
        int len;
        char[] cbuf = new char[1024];
        StringBuilder sbuf = new StringBuilder();
        while ((len = reader.read(cbuf)) != -1) {
            sbuf.append(cbuf, 0, len);
        }
        return sbuf.toString();
    }

    public static byte[] readToByteArray(File file) throws IOException {
        return IOUtil.readToByteArray(new FileInputStream(file));
    }

    public static byte[] readToByteArray(InputStream inputStream) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        while ((len = inputStream.read(buf)) != -1) {
            byteArrayStream.write(buf, 0, len);
        }
        return byteArrayStream.toByteArray();
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files;
            for (File file : files = path.listFiles()) {
                if (file.isDirectory()) {
                    IOUtil.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        return path.delete();
    }

    public static String getExtension(File file) {
        String ext = null;
        String name = file.getName();
        int index = name.lastIndexOf(46);
        if (index > 0 && index < name.length() - 1) {
            ext = name.substring(index + 1).toLowerCase();
        }
        return ext;
    }
}

