/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.gigaspaces.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.jini.core.entry.Entry;
import org.apache.lucene.store.BufferedIndexOutput;
import org.compass.needle.gigaspaces.store.FileBucketEntry;
import org.compass.needle.gigaspaces.store.FileEntry;
import org.compass.needle.gigaspaces.store.GigaSpaceDirectory;
import org.compass.needle.gigaspaces.store.GigaSpaceDirectoryException;

class GigaSpaceFileIndexOutput
extends BufferedIndexOutput {
    private GigaSpaceDirectory dir;
    private File tempFile;
    private RandomAccessFile file = null;
    private String fileName;
    private boolean isOpen;

    public GigaSpaceFileIndexOutput(GigaSpaceDirectory dir, String fileName) throws IOException {
        this.dir = dir;
        this.fileName = fileName;
        this.tempFile = File.createTempFile(dir.getIndexName() + "_" + fileName + "_" + System.currentTimeMillis(), ".lucene-gigaspacesdir");
        this.file = new RandomAccessFile(this.tempFile, "rw");
        this.isOpen = true;
    }

    public void flushBuffer(byte[] b, int offset, int size) throws IOException {
        this.file.write(b, offset, size);
    }

    public void close() throws IOException {
        if (this.isOpen) {
            super.close();
            if (this.fileName.equals("segments.gen")) {
                this.dir.deleteFile(this.fileName);
            }
            this.file.seek(0L);
            byte[] buffer = new byte[this.dir.getBucketSize()];
            int offset = 0;
            int length = this.dir.getBucketSize();
            long bucketIndex = 0L;
            while (true) {
                int sizeRead;
                if ((sizeRead = this.file.read(buffer, offset, length)) == -1) break;
                offset += sizeRead;
                if ((length -= sizeRead) > 0) continue;
                this.flushBucket(bucketIndex++, buffer, this.dir.getBucketSize());
                offset = 0;
                length = this.dir.getBucketSize();
            }
            this.flushBucket(bucketIndex, buffer, offset);
            try {
                this.dir.getSpace().write((Entry)new FileEntry(this.dir.getIndexName(), this.fileName, this.file.length()), null, Long.MAX_VALUE);
            }
            catch (Exception e) {
                throw new GigaSpaceDirectoryException(this.dir.getIndexName(), this.fileName, "Failed to write file entry", e);
            }
            this.file.close();
            this.tempFile.delete();
            this.isOpen = false;
        }
    }

    public void seek(long pos) throws IOException {
        super.seek(pos);
        this.file.seek(pos);
    }

    public long length() throws IOException {
        return this.file.length();
    }

    private void flushBucket(long bucketIndex, byte[] buffer, int length) throws IOException {
        FileBucketEntry fileBucketEntry = new FileBucketEntry(this.dir.getIndexName(), this.fileName, bucketIndex, null);
        fileBucketEntry.data = new byte[length];
        System.arraycopy(buffer, 0, fileBucketEntry.data, 0, length);
        try {
            this.dir.getSpace().write((Entry)fileBucketEntry, null, Long.MAX_VALUE);
        }
        catch (Exception e) {
            throw new GigaSpaceDirectoryException(this.dir.getIndexName(), this.fileName, "Failed to write bucket [" + bucketIndex + "]", e);
        }
    }
}

